/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.repositoryconnectorpool;

import org.apache.manifoldcf.core.connectorpool.ConnectorPool;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.interfaces.ConnectorManagerFactory;
import org.apache.manifoldcf.crawler.interfaces.IConnectorManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnector;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectorPool;
import org.apache.manifoldcf.crawler.interfaces.RepositoryConnectionManagerFactory;

public class RepositoryConnectorPool
implements IRepositoryConnectorPool {
    public static final String _rcsid = "@(#)$Id: RepositoryConnectorPool.java 1549105 2013-12-08 18:54:09Z kwright $";
    protected static final LocalPool localPool = new LocalPool();
    protected final IThreadContext threadContext;

    public RepositoryConnectorPool(IThreadContext threadContext) throws ManifoldCFException {
        this.threadContext = threadContext;
    }

    @Override
    public IRepositoryConnector[] grabMultiple(String[] orderingKeys, IRepositoryConnection[] repositoryConnections) throws ManifoldCFException {
        String[] connectionNames = new String[repositoryConnections.length];
        String[] classNames = new String[repositoryConnections.length];
        ConfigParams[] configInfos = new ConfigParams[repositoryConnections.length];
        int[] maxPoolSizes = new int[repositoryConnections.length];
        for (int i = 0; i < repositoryConnections.length; ++i) {
            connectionNames[i] = repositoryConnections[i].getName();
            classNames[i] = repositoryConnections[i].getClassName();
            configInfos[i] = repositoryConnections[i].getConfigParams();
            maxPoolSizes[i] = repositoryConnections[i].getMaxConnections();
        }
        return localPool.grabMultiple(this.threadContext, orderingKeys, connectionNames, classNames, configInfos, maxPoolSizes);
    }

    @Override
    public IRepositoryConnector grab(IRepositoryConnection repositoryConnection) throws ManifoldCFException {
        return (IRepositoryConnector)localPool.grab(this.threadContext, repositoryConnection.getName(), repositoryConnection.getClassName(), repositoryConnection.getConfigParams(), repositoryConnection.getMaxConnections());
    }

    @Override
    public void releaseMultiple(IRepositoryConnection[] connections, IRepositoryConnector[] connectors) throws ManifoldCFException {
        String[] connectionNames = new String[connections.length];
        for (int i = 0; i < connections.length; ++i) {
            connectionNames[i] = connections[i].getName();
        }
        localPool.releaseMultiple(this.threadContext, connectionNames, connectors);
    }

    @Override
    public void release(IRepositoryConnection connection, IRepositoryConnector connector) throws ManifoldCFException {
        localPool.release(this.threadContext, connection.getName(), connector);
    }

    @Override
    public void pollAllConnectors() throws ManifoldCFException {
        localPool.pollAllConnectors(this.threadContext);
    }

    @Override
    public void flushUnusedConnectors() throws ManifoldCFException {
        localPool.flushUnusedConnectors(this.threadContext);
    }

    @Override
    public void closeAllConnectors() throws ManifoldCFException {
        localPool.closeAllConnectors(this.threadContext);
    }

    protected static class LocalPool
    extends ConnectorPool<IRepositoryConnector> {
        public LocalPool() {
            super("_REPOSITORYCONNECTORPOOL_");
        }

        protected boolean isInstalled(IThreadContext tc, String className) throws ManifoldCFException {
            IConnectorManager connectorManager = ConnectorManagerFactory.make(tc);
            return connectorManager.isInstalled(className);
        }

        protected boolean isConnectionNameValid(IThreadContext tc, String connectionName) throws ManifoldCFException {
            IRepositoryConnectionManager connectionManager = RepositoryConnectionManagerFactory.make(tc);
            return connectionManager.load(connectionName) != null;
        }

        public IRepositoryConnector[] grabMultiple(IThreadContext tc, String[] orderingKeys, String[] connectionNames, String[] classNames, ConfigParams[] configInfos, int[] maxPoolSizes) throws ManifoldCFException {
            return (IRepositoryConnector[])this.grabMultiple(tc, IRepositoryConnector.class, orderingKeys, connectionNames, classNames, configInfos, maxPoolSizes);
        }
    }
}

