/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.xact;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.store.access.TransactionInfo;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.impl.store.raw.xact.GlobalXactId;
import org.apache.derby.impl.store.raw.xact.TransactionMapFactory;
import org.apache.derby.impl.store.raw.xact.TransactionTableEntry;
import org.apache.derby.impl.store.raw.xact.Xact;
import org.apache.derby.impl.store.raw.xact.XactFactory;
import org.apache.derby.impl.store.raw.xact.XactId;

public class TransactionTable
implements Formatable {
    private final TransactionMapFactory mapFactory = XactFactory.getMapFactory();
    private final Map trans = this.mapFactory.newMap();
    private TransactionId largestUpdateXactId;

    private TransactionTableEntry findTransactionEntry(TransactionId transactionId) {
        return (TransactionTableEntry)this.trans.get(transactionId);
    }

    void visitEntries(EntryVisitor entryVisitor) {
        this.mapFactory.visitEntries(this.trans, entryVisitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(Xact xact, boolean bl) {
        TransactionId transactionId = xact.getId();
        TransactionTableEntry transactionTableEntry = new TransactionTableEntry(xact, transactionId, 0, bl ? 4 : 0);
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            TransactionTableEntry transactionTableEntry2 = this.trans.put(transactionId, transactionTableEntry);
        }
    }

    boolean remove(TransactionId transactionId) {
        TransactionTableEntry transactionTableEntry = (TransactionTableEntry)this.trans.remove(transactionId);
        return transactionTableEntry == null || transactionTableEntry.needExclusion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdateTransaction(TransactionId transactionId, RawTransaction rawTransaction, int n) {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            TransactionTableEntry transactionTableEntry = this.findTransactionEntry(transactionId);
            if (transactionTableEntry != null) {
                transactionTableEntry.updateTransactionStatus((Xact)rawTransaction, n, 1);
            } else {
                transactionTableEntry = new TransactionTableEntry((Xact)rawTransaction, transactionId, n, 7);
                this.trans.put(transactionId, transactionTableEntry);
            }
            if (XactId.compare(transactionTableEntry.getXid(), this.largestUpdateXactId) > 0L) {
                this.largestUpdateXactId = transactionTableEntry.getXid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUpdateTransaction(TransactionId transactionId) {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            TransactionTableEntry transactionTableEntry = this.findTransactionEntry(transactionId);
            transactionTableEntry.removeUpdateTransaction();
            if (transactionTableEntry.isRecovery()) {
                this.remove(transactionId);
            }
        }
    }

    void prepareTransaction(TransactionId transactionId) {
        TransactionTableEntry transactionTableEntry = this.findTransactionEntry(transactionId);
        transactionTableEntry.prepareTransaction();
    }

    public ContextManager findTransactionContextByGlobalId(final GlobalXactId globalXactId) {
        final ContextManager[] contextManagerArray = new ContextManager[1];
        this.visitEntries(new EntryVisitor(){

            public boolean visit(TransactionTableEntry transactionTableEntry) {
                GlobalTransactionId globalTransactionId = transactionTableEntry.getGid();
                if (globalTransactionId != null && globalTransactionId.equals(globalXactId)) {
                    contextManagerArray[0] = transactionTableEntry.getXact().getContextManager();
                }
                return contextManagerArray[0] == null;
            }
        });
        return contextManagerArray[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasActiveUpdateTransaction() {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            UpdateTransactionCounter updateTransactionCounter = new UpdateTransactionCounter(true);
            this.visitEntries(updateTransactionCounter);
            return updateTransactionCounter.getCount() > 0;
        }
    }

    public int getTypeFormatId() {
        return 262;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeExternal(final ObjectOutput objectOutput) throws IOException {
        TransactionTable transactionTable = this;
        synchronized (transactionTable) {
            UpdateTransactionCounter updateTransactionCounter = new UpdateTransactionCounter(false);
            this.visitEntries(updateTransactionCounter);
            int n = updateTransactionCounter.getCount();
            CompressedNumber.writeInt(objectOutput, n);
            if (n > 0) {
                final int[] nArray = null;
                final IOException[] iOExceptionArray = new IOException[1];
                this.visitEntries(new EntryVisitor(){

                    public boolean visit(TransactionTableEntry transactionTableEntry) {
                        try {
                            if (transactionTableEntry.isUpdate()) {
                                objectOutput.writeObject(transactionTableEntry);
                            }
                        }
                        catch (IOException iOException) {
                            iOExceptionArray[0] = iOException;
                            return false;
                        }
                        return true;
                    }
                });
                if (iOExceptionArray[0] != null) {
                    throw iOExceptionArray[0];
                }
            }
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = CompressedNumber.readInt(objectInput);
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            TransactionTableEntry transactionTableEntry = (TransactionTableEntry)objectInput.readObject();
            this.trans.put(transactionTableEntry.getXid(), transactionTableEntry);
            if (!transactionTableEntry.isUpdate() || XactId.compare(transactionTableEntry.getXid(), this.largestUpdateXactId) <= 0L) continue;
            this.largestUpdateXactId = transactionTableEntry.getXid();
        }
    }

    public TransactionId largestUpdateXactId() {
        return this.largestUpdateXactId;
    }

    public boolean hasRollbackFirstTransaction() {
        Iterator iterator = this.trans.values().iterator();
        while (iterator.hasNext()) {
            TransactionTableEntry transactionTableEntry = (TransactionTableEntry)iterator.next();
            if (transactionTableEntry == null || !transactionTableEntry.isRecovery() || (transactionTableEntry.getTransactionStatus() & 0x10) == 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasPreparedRecoveredXact() {
        return this.hasPreparedXact(true);
    }

    public boolean hasPreparedXact() {
        return this.hasPreparedXact(false);
    }

    private boolean hasPreparedXact(boolean bl) {
        Iterator iterator = this.trans.values().iterator();
        while (iterator.hasNext()) {
            TransactionTableEntry transactionTableEntry = (TransactionTableEntry)iterator.next();
            if (transactionTableEntry == null || (transactionTableEntry.getTransactionStatus() & 2) == 0) continue;
            if (bl) {
                if (!transactionTableEntry.isRecovery()) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public boolean getMostRecentRollbackFirstTransaction(RawTransaction rawTransaction) {
        if (this.trans.isEmpty()) {
            return this.findAndAssumeTransaction(null, rawTransaction);
        }
        TransactionId transactionId = null;
        Iterator iterator = this.trans.values().iterator();
        while (iterator.hasNext()) {
            TransactionTableEntry transactionTableEntry = (TransactionTableEntry)iterator.next();
            if (transactionTableEntry == null || !transactionTableEntry.isUpdate() || !transactionTableEntry.isRecovery() || (transactionTableEntry.getTransactionStatus() & 0x10) == 0 || transactionId != null && XactId.compare(transactionId, transactionTableEntry.getXid()) >= 0L) continue;
            transactionId = transactionTableEntry.getXid();
        }
        if (transactionId == null) {
            return this.findAndAssumeTransaction(transactionId, rawTransaction);
        }
        boolean bl = this.findAndAssumeTransaction(transactionId, rawTransaction);
        return true;
    }

    public boolean getMostRecentTransactionForRollback(RawTransaction rawTransaction) {
        TransactionId transactionId = null;
        if (!this.trans.isEmpty()) {
            Iterator iterator = this.trans.values().iterator();
            while (iterator.hasNext()) {
                TransactionTableEntry transactionTableEntry = (TransactionTableEntry)iterator.next();
                if (transactionTableEntry == null || !transactionTableEntry.isUpdate() || !transactionTableEntry.isRecovery() || transactionTableEntry.isPrepared() || transactionId != null && XactId.compare(transactionId, transactionTableEntry.getXid()) >= 0L) continue;
                transactionId = transactionTableEntry.getXid();
            }
        }
        return this.findAndAssumeTransaction(transactionId, rawTransaction);
    }

    public boolean getMostRecentPreparedRecoveredXact(RawTransaction rawTransaction) {
        TransactionTableEntry transactionTableEntry = null;
        if (!this.trans.isEmpty()) {
            TransactionId transactionId = null;
            GlobalTransactionId globalTransactionId = null;
            Object object = this.trans.values().iterator();
            while (object.hasNext()) {
                TransactionTableEntry transactionTableEntry2 = (TransactionTableEntry)object.next();
                if (transactionTableEntry2 == null || !transactionTableEntry2.isRecovery() || !transactionTableEntry2.isPrepared() || transactionId != null && XactId.compare(transactionId, transactionTableEntry2.getXid()) >= 0L) continue;
                transactionTableEntry = transactionTableEntry2;
                transactionId = transactionTableEntry2.getXid();
                globalTransactionId = transactionTableEntry2.getGid();
            }
            if (transactionTableEntry != null) {
                object = (TransactionTableEntry)this.trans.remove(rawTransaction.getId());
                ((Xact)rawTransaction).assumeGlobalXactIdentity(transactionTableEntry);
                transactionTableEntry.unsetRecoveryStatus();
            }
        }
        return transactionTableEntry != null;
    }

    public LogInstant getFirstLogInstant() {
        if (this.trans.isEmpty()) {
            return null;
        }
        final LogInstant[] logInstantArray = new LogInstant[1];
        this.visitEntries(new EntryVisitor(){

            public boolean visit(TransactionTableEntry transactionTableEntry) {
                if (transactionTableEntry.isUpdate() && (logInstantArray[0] == null || transactionTableEntry.getFirstLog().lessThan(logInstantArray[0]))) {
                    logInstantArray[0] = transactionTableEntry.getFirstLog();
                }
                return true;
            }
        });
        return logInstantArray[0];
    }

    boolean findAndAssumeTransaction(TransactionId transactionId, RawTransaction rawTransaction) {
        TransactionTableEntry transactionTableEntry = null;
        if (transactionId != null && !this.trans.isEmpty()) {
            transactionTableEntry = this.findTransactionEntry(transactionId);
        }
        ((Xact)rawTransaction).assumeIdentity(transactionTableEntry);
        return transactionTableEntry != null;
    }

    public TransactionInfo[] getTransactionInfo() {
        if (this.trans.isEmpty()) {
            return null;
        }
        final ArrayList arrayList = new ArrayList();
        this.visitEntries(new EntryVisitor(){

            public boolean visit(TransactionTableEntry transactionTableEntry) {
                arrayList.add(transactionTableEntry.clone());
                return true;
            }
        });
        return arrayList.toArray(new TransactionTableEntry[arrayList.size()]);
    }

    public String toString() {
        return null;
    }

    private static class UpdateTransactionCounter
    implements EntryVisitor {
        private final boolean stopOnFirst;
        private int count;

        UpdateTransactionCounter(boolean bl) {
            this.stopOnFirst = bl;
        }

        public boolean visit(TransactionTableEntry transactionTableEntry) {
            if (transactionTableEntry.isUpdate()) {
                ++this.count;
            }
            return !this.stopOnFirst || this.count == 0;
        }

        int getCount() {
            return this.count;
        }
    }

    static interface EntryVisitor {
        public boolean visit(TransactionTableEntry var1);
    }
}

