/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.cache.ClassSize;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataType;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.iapi.types.SQLBoolean;

public final class SQLLongint
extends NumberDataType {
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLLongint.class);
    private long value;
    private boolean isnull;

    public int getInt() throws StandardException {
        if (this.value > Integer.MAX_VALUE || this.value < Integer.MIN_VALUE) {
            throw StandardException.newException("22003", "INTEGER");
        }
        return (int)this.value;
    }

    public byte getByte() throws StandardException {
        if (this.value > 127L || this.value < -128L) {
            throw StandardException.newException("22003", "TINYINT");
        }
        return (byte)this.value;
    }

    public short getShort() throws StandardException {
        if (this.value > 32767L || this.value < -32768L) {
            throw StandardException.newException("22003", "SMALLINT");
        }
        return (short)this.value;
    }

    public long getLong() {
        return this.value;
    }

    public float getFloat() {
        return this.value;
    }

    public double getDouble() {
        return this.value;
    }

    public boolean getBoolean() {
        return this.value != 0L;
    }

    public String getString() {
        if (this.isNull()) {
            return null;
        }
        return Long.toString(this.value);
    }

    public Object getObject() {
        if (this.isNull()) {
            return null;
        }
        return new Long(this.value);
    }

    public int getLength() {
        return 8;
    }

    public String getTypeName() {
        return "BIGINT";
    }

    public int getTypeFormatId() {
        return 84;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.value);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        this.value = objectInput.readLong();
        this.isnull = false;
    }

    public void restoreToNull() {
        this.value = 0L;
        this.isnull = true;
    }

    protected int typeCompare(DataValueDescriptor dataValueDescriptor) throws StandardException {
        long l;
        long l2 = this.getLong();
        if (l2 == (l = dataValueDescriptor.getLong())) {
            return 0;
        }
        if (l2 > l) {
            return 1;
        }
        return -1;
    }

    public DataValueDescriptor cloneValue(boolean bl) {
        return new SQLLongint(this.value, this.isnull);
    }

    public DataValueDescriptor getNewNull() {
        return new SQLLongint();
    }

    public void setValueFromResultSet(ResultSet resultSet, int n, boolean bl) throws SQLException {
        this.value = resultSet.getLong(n);
        this.isnull = this.value == 0L ? bl && resultSet.wasNull() : false;
    }

    public final void setInto(PreparedStatement preparedStatement, int n) throws SQLException {
        if (this.isNull()) {
            preparedStatement.setNull(n, -5);
            return;
        }
        preparedStatement.setLong(n, this.value);
    }

    public final void setInto(ResultSet resultSet, int n) throws SQLException {
        resultSet.updateLong(n, this.value);
    }

    public SQLLongint() {
        this.isnull = true;
    }

    public SQLLongint(long l) {
        this.value = l;
    }

    private SQLLongint(long l, boolean bl) {
        this.value = l;
        this.isnull = bl;
    }

    public SQLLongint(Long l) {
        this.isnull = l == null;
        if (!this.isnull) {
            this.value = l;
        }
    }

    public void setValue(String string) throws StandardException {
        if (string == null) {
            this.value = 0L;
            this.isnull = true;
        } else {
            try {
                this.value = Long.valueOf(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw this.invalidFormat();
            }
            this.isnull = false;
        }
    }

    public final void setValue(Number number) {
        if (this.objectNull(number)) {
            return;
        }
        this.setValue(number.longValue());
    }

    public void setValue(long l) {
        this.value = l;
        this.isnull = false;
    }

    public void setValue(int n) {
        this.value = n;
        this.isnull = false;
    }

    public void setValue(float f) throws StandardException {
        if ((f = NumberDataType.normalizeREAL(f)) > 9.223372E18f || f < -9.223372E18f) {
            throw StandardException.newException("22003", "BIGINT");
        }
        float f2 = (float)Math.floor(f);
        this.value = (long)f2;
        this.isnull = false;
    }

    public void setValue(double d) throws StandardException {
        if ((d = NumberDataType.normalizeDOUBLE(d)) > 9.223372036854776E18 || d < -9.223372036854776E18) {
            throw StandardException.newException("22003", "BIGINT");
        }
        double d2 = Math.floor(d);
        this.value = (long)d2;
        this.isnull = false;
    }

    public void setValue(boolean bl) {
        this.value = bl ? 1L : 0L;
        this.isnull = false;
    }

    void setObject(Object object) {
        this.setValue((Long)object);
    }

    protected void setFrom(DataValueDescriptor dataValueDescriptor) throws StandardException {
        this.setValue(dataValueDescriptor.getLong());
    }

    public int typePrecedence() {
        return 60;
    }

    public BooleanDataValue equals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getLong() == dataValueDescriptor2.getLong());
    }

    public BooleanDataValue notEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getLong() != dataValueDescriptor2.getLong());
    }

    public BooleanDataValue lessThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getLong() < dataValueDescriptor2.getLong());
    }

    public BooleanDataValue greaterThan(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getLong() > dataValueDescriptor2.getLong());
    }

    public BooleanDataValue lessOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getLong() <= dataValueDescriptor2.getLong());
    }

    public BooleanDataValue greaterOrEquals(DataValueDescriptor dataValueDescriptor, DataValueDescriptor dataValueDescriptor2) throws StandardException {
        return SQLBoolean.truthValue(dataValueDescriptor, dataValueDescriptor2, dataValueDescriptor.getLong() >= dataValueDescriptor2.getLong());
    }

    public NumberDataValue plus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLLongint();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        long l = numberDataValue.getLong();
        long l2 = numberDataValue2.getLong();
        long l3 = l + l2;
        if (l < 0L == l2 < 0L && l < 0L != l3 < 0L) {
            throw StandardException.newException("22003", "BIGINT");
        }
        numberDataValue3.setValue(l3);
        return numberDataValue3;
    }

    public NumberDataValue minus(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLLongint();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        long l = numberDataValue.getLong() - numberDataValue2.getLong();
        if (numberDataValue.getLong() < 0L != numberDataValue2.getLong() < 0L && numberDataValue.getLong() < 0L != l < 0L) {
            throw StandardException.newException("22003", "BIGINT");
        }
        numberDataValue3.setValue(l);
        return numberDataValue3;
    }

    public NumberDataValue times(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLLongint();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        long l = numberDataValue.getLong() * numberDataValue2.getLong();
        if (numberDataValue2.getLong() != 0L && numberDataValue.getLong() != l / numberDataValue2.getLong()) {
            throw StandardException.newException("22003", "BIGINT");
        }
        numberDataValue3.setValue(l);
        return numberDataValue3;
    }

    public NumberDataValue divide(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLLongint();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        long l = numberDataValue2.getLong();
        if (l == 0L) {
            throw StandardException.newException("22012");
        }
        numberDataValue3.setValue(numberDataValue.getLong() / l);
        return numberDataValue3;
    }

    public NumberDataValue mod(NumberDataValue numberDataValue, NumberDataValue numberDataValue2, NumberDataValue numberDataValue3) throws StandardException {
        if (numberDataValue3 == null) {
            numberDataValue3 = new SQLLongint();
        }
        if (numberDataValue.isNull() || numberDataValue2.isNull()) {
            numberDataValue3.setToNull();
            return numberDataValue3;
        }
        long l = numberDataValue2.getLong();
        if (l == 0L) {
            throw StandardException.newException("22012");
        }
        numberDataValue3.setValue(numberDataValue.getLong() % l);
        return numberDataValue3;
    }

    public NumberDataValue minus(NumberDataValue numberDataValue) throws StandardException {
        if (numberDataValue == null) {
            numberDataValue = new SQLLongint();
        }
        if (this.isNull()) {
            numberDataValue.setToNull();
            return numberDataValue;
        }
        long l = this.getLong();
        if (l == Long.MIN_VALUE) {
            throw StandardException.newException("22003", "BIGINT");
        }
        numberDataValue.setValue(-l);
        return numberDataValue;
    }

    protected boolean isNegative() {
        return !this.isNull() && this.value < 0L;
    }

    public String toString() {
        if (this.isNull()) {
            return "NULL";
        }
        return Long.toString(this.value);
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    public int estimateMemoryUsage() {
        return BASE_MEMORY_USAGE;
    }
}

