/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.ldap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.authorities.ldap.Messages;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.system.ManifoldCF;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigNode;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.ICacheCreateHandle;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.ui.util.Encoder;

public class LDAPAuthority
extends BaseAuthorityConnector {
    public static final String _rcsid = "@(#)$Id: LDAPAuthority.java 1549105 2013-12-08 18:54:09Z kwright $";
    private LdapContext session = null;
    private long sessionExpirationTime = -1L;
    private ConfigParams parameters;
    private String serverName;
    private String serverPort;
    private String serverBase;
    private String userBase;
    private String userSearch;
    private String groupBase;
    private String groupSearch;
    private String groupNameAttr;
    private boolean groupMemberDN;
    private boolean addUserRecord;
    private List<String> forcedTokens;
    private String userNameAttr;
    private long responseLifetime = 60000L;
    private int LRUsize = 1000;
    private ICacheManager cacheManager = null;
    protected static StringSet emptyStringSet = new StringSet();

    public void setThreadContext(IThreadContext tc) throws ManifoldCFException {
        super.setThreadContext(tc);
        this.cacheManager = CacheManagerFactory.make((IThreadContext)tc);
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.parameters = configParams;
        this.serverName = configParams.getParameter("ldapServerName");
        this.serverPort = configParams.getParameter("ldapServerPort");
        this.serverBase = configParams.getParameter("ldapServerBase");
        this.userBase = configParams.getParameter("ldapUserBase");
        this.userSearch = configParams.getParameter("ldapUserSearch");
        this.groupBase = configParams.getParameter("ldapGroupBase");
        this.groupSearch = configParams.getParameter("ldapGroupSearch");
        this.groupNameAttr = configParams.getParameter("ldapGroupNameAttr");
        this.userNameAttr = configParams.getParameter("ldapUserNameAttr");
        this.groupMemberDN = "1".equals(this.getParam(configParams, "ldapGroupMemberDn", ""));
        this.addUserRecord = "1".equals(this.getParam(configParams, "ldapAddUserRecord", ""));
        this.forcedTokens = new ArrayList<String>();
        int i = 0;
        while (i < this.parameters.getChildCount()) {
            ConfigNode sn;
            if (!(sn = this.parameters.getChild(i++)).getType().equals("access")) continue;
            String token = "" + sn.getAttributeValue("token");
            this.forcedTokens.add(token);
        }
    }

    protected LdapContext getSession() throws ManifoldCFException {
        String bindPass;
        String bindUser;
        Hashtable<String, String> env;
        block18: {
            if (this.serverName == null || this.serverName.length() == 0) {
                throw new ManifoldCFException("Server name parameter missing but required");
            }
            if (this.serverPort == null || this.serverPort.length() == 0) {
                throw new ManifoldCFException("Server port parameter missing but required");
            }
            if (this.serverBase == null) {
                throw new ManifoldCFException("Server base parameter missing but required");
            }
            if (this.userBase == null) {
                throw new ManifoldCFException("User base parameter missing but required");
            }
            if (this.userSearch == null || this.userSearch.length() == 0) {
                throw new ManifoldCFException("User search expression missing but required");
            }
            if (this.groupBase == null) {
                throw new ManifoldCFException("Group base parameter missing but required");
            }
            if (this.groupSearch == null || this.groupSearch.length() == 0) {
                throw new ManifoldCFException("Group search expression missing but required");
            }
            if (this.groupNameAttr == null || this.groupNameAttr.length() == 0) {
                throw new ManifoldCFException("Group name attribute missing but required");
            }
            if (this.userNameAttr == null || this.userNameAttr.length() == 0) {
                throw new ManifoldCFException("User name attribute missing but required");
            }
            env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.provider.url", "ldap://" + this.serverName + ":" + this.serverPort + "/" + this.serverBase);
            bindUser = this.getParam(this.parameters, "ldapBindUser", "");
            bindPass = "";
            try {
                bindPass = ManifoldCF.deobfuscate((String)this.getParam(this.parameters, "ldapBindPass", ""));
            }
            catch (ManifoldCFException ex) {
                if (bindUser.isEmpty()) break block18;
                Logger.getLogger(LDAPAuthority.class.getName()).log(Level.SEVERE, "Deobfuscation error", ex);
            }
        }
        if (!bindUser.isEmpty()) {
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", bindUser);
            env.put("java.naming.security.credentials", bindPass);
        }
        try {
            if (this.session == null) {
                this.session = new InitialLdapContext(env, null);
            } else {
                this.session.reconnect(null);
            }
            this.sessionExpirationTime = System.currentTimeMillis() + 300000L;
            return this.session;
        }
        catch (AuthenticationException e) {
            this.session = null;
            this.sessionExpirationTime = -1L;
            throw new ManifoldCFException("Authentication error: " + e.getMessage() + ", explanation: " + e.getExplanation(), (Throwable)e);
        }
        catch (CommunicationException e) {
            this.session = null;
            this.sessionExpirationTime = -1L;
            throw new ManifoldCFException("Communication error: " + e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            this.session = null;
            this.sessionExpirationTime = -1L;
            throw new ManifoldCFException("Naming error: " + e.getMessage(), (Throwable)e);
        }
    }

    public String check() throws ManifoldCFException {
        this.disconnectSession();
        this.getSession();
        return super.check();
    }

    public boolean isConnected() {
        return this.session != null;
    }

    public void poll() throws ManifoldCFException {
        if (this.session != null && System.currentTimeMillis() > this.sessionExpirationTime) {
            this.disconnectSession();
        }
        super.poll();
    }

    protected void disconnectSession() {
        if (this.session != null) {
            try {
                this.session.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.session = null;
            this.sessionExpirationTime = -1L;
        }
    }

    public void disconnect() throws ManifoldCFException {
        this.disconnectSession();
        super.disconnect();
        this.serverName = null;
        this.serverPort = null;
        this.serverBase = null;
        this.userBase = null;
        this.userSearch = null;
        this.groupBase = null;
        this.groupSearch = null;
        this.groupNameAttr = null;
        this.userNameAttr = null;
        this.forcedTokens = null;
    }

    protected String createCacheConnectionString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.serverName).append(":").append(this.serverPort).append("/").append(this.serverBase);
        return sb.toString();
    }

    protected String createUserSearchString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.userBase).append("|").append(this.userSearch).append("|").append(this.userNameAttr).append("|").append(this.addUserRecord ? (char)'Y' : 'N');
        return sb.toString();
    }

    protected String createGroupSearchString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupBase).append("|").append(this.groupSearch).append("|").append(this.groupNameAttr).append("|").append(this.groupMemberDN ? (char)'Y' : 'N');
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResponse getAuthorizationResponse(String userName) throws ManifoldCFException {
        this.getSession();
        LdapAuthorizationResponseDescription objectDescription = new LdapAuthorizationResponseDescription(userName, this.createCacheConnectionString(), this.createUserSearchString(), this.createGroupSearchString(), this.responseLifetime, this.LRUsize);
        ICacheHandle ch = this.cacheManager.enterCache(new ICacheDescription[]{objectDescription}, null, null);
        try {
            AuthorizationResponse response;
            ICacheCreateHandle createHandle;
            block8: {
                AuthorizationResponse authorizationResponse;
                createHandle = this.cacheManager.enterCreateSection(ch);
                try {
                    response = (AuthorizationResponse)this.cacheManager.lookupObject(createHandle, (ICacheDescription)objectDescription);
                    if (response == null) break block8;
                    authorizationResponse = response;
                }
                catch (Throwable throwable) {
                    this.cacheManager.leaveCreateSection(createHandle);
                    throw throwable;
                }
                this.cacheManager.leaveCreateSection(createHandle);
                return authorizationResponse;
            }
            response = this.getAuthorizationResponseUncached(userName);
            this.cacheManager.saveObject(createHandle, (ICacheDescription)objectDescription, (Object)response);
            AuthorizationResponse authorizationResponse = response;
            this.cacheManager.leaveCreateSection(createHandle);
            return authorizationResponse;
        }
        finally {
            this.cacheManager.leaveCache(ch);
        }
    }

    protected AuthorizationResponse getAuthorizationResponseUncached(String userName) throws ManifoldCFException {
        this.getSession();
        try {
            Attribute attr;
            SearchResult usrRecord = this.getUserEntry(this.session, userName);
            if (usrRecord == null) {
                return RESPONSE_USERNOTFOUND;
            }
            ArrayList<String> theGroups = new ArrayList<String>();
            theGroups.addAll(this.forcedTokens);
            String usrName = userName.split("@")[0];
            if (this.userNameAttr != null && !"".equals(this.userNameAttr) && usrRecord.getAttributes() != null && (attr = usrRecord.getAttributes().get(this.userNameAttr)) != null) {
                usrName = attr.get().toString();
                if (this.addUserRecord) {
                    NamingEnumeration<?> values = attr.getAll();
                    while (values.hasMore()) {
                        theGroups.add(values.next().toString());
                    }
                }
            }
            if (this.groupSearch != null && !this.groupSearch.isEmpty()) {
                String searchFilter = this.groupSearch.replaceAll("\\{0\\}", LDAPAuthority.escapeLDAPSearchFilter(this.groupMemberDN ? usrRecord.getNameInNamespace() : usrName));
                SearchControls searchCtls = new SearchControls();
                searchCtls.setSearchScope(2);
                String[] returnedAtts = new String[]{this.groupNameAttr};
                searchCtls.setReturningAttributes(returnedAtts);
                NamingEnumeration<SearchResult> answer = this.session.search(this.groupBase, searchFilter, searchCtls);
                while (answer.hasMoreElements()) {
                    SearchResult sr = answer.next();
                    Attributes attrs = sr.getAttributes();
                    if (attrs == null) continue;
                    NamingEnumeration<?> values = attrs.get(this.groupNameAttr).getAll();
                    while (values.hasMore()) {
                        theGroups.add(values.next().toString());
                    }
                }
            }
            String[] tokens = new String[theGroups.size()];
            for (int k = 0; k < tokens.length; ++k) {
                tokens[k] = (String)theGroups.get(k);
            }
            return new AuthorizationResponse(tokens, 0);
        }
        catch (NameNotFoundException e) {
            return RESPONSE_USERNOTFOUND;
        }
        catch (NamingException e) {
            return RESPONSE_UNREACHABLE;
        }
    }

    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        return RESPONSE_UNREACHABLE;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "LDAP.ForcedTokens"));
        tabsArray.add(Messages.getString(locale, "LDAP.LDAP"));
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkConfig() {\n  if (editconnection.ldapServerName.value.indexOf(\"/\") != -1) {\n    alert(\"" + Messages.getBodyJavascriptString(locale, "LDAP.ServerNameCannotIncludeSlash") + "\");\n" + "    editconnection.ldapServerName.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.ldapServerPort.value != \"\" && !isInteger(editconnection.ldapServerPort.value)) {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LDAP.ServerPortMustBeAnInteger") + "\");\n" + "    editconnection.ldapServerPort.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.ldapServerBase.value.indexOf(\"/\") != -1) {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LDAP.ServerBaseCannotIncludeSlash") + "\");\n" + "    editconnection.ldapServerBase.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.ldapUserSearch.value != \"\" && editconnection.ldapUserSearch.value.indexOf(\"{0}\") == -1) {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LDAP.UserSearchMustIncludeSubstitution") + "\");\n" + "    editconnection.ldapUserSearch.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.ldapGroupSearch.value != \"\" && editconnection.ldapGroupSearch.value.indexOf(\"{0}\") == -1) {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LDAP.GroupSearchMustIncludeSubstitution") + "\");\n" + "    editconnection.ldapGroupSearch.focus();\n" + "    return false;\n" + "  }\n" + "  return true;\n" + "}\n" + "\n" + "function checkConfigForSave() {\n" + "  if (editconnection.ldapServerName.value == \"\") {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LDAP.ServerNameCannotBeBlank") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "LDAP.LDAP") + "\");\n" + "    editconnection.ldapServerName.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.ldapServerPort.value == \"\") {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LDAP.ServerPortCannotBeBlank") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "LDAP.LDAP") + "\");\n" + "    editconnection.ldapServerPort.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.ldapUserSearch.value == \"\") {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LDAP.UserSearchCannotBeBlank") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "LDAP.LDAP") + "\");\n" + "    editconnection.ldapUserSearch.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.ldapGroupSearch.value == \"\") {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LDAP.GroupSearchCannotBeBlank") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "LDAP.LDAP") + "\");\n" + "    editconnection.ldapGroupSearch.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.ldapGroupNameAttr.value == \"\") {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LDAP.GroupNameAttrCannotBeBlank") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "LDAP.LDAP") + "\");\n" + "    editconnection.ldapGroupNameAttr.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.ldapUserSearch.value != \"\" && editconnection.ldapUserSearch.value.indexOf(\"{0}\") == -1) {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LDAP.UserSearchMustIncludeSubstitution") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "LDAP.LDAP") + "\");\n" + "    editconnection.ldapUserSearch.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.ldapGroupSearch.value != \"\" && editconnection.ldapGroupSearch.value.indexOf(\"{0}\") == -1) {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LDAP.GroupSearchMustIncludeSubstitution") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "LDAP.LDAP") + "\");\n" + "    editconnection.ldapGroupSearch.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.ldapServerPort.value != \"\" && !isInteger(editconnection.ldapServerPort.value)) {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LDAP.ServerPortMustBeAnInteger") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "LDAP.LDAP") + "\");\n" + "    editconnection.ldapServerPort.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.ldapServerName.value.indexOf(\"/\") != -1) {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LDAP.ServerNameCannotIncludeSlash") + "\");\n" + "    SelectTab(\"" + Messages.getBodyJavascriptString(locale, "LDAP.LDAP") + "\");\n" + "    editconnection.ldapServerName.focus();\n" + "    return false;\n" + "  }\n" + "  if (editconnection.ldapServerBase.value.indexOf(\"/\") != -1) {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LDAP.ServerBaseCannotIncludeSlash") + "\");\n" + "    editconnection.ldapServerBase.focus();\n" + "    return false;\n" + "  }\n" + "  return true;\n" + "}\n" + "function SpecOp(n, opValue, anchorvalue) {\n" + "  eval(\"editconnection.\"+n+\".value = \\\"\"+opValue+\"\\\"\");\n" + "  postFormSetAnchor(anchorvalue);\n" + "}\n" + "function SpecAddToken(anchorvalue) {\n" + "  if (editconnection.spectoken.value == \"\")\n" + "  {\n" + "    alert(\"" + Messages.getBodyJavascriptString(locale, "LDAP.TypeInToken") + "\");\n" + "    editconnection.spectoken.focus();\n" + "    return;\n" + "  }\n" + "  SpecOp(\"accessop\",\"Add\",anchorvalue);\n" + "}\n" + "//-->\n" + "</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String fServerName = this.getParam(parameters, "ldapServerName", "");
        String fServerPort = this.getParam(parameters, "ldapServerPort", "389");
        String fServerBase = this.getParam(parameters, "ldapServerBase", "");
        String fUserBase = this.getParam(parameters, "ldapUserBase", "ou=People");
        String fUserSearch = this.getParam(parameters, "ldapUserSearch", "(&(objectClass=inetOrgPerson)(uid={0}))");
        String fUserNameAttr = this.getParam(parameters, "ldapUserNameAttr", "uid");
        boolean fAddUserRecord = "1".equals(this.getParam(parameters, "ldapAddUserRecord", ""));
        String fGroupBase = this.getParam(parameters, "ldapGroupBase", "ou=Groups");
        String fGroupSearch = this.getParam(parameters, "ldapGroupSearch", "(&(objectClass=groupOfNames)(member={0}))");
        String fGroupNameAttr = this.getParam(parameters, "ldapGroupNameAttr", "cn");
        boolean fGroupMemberDN = "1".equals(this.getParam(parameters, "ldapGroupMemberDn", ""));
        String fBindUser = this.getParam(parameters, "ldapBindUser", "");
        String fBindPass = "";
        try {
            fBindPass = ManifoldCF.deobfuscate((String)this.getParam(parameters, "ldapBindPass", ""));
        }
        catch (ManifoldCFException ex) {
            // empty catch block
        }
        fBindPass = out.mapPasswordToKey(fBindPass);
        if (tabName.equals(Messages.getString(locale, "LDAP.LDAP"))) {
            out.print("<table class=\"displaytable\">\n <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n <tr>\n  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.LDAPServerNameColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"text\" size=\"32\" name=\"ldapServerName\" value=\"" + Encoder.attributeEscape((String)fServerName) + "\"/></td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.LDAPServerPortColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"text\" size=\"5\" name=\"ldapServerPort\" value=\"" + Encoder.attributeEscape((String)fServerPort) + "\"/></td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.LDAPServerBaseColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"text\" size=\"64\" name=\"ldapServerBase\" value=\"" + Encoder.attributeEscape((String)fServerBase) + "\"/></td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.LDAPBindUserColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"text\" size=\"64\" name=\"ldapBindUser\" value=\"" + Encoder.attributeEscape((String)fBindUser) + "\"/></td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.LDAPBindPasswordColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"password\" size=\"64\" name=\"ldapBindPass\" value=\"" + Encoder.attributeEscape((String)fBindPass) + "\"/></td>\n" + " </tr>\n" + " <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.UserSearchBaseColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"text\" size=\"64\" name=\"ldapUserBase\" value=\"" + Encoder.attributeEscape((String)fUserBase) + "\"/></td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.UserSearchFilterColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"text\" size=\"64\" name=\"ldapUserSearch\" value=\"" + Encoder.attributeEscape((String)fUserSearch) + "\"/></td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.AddUserAuthColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"checkbox\" value=\"1\" name=\"ldapAddUserRecord\" " + (fAddUserRecord ? "checked=\"true\"" : "") + "/></td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.UserNameAttrColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"text\" size=\"64\" name=\"ldapUserNameAttr\" value=\"" + Encoder.attributeEscape((String)fUserNameAttr) + "\"/></td>\n" + " </tr>\n" + " <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.GroupSearchBaseColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"text\" size=\"64\" name=\"ldapGroupBase\" value=\"" + Encoder.attributeEscape((String)fGroupBase) + "\"/></td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.GroupSearchFilterColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"text\" size=\"64\" name=\"ldapGroupSearch\" value=\"" + Encoder.attributeEscape((String)fGroupSearch) + "\"/></td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.GroupNameAttributeColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"text\" size=\"64\" name=\"ldapGroupNameAttr\" value=\"" + Encoder.attributeEscape((String)fGroupNameAttr) + "\"/></td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.GroupMemberDnColon") + "</nobr></td>\n" + "  <td class=\"value\"><input type=\"checkbox\" value=\"1\" name=\"ldapGroupMemberDn\" " + (fGroupMemberDN ? "checked=\"true\"" : "") + "/></td>\n" + " </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"ldapServerName\" value=\"" + Encoder.attributeEscape((String)fServerName) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"ldapServerPort\" value=\"" + Encoder.attributeEscape((String)fServerPort) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"ldapServerBase\" value=\"" + Encoder.attributeEscape((String)fServerBase) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"ldapBindUser\" value=\"" + Encoder.attributeEscape((String)fBindUser) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"ldapBindPass\" value=\"" + Encoder.attributeEscape((String)fBindPass) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"ldapUserBase\" value=\"" + Encoder.attributeEscape((String)fUserBase) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"ldapUserSearch\" value=\"" + Encoder.attributeEscape((String)fUserSearch) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"ldapGroupBase\" value=\"" + Encoder.attributeEscape((String)fGroupBase) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"ldapGroupSearch\" value=\"" + Encoder.attributeEscape((String)fGroupSearch) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"ldapGroupNameAttr\" value=\"" + Encoder.attributeEscape((String)fGroupNameAttr) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"ldapUserNameAttr\" value=\"" + Encoder.attributeEscape((String)fUserNameAttr) + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"ldapAddUserRecord\" value=\"" + (fAddUserRecord ? "1" : "0") + "\"/>\n");
            out.print("<input type=\"hidden\" name=\"ldapGroupMemberDn\" value=\"" + (fGroupMemberDN ? "1" : "0") + "\"/>\n");
        }
        if (tabName.equals(Messages.getString(locale, "LDAP.ForcedTokens"))) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr><td class=\"value\" colspan=\"2\">" + Messages.getBodyString(locale, "LDAP.ForcedTokensDisclaimer") + "</td></tr>\n" + "  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            out.print("  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n");
            int i = 0;
            int k = 0;
            while (i < parameters.getChildCount()) {
                ConfigNode sn;
                if (!(sn = parameters.getChild(i++)).getType().equals("access")) continue;
                String accessDescription = "_" + Integer.toString(k);
                String accessOpName = "accessop" + accessDescription;
                String token = sn.getAttributeValue("token");
                out.print("  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"" + accessOpName + "\" value=\"\"/>\n" + "      <input type=\"hidden\" name=\"" + "spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n" + "      <a name=\"" + "token_" + Integer.toString(k) + "\">\n" + "        <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "LDAP.Delete") + "\" onClick='Javascript:SpecOp(\"" + accessOpName + "\",\"Delete\",\"token_" + Integer.toString(k) + "\")' alt=\"" + Messages.getAttributeString(locale, "LDAP.DeleteToken") + Integer.toString(k) + "\"/>\n" + "      </a>&nbsp;\n" + "    </td>\n" + "    <td class=\"value\">\n" + "      " + Encoder.bodyEscape((String)token) + "\n" + "    </td>\n" + "  </tr>\n");
                ++k;
            }
            if (k == 0) {
                out.print("  <tr>\n    <td class=\"message\" colspan=\"2\">" + Messages.getBodyString(locale, "LDAP.NoTokensPresent") + "</td>\n" + "  </tr>\n");
            }
            out.print("  <tr><td class=\"lightseparator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\">\n      <input type=\"hidden\" name=\"tokencount\" value=\"" + Integer.toString(k) + "\"/>\n" + "      <input type=\"hidden\" name=\"accessop\" value=\"\"/>\n" + "      <a name=\"" + "token_" + Integer.toString(k) + "\">\n" + "        <input type=\"button\" value=\"" + Messages.getAttributeString(locale, "LDAP.Add") + "\" onClick='Javascript:SpecAddToken(\"token_" + Integer.toString(k + 1) + "\")' alt=\"" + Messages.getAttributeString(locale, "LDAP.AddToken") + "\"/>\n" + "      </a>&nbsp;\n" + "    </td>\n" + "    <td class=\"value\">\n" + "      <input type=\"text\" size=\"30\" name=\"spectoken\" value=\"\"/>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            int i = 0;
            int k = 0;
            while (i < parameters.getChildCount()) {
                ConfigNode sn;
                if (!(sn = parameters.getChild(i++)).getType().equals("access")) continue;
                String accessDescription = "_" + Integer.toString(k);
                String token = "" + sn.getAttributeValue("token");
                out.print("<input type=\"hidden\" name=\"spectoken" + accessDescription + "\" value=\"" + Encoder.attributeEscape((String)token) + "\"/>\n");
                ++k;
            }
            out.print("<input type=\"hidden\" name=\"tokencount\" value=\"" + Integer.toString(k) + "\"/>\n");
        }
    }

    private String getParam(ConfigParams parameters, String name, String def) {
        return parameters.getParameter(name) != null ? parameters.getParameter(name) : def;
    }

    private String getViewParam(ConfigParams parameters, String name) {
        return parameters.getParameter(name) != null ? parameters.getParameter(name) : "";
    }

    private boolean copyParam(IPostParameters variableContext, ConfigParams parameters, String name) {
        String val = variableContext.getParameter(name);
        if (val == null) {
            return false;
        }
        parameters.setParameter(name, val);
        return true;
    }

    private boolean copyParam(IPostParameters variableContext, ConfigParams parameters, String name, String def) {
        String val = variableContext.getParameter(name);
        if (val == null) {
            val = def;
        }
        parameters.setParameter(name, val);
        return true;
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String xc;
        this.copyParam(variableContext, parameters, "ldapServerName");
        this.copyParam(variableContext, parameters, "ldapServerPort");
        this.copyParam(variableContext, parameters, "ldapServerBase");
        this.copyParam(variableContext, parameters, "ldapUserBase");
        this.copyParam(variableContext, parameters, "ldapUserSearch");
        this.copyParam(variableContext, parameters, "ldapUserNameAttr");
        this.copyParam(variableContext, parameters, "ldapGroupBase");
        this.copyParam(variableContext, parameters, "ldapGroupSearch");
        this.copyParam(variableContext, parameters, "ldapGroupNameAttr");
        this.copyParam(variableContext, parameters, "ldapGroupMemberDn", "0");
        this.copyParam(variableContext, parameters, "ldapAddUserRecord", "0");
        this.copyParam(variableContext, parameters, "ldapBindUser");
        String bindPass = variableContext.getParameter("ldapBindPass");
        if (bindPass != null) {
            parameters.setObfuscatedParameter("ldapBindPass", variableContext.mapKeyToPassword(bindPass));
        }
        if ((xc = variableContext.getParameter("tokencount")) != null) {
            int i = 0;
            while (i < parameters.getChildCount()) {
                ConfigNode sn = parameters.getChild(i);
                if (sn.getType().equals("access")) {
                    parameters.removeChild(i);
                    continue;
                }
                ++i;
            }
            int accessCount = Integer.parseInt(xc);
            i = 0;
            while (i < accessCount) {
                String accessDescription = "_" + Integer.toString(i);
                String accessOpName = "accessop" + accessDescription;
                xc = variableContext.getParameter(accessOpName);
                if (xc != null && xc.equals("Delete")) {
                    ++i;
                    continue;
                }
                String accessSpec = variableContext.getParameter("spectoken" + accessDescription);
                ConfigNode node = new ConfigNode("access");
                node.setAttribute("token", accessSpec);
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node);
                ++i;
            }
            String op = variableContext.getParameter("accessop");
            if (op != null && op.equals("Add")) {
                String accessspec = variableContext.getParameter("spectoken");
                ConfigNode node = new ConfigNode("access");
                node.setAttribute("token", accessspec);
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        String f_serverName = this.getViewParam(parameters, "ldapServerName");
        String f_serverPort = this.getViewParam(parameters, "ldapServerPort");
        String f_serverBase = this.getViewParam(parameters, "ldapServerBase");
        String f_bindUser = this.getViewParam(parameters, "ldapBindUser");
        String f_userBase = this.getViewParam(parameters, "ldapUserBase");
        String f_userSearch = this.getViewParam(parameters, "ldapUserSearch");
        String f_groupBase = this.getViewParam(parameters, "ldapGroupBase");
        String f_groupSearch = this.getViewParam(parameters, "ldapGroupSearch");
        String f_groupNameAttr = this.getViewParam(parameters, "ldapGroupNameAttr");
        String f_userNameAttr = this.getViewParam(parameters, "ldapUserNameAttr");
        boolean f_groupMemberDN = "1".equals(this.getViewParam(parameters, "ldapGroupMemberDn"));
        boolean f_addUserRecord = "1".equals(this.getViewParam(parameters, "ldapAddUserRecord"));
        out.print("<table class=\"displaytable\">\n <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n <tr>\n  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.LDAPServerNameColon") + "</nobr></td>\n" + "  <td class=\"value\">" + Encoder.bodyEscape((String)f_serverName) + "</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.LDAPServerPortColon") + "</nobr></td>\n" + "  <td class=\"value\">" + Encoder.bodyEscape((String)f_serverPort) + "</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.LDAPServerBaseColon") + "</nobr></td>\n" + "  <td class=\"value\">" + Encoder.bodyEscape((String)f_serverBase) + "</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.LDAPBindUserColon") + "</nobr></td>\n" + "  <td class=\"value\">" + Encoder.bodyEscape((String)f_bindUser) + "</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.LDAPBindPasswordColon") + "</nobr></td>\n" + "  <td class=\"value\">*******</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.UserSearchBaseColon") + "</nobr></td>\n" + "  <td class=\"value\">" + Encoder.bodyEscape((String)f_userBase) + "</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.UserSearchFilterColon") + "</nobr></td>\n" + "  <td class=\"value\">" + Encoder.bodyEscape((String)f_userSearch) + "</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.AddUserAuthColon") + "</nobr></td>\n" + "  <td class=\"value\">" + (f_addUserRecord ? "Y" : "N") + "</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.UserNameAttrColon") + "</nobr></td>\n" + "  <td class=\"value\">" + Encoder.bodyEscape((String)f_userNameAttr) + "</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.GroupSearchBaseColon") + "</nobr></td>\n" + "  <td class=\"value\">" + Encoder.bodyEscape((String)f_groupBase) + "</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.GroupSearchFilterColon") + "</nobr></td>\n" + "  <td class=\"value\">" + Encoder.bodyEscape((String)f_groupSearch) + "</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.GroupNameAttributeColon") + "</nobr></td>\n" + "  <td class=\"value\">" + Encoder.bodyEscape((String)f_groupNameAttr) + "</td>\n" + " </tr>\n" + " <tr>\n" + "  <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.GroupMemberDnColon") + "</nobr></td>\n" + "  <td class=\"value\">" + (f_groupMemberDN ? "Y" : "N") + "</td>\n" + " </tr>\n");
        out.print("  <tr><td class=\"separator\" colspan=\"4\"><hr/></td></tr>\n");
        boolean seenAny = false;
        int i = 0;
        while (i < parameters.getChildCount()) {
            ConfigNode sn;
            if (!(sn = parameters.getChild(i++)).getType().equals("access")) continue;
            if (!seenAny) {
                out.print("  <tr>\n    <td class=\"description\"><nobr>" + Messages.getBodyString(locale, "LDAP.ForcedTokensColon") + "</nobr></td>\n" + "    <td class=\"value\">\n");
                seenAny = true;
            }
            String token = sn.getAttributeValue("token");
            out.print(Encoder.bodyEscape((String)token) + "<br/>\n");
        }
        if (seenAny) {
            out.print("    </td>\n  </tr>\n");
        } else {
            out.print("  <tr><td class=\"message\" colspan=\"4\"><nobr>" + Messages.getBodyString(locale, "LDAP.NoTokensSpecified") + "</nobr></td></tr>\n");
        }
        out.print("</table>\n");
    }

    protected SearchResult getUserEntry(LdapContext ctx, String userName) throws ManifoldCFException {
        String searchFilter = this.userSearch.replaceAll("\\{0\\}", LDAPAuthority.escapeDN(userName.split("@")[0]));
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(2);
        try {
            NamingEnumeration<SearchResult> answer = ctx.search(this.userBase, searchFilter, searchCtls);
            if (answer.hasMoreElements()) {
                return answer.next();
            }
            return null;
        }
        catch (Exception e) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    protected static String ldapEscape(String input) {
        int oldIndex;
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (true) {
            if ((index = input.indexOf(",", oldIndex = ++index)) == -1) break;
            sb.append(input.substring(oldIndex, index)).append("\\,");
        }
        sb.append(input.substring(oldIndex));
        return sb.toString();
    }

    public static String escapeDN(String name) {
        StringBuilder sb = new StringBuilder();
        if (name.length() > 0 && (name.charAt(0) == ' ' || name.charAt(0) == '#')) {
            sb.append('\\');
        }
        block9: for (int i = 0; i < name.length(); ++i) {
            char curChar = name.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case ',': {
                    sb.append("\\,");
                    continue block9;
                }
                case '+': {
                    sb.append("\\+");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '<': {
                    sb.append("\\<");
                    continue block9;
                }
                case '>': {
                    sb.append("\\>");
                    continue block9;
                }
                case ';': {
                    sb.append("\\;");
                    continue block9;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        if (name.length() > 1 && name.charAt(name.length() - 1) == ' ') {
            sb.insert(sb.length() - 1, '\\');
        }
        return sb.toString();
    }

    public static String escapeLDAPSearchFilter(String filter) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < filter.length(); ++i) {
            char curChar = filter.charAt(i);
            switch (curChar) {
                case '\\': {
                    sb.append("\\5c");
                    continue block7;
                }
                case '*': {
                    sb.append("\\2a");
                    continue block7;
                }
                case '(': {
                    sb.append("\\28");
                    continue block7;
                }
                case ')': {
                    sb.append("\\29");
                    continue block7;
                }
                case '\u0000': {
                    sb.append("\\00");
                    continue block7;
                }
                default: {
                    sb.append(curChar);
                }
            }
        }
        return sb.toString();
    }

    protected class LdapAuthorizationResponseDescription
    extends BaseDescription {
        protected String userName;
        protected String connectionString;
        protected String userSearch;
        protected String groupSearch;
        protected long responseLifetime;
        protected long expirationTime;

        public LdapAuthorizationResponseDescription(String userName, String connectionString, String userSearch, String groupSearch, long responseLifetime, int LRUsize) {
            super("LDAPAuthority", LRUsize);
            this.expirationTime = -1L;
            this.userName = userName;
            this.connectionString = connectionString;
            this.userSearch = userSearch;
            this.groupSearch = groupSearch;
            this.responseLifetime = responseLifetime;
        }

        public StringSet getObjectKeys() {
            return emptyStringSet;
        }

        public String getCriticalSectionName() {
            StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getName());
            sb.append("-").append(this.userName).append("-").append(this.connectionString);
            return sb.toString();
        }

        public long getObjectExpirationTime(long currentTime) {
            if (this.expirationTime == -1L) {
                this.expirationTime = currentTime + this.responseLifetime;
            }
            return this.expirationTime;
        }

        public int hashCode() {
            return this.userName.hashCode() + this.connectionString.hashCode() + this.userSearch.hashCode() + this.groupSearch.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof LdapAuthorizationResponseDescription)) {
                return false;
            }
            LdapAuthorizationResponseDescription ard = (LdapAuthorizationResponseDescription)((Object)o);
            if (!ard.userName.equals(this.userName)) {
                return false;
            }
            if (!ard.connectionString.equals(this.connectionString)) {
                return false;
            }
            if (!ard.userSearch.equals(this.userSearch)) {
                return false;
            }
            return ard.groupSearch.equals(this.groupSearch);
        }
    }
}

