/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDiskData;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.PersistentStoreCollection;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.persist.TextCache;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowStoreAVLDiskData
extends RowStoreAVL {
    DataFileCache cache;
    RowOutputInterface rowOut;

    public RowStoreAVLDiskData(PersistentStoreCollection persistentStoreCollection, Table table) {
        this.database = table.database;
        this.manager = persistentStoreCollection;
        this.table = table;
        this.indexList = table.getIndexList();
        this.accessorList = new CachedObject[this.indexList.length];
        persistentStoreCollection.setStore(table, this);
    }

    @Override
    public CachedObject get(long l, boolean bl) {
        CachedObject cachedObject = this.cache.get(l, (PersistentStore)this, bl);
        return cachedObject;
    }

    @Override
    public CachedObject get(CachedObject cachedObject, boolean bl) {
        cachedObject = this.cache.get(cachedObject, (PersistentStore)this, bl);
        return cachedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Session session, CachedObject cachedObject, boolean bl) {
        this.cache.writeLock.lock();
        try {
            int n = cachedObject.getRealSize(this.cache.rowOut);
            cachedObject.setStorageSize(n);
            long l = this.tableSpace.getFilePosition(n, false);
            cachedObject.setPos(l);
            if (bl) {
                RowAction.addInsertAction(session, this.table, (Row)cachedObject);
            }
            this.cache.add(cachedObject);
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    @Override
    public CachedObject get(RowInputInterface rowInputInterface) {
        try {
            RowAVLDiskData rowAVLDiskData = new RowAVLDiskData((PersistentStore)this, this.table, rowInputInterface);
            rowAVLDiskData.setPos(rowInputInterface.getPos());
            rowAVLDiskData.setStorageSize(rowInputInterface.getSize());
            rowAVLDiskData.setChanged(false);
            ((TextCache)this.cache).addInit(rowAVLDiskData);
            return rowAVLDiskData;
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
    }

    @Override
    public CachedObject get(CachedObject cachedObject, RowInputInterface rowInputInterface) {
        try {
            ((RowAVLDiskData)cachedObject).getRowData(this.table, rowInputInterface);
            return cachedObject;
        }
        catch (IOException iOException) {
            throw Error.error(484, iOException);
        }
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean bl) {
        RowAVLDiskData rowAVLDiskData = new RowAVLDiskData((PersistentStore)this, this.table, (Object[])object);
        this.add(session, rowAVLDiskData, bl);
        return rowAVLDiskData;
    }

    @Override
    public void indexRow(Session session, Row row) {
        super.indexRow(session, row);
    }

    @Override
    public boolean isMemory() {
        return false;
    }

    @Override
    public int getAccessCount() {
        return this.cache.getAccessCount();
    }

    @Override
    public void set(CachedObject cachedObject) {
    }

    @Override
    public CachedObject get(long l) {
        CachedObject cachedObject = this.cache.get(l, (PersistentStore)this, false);
        return cachedObject;
    }

    @Override
    public void removeAll() {
        this.destroy();
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public void remove(CachedObject cachedObject) {
        this.cache.remove(cachedObject);
    }

    @Override
    public CachedObject getAccessor(Index index) {
        int n = index.getPosition();
        if (n >= this.accessorList.length) {
            throw Error.runtimeError(201, "RowStoreAVL");
        }
        return this.accessorList[n];
    }

    @Override
    public void commitPersistence(CachedObject cachedObject) {
        try {
            this.cache.saveRow(cachedObject);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    @Override
    public void commitRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                this.cache.removePersistence(row);
                break;
            }
            case 1: {
                this.commitPersistence(row);
                break;
            }
            case 4: {
                if (n2 == 0) {
                    this.remove(row);
                    break;
                }
                this.delete(session, row);
                this.remove(row);
                break;
            }
            case 3: {
                if (n2 == 0) break;
                this.delete(session, row);
                this.remove(row);
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int n, int n2) {
        switch (n) {
            case 2: {
                if (n2 != 0) break;
                ((RowAVL)row).setNewNodes(this);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                if (n2 != 0) break;
                this.delete(session, row);
                this.remove(row);
                break;
            }
            case 4: {
                if (n2 == 0) {
                    this.remove(row);
                    break;
                }
                this.delete(session, row);
                this.remove(row);
            }
        }
    }

    @Override
    public DataFileCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(DataFileCache dataFileCache) {
        this.cache = dataFileCache;
        this.tableSpace = dataFileCache.spaceManager.getTableSpace(7);
    }

    @Override
    public void release() {
        this.destroy();
        this.table.database.logger.closeTextCache((Table)this.table);
        this.cache = null;
        ArrayUtil.fillArray(this.accessorList, null);
    }
}

