/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.normalizer;

import java.util.regex.Pattern;
import opennlp.tools.util.normalizer.CharSequenceNormalizer;

public class ShrinkCharSequenceNormalizer
implements CharSequenceNormalizer {
    private static final long serialVersionUID = -4511969661556543048L;
    private static final Pattern REPEATED_CHAR_REGEX = Pattern.compile("(.)\\1{2,}", 2);
    private static final Pattern SPACE_REGEX = Pattern.compile("\\s{2,}", 2);
    private static final ShrinkCharSequenceNormalizer INSTANCE = new ShrinkCharSequenceNormalizer();

    public static ShrinkCharSequenceNormalizer getInstance() {
        return INSTANCE;
    }

    @Override
    public CharSequence normalize(CharSequence text) {
        text = SPACE_REGEX.matcher(text).replaceAll(" ");
        return REPEATED_CHAR_REGEX.matcher(text).replaceAll("$1$1").trim();
    }
}

