/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

export default {
    message: {
        common: {
            lang: '简体中文',
            statisticsTime: 'Time Range',
            fullScreen: 'FullScreen',
            log: 'Log',
            diagnosis: 'Intelligent Diagnosis',
            watermaskText:
                'Generated by DataWorkShop. For internal references only',
            filter: 'Filter',
            saveToWidget: 'Save widget to solution',
            script: 'Script',
            refresh: 'Refresh',
            download: 'Download',
            submit: 'Submit',
            saveSuccess: 'Successfully saved',
            detail: 'Details',
            FAQ: 'FAQ',
            clearCache: 'Clear Cache',
            logOut: 'Log out',
            action: 'Action',
            path: 'Please choose the path',
            resultList: 'Resultset',
            process: 'Execution Time:',
            ok: 'OK',
            add: 'Add',
            cancel: 'Cancel',
            delete: 'Delete',
            failedNotice: 'Invalid items found, please check and then retry!',
            logoName: 'Linkis',
            home: 'Home',
            management: 'Console',
            feedback: 'Feedback',
            bbs: 'BBS',
            exceptionTips:
                'Background interface exception, please contact development processing!',
            separator: {
                comma: 'Comma',
                tab: 'Tab',
                semicolon: 'Semicolon',
                space: 'Space',
                vertical: 'Vertical bar',
            },
            tabs: {
                progress: 'Progress',
                result: 'Execution Result',
                log: 'Execution Log',
                history: 'History',
                diagnosis: 'Intelligent Diagnosis',
            },
            notice: {
                unsave: {
                    title: 'Notice',
                    desc: 'Your temporary script has been updated, please mind to save!',
                },
                sendStart: {
                    title: 'Execution Notice',
                    render: 'Start to execute the script',
                },
                querySuccess: {
                    title: 'Execution Result Notice',
                    render: 'Successfully executed script, time elapsed:',
                },
                notice: {
                    title: 'Execution Result Notice',
                },
                kill: {
                    title: 'Execution Notice',
                    desc: 'Stopped executing this script',
                },
            },
            steps: {
                title: 'Job Status',
                stepsInfo: {
                    Submitted: 'Submitted',
                    Inited: 'waiting',
                    Scheduled: 'Applying Resources',
                    Running: 'Running',
                    Succeed: 'Succeeded',
                    ResultLoading: 'Loading Result',
                    Completed: 'Completed',
                    Failed: 'Failed',
                    Cancelled: 'Canceled',
                    FailedToGetResult: 'Failed to request result set',
                    FailedToGetResultPath: 'Failed to request result set path',
                    FailedToGetResultList: 'Failed to request result set list',
                    FailedToGetResultFirst:
                        'Failed to request the first result set',
                    WaitForRetry: 'Waiting for retry',
                    FailedToApply: 'Failed to apply resources',
                    FailedToExecute: 'Execution Failed',
                    notResult: 'No Result Set Generated',
                },
                hoverList: {
                    first: '1.Successfully requested result set path...',
                    second: '2.Successfully requested result set list...',
                },
            },
            resultsExport: {
                header: 'Export Result Set',
                formItems: {
                    name: {
                        label: 'Name',
                        placeholder: 'Please enter the name exported as……',
                        title: 'The suffix to export as can be configured in Control Panel-Settings-Application Level-PipeLine!',
                    },
                    path: {
                        label: 'Storage Path',
                        title: 'Export Result Set',
                        isSheet:
                            'Whether to import multiple results Group into different sheets of export!',
                    },
                },
                rules: {
                    name: {
                        required: 'Please enter the name',
                        lengthLimit: 'Length between 1 to 200 characters',
                        letterTypeLimit:
                            'Only Chinese characters, alphanumeric characters and underscore are allowed',
                    },
                    path: {
                        required: 'Please choose the path to export!',
                    },
                },
            },
            progress: {
                title: 'Execution Progress',
                watingList: '{num} jobs wating in front',
                columns: {
                    id: {
                        title: 'Name',
                    },
                    progress: {
                        title: 'Progress Bar',
                    },
                    taskNum: {
                        title: 'Number of Tasks',
                        status: {
                            running: 'Running',
                            success: 'Succeeded',
                            fail: 'Failed',
                            totalTasks: 'Total Number of Tasks',
                        },
                    },
                },
            },
            execute: {
                waitingQueue: '{num} jobs wating in front',
                error: {
                    getResultList:
                        'Failed to request result set, please contact the admin!',
                    queryTimeout: 'Query timeout, please execute again!',
                    noResultList: 'No result set generated by this script!',
                    errorLog:
                        'Failed to request result set, please contact the admin!',
                    failed: 'Failed to execute, please check logs for the reason, or feedback the key information in your execution history to admin!',
                    canceled: 'Execution already canceled!',
                    executeTimeout:
                        'Execution timeout, please check logs for the reason, or feedback the key information in your execution history to admin!',
                },
                success: {
                    getResultList: ' Successfully requested result set!',
                    stateEnd:
                        'Successfully executed task, requesting result set in progress!',
                },
            },
            functionView: {
                formItems: {
                    name: 'Funtion Name',
                    createUser: 'Creator/Department',
                    updateTime: 'Updated at',
                    useFormat: 'Using Format',
                    description: 'Funtion Description',
                },
            },
            navBar: {
                addTitle: 'New Directory',
                dataStudio: {
                    outTable: 'Export Table',
                    importHive: 'Import to Hive',
                    addTitle: 'New directory',
                    searchPlaceholder:
                        'Please enter file or directory name to search',
                },
                workSpace: {
                    searchPlaceholder:
                        'Please enter file or directory name to search',
                },
                database: {
                    searchPlaceholder:
                        'Please enter database or table name to search',
                },
                fnSideBar: {
                    searchPlaceholder:
                        'Please enter directory or function name to search',
                },
                hdfs: {
                    searchPlaceholder:
                        'Please enter directory or function name to search',
                },
            },
            monacoMenu: {
                YXJB: 'Run Script',
                GSH: 'Format',
                CZ: 'Search',
                TH: 'Replace',
                HZS: 'Line Comment',
                ZT: 'Paste',
                HBQWJCFZWB:
                    'Sorry, no copied text detected by IDE, if you performed the copy operation outside IDE, please use ctrl+v to paste!',
                TDZDH: 'Jump to Line',
                GBYFJC: 'Close Syntax Check',
                DKYFJC: 'Open Syntax Check',
                GYFSYGWYF:
                    'This is highly dangerous syntax, please be cautious!',
            },
            resourceSimple: {
                YS: 'Scriptis',
                FL: 'Category',
                ZH: 'Visualis',
                FLOW1: 'Flowexecution',
                FLOW2: 'Scheduler',
                ZWSJ: 'No data yet',
                KX: 'Idle',
                FM: 'Busy',
                QD: 'Starting',
                LX: 'By Category',
                AZT: 'By Status',
                DDJK: 'Waiting for API response!',
                QDYQWFJS: 'Cannot shut down an engine with starting status!',
                WXZYQ: 'No engine selected!',
                RWGLQ: 'Task Management',
                YQGLQ: 'Engine Management',
                DLGLQ: 'Queue Management',
                QX: 'Select All',
                QXQX: 'Deselect All',
                SX: 'Refresh',
                JSRW: 'Cancel Task',
                JSYQ: 'Shut Down Engine',
                PDZ: 'Queueing',
                ZYSQ: 'Applying Resources',
                YX: 'Running',
                YQ: 'Engine',
                RW: 'Task',
                WZJBMC: 'Unknown Script Name',
                ZHJB: 'Visualis Script',
                GZLJB: 'Workflow Script',
                YQRW: 'Engine and Task',
                JSYQRW: 'Terminate Engine and Tasks',
                CKJBXX: 'View Script Information',
                FZJBXX: 'Copy Script Information',
                QXZYTJL: 'Please choose a record!',
                WHQD: 'The task is initializing. The end operation cannot be performed. Please wait until the task initialization is complete',
                WHQDENGINE:
                    'Failed to get engineInstance, please contact admin for investigation or waiting!',
                YXTS: 'Execution Hints',
                YJTZZXJB: 'Stopped Executing Script',
                JSYQHRWCG: 'Successfully Terminated Engine and Tasks',
                DKCG: 'Successfully Open',
                JBFZDZTRB:
                    'Copied script information to clipboard, please use ctrl+v to paste!',
                XZDL: 'Please choose a queue',
                ZYSYL: 'Resource Consumption Rate',
                H: 'Cores',
                NC: 'Memory',
                ZYSYPHB: 'Ranking of Resource Consumption',
                ZW: 'No data yet',
            },
            headerNavBar: {
                Workflow: 'Workflow Development',
                Exchangis: 'Data Exchange Component',
                Scriptis: 'Data Development Component',
                Qualitis: 'Data Governance Component',
                Visualis: 'Data Visualization Component',
                Schedulis: 'Workflow Schedule Component',
                LinkisConsole: 'Linkis Console',
            },
            userMenu: {
                title: 'Warning',
                content:
                    '<p>This operation will clear the local database cache, leading to loose your script logs, history and result set information, please confirm whether there are scripts unsaved!</p><p>Click OK button to continue?</p>',
                clearCacheSuccess: 'Successfully cleared local cache!',
                comingSoon: 'Planning in progress, please stay tuned!',
            },
            login: {
                loginTitle: 'Welcome to Linkis Console!',
                userName: 'Please enter your username',
                remember: 'Remember me',
                login: 'Login',
                passwordHint: 'Please enter your password',
                password: 'Please enter password！',
                loginSuccess: 'Log in successfully',
                haveLogin:
                    'You have already logged in, please do not login repeatedly',
                vaildFaild: 'Authentication failed!',
                toRegister: 'No account? Create one',
                selectProxyTip: 'No select proxy',
                logoutSuccess: 'Log out successfully'
            },
            dynamicForm: {
                rule: {
                    emptyKey: 'key is empty',
                    lengthLimit: 'Length exceeds 128 characters',
                    nameVaild:
                        'Starts with alphabetic characters; Space and Chinese characters are not allowed',
                    emptyValue: 'value is empty',
                },
                namePlaceholder: 'Please enter {title} name',
                placeholderInput: 'Please enter the value',
                someKey: 'Duplicated key found',
            },
            deleteDialog: {
                waring: 'Warning',
                action: 'Yes',
                isNext: 'Continue or not?',
                overThe: 'Stop this',
                engine: 'Engine',
                task: 'Task',
                engineAndTask: 'Engine and task',
            },
            tableRow: {
                detail: 'Details of the selected row',
                search: 'Search……',
                columnName: 'Column name',
                value: 'Value',
                dataType: 'Data type',
            },
            toolbar: {
                replace: 'Please choose the empty value to replace:',
                emptyString: 'Empty string',
                analysis: 'Visualization',
                window: 'Visualization window',
                export: 'Export',
                format: 'Please choose the download format:',
                exportFormat: 'Format：',
                coding: 'Please choose the encoding:',
                model: 'Please choose the model:',
                graphAnalysis: 'Graph Analysis',
                excelAnalysis: 'Excel Analysis',
                lineFilter: 'Line Filter',
                resultGroupLineFilter: 'Result Group Line Filter',
                resultGroup: 'Result Group',
                all: 'all',
                allDownLoad: 'All Result Sets',
                autoFormat: 'Auto Format',
                downloadMode: 'Download Mode :',
                deepAnalysis: 'Deep Analysis',
                success: {
                    download:
                        'Successfully downloaded, please check from the local download directory!',
                },
                rowToColumn: 'Switch row to column',
                rowToColumnTitle: 'View current row details',
                selectSeparator: 'Please select a custom separator：',
            },
            time: {
                SEC: ' SEC',
                MIN: 'MIN',
                HOUR: 'HOUR',
                DAY: 'DAY',
                WEEK: 'WEEK',
                MONTH: 'MONTH',
                YEAR: 'YEAR',
                Mon: 'Mon',
                Tue: 'Tue',
                Wed: 'Wed',
                Thu: 'Thu',
                Fri: 'Fri',
                Sat: 'Sat',
                Sun: 'Sun',
                second: 'Second',
                minute: 'Minute',
                hour: 'Hour',
                day: 'Day',
            },
            warning: {
                api: 'Requesting API, please hold on!',
                data: 'Requesting data, please hold on!',
                waiting: 'Please wait for API response!',
                biLoading: 'Connecting with Visualis, please hold on!',
                comingSoon: 'New version is being integrated, so stay tuned !',
                GJZ: 'Open source co-construction is in progress, so stay tuned!',
            },
        },
        linkis: {
            id: 'id',
            sourceInfo: 'Source Info',
            refresh: 'Refresh',
            engineConfig: 'Engines',
            engineNumber: 'Engine Number',
            globalConfigs: 'Global Configs',
            applicationDesc: 'Desc',
            applicationName: 'Name',
            addApplicationAndEngine: 'Add application and engine',
            editApplicationAndEngine: 'Edit application and engine',
            failedToAddCreator: 'Failed to add creator',
            successfullyAddCreator: 'Successfully add creator',
            nonRepetitiveEngines: 'Do not add repetitive engines',
            failedToGetCategoryId: 'Failed to get categoryId',
            successfullyAddEngine: 'Engine add successfully',
            failedToAddEngine: 'Engine add failed',
            failedToUpdateCreator: 'Failed to update creator',
            successfullyUpdateCreator: 'Successfully update creator',
            failedToUpdateEngine: 'Engine update failed',
            successfullyUpdateEngine: 'engine update successfully',
            confirmToDeleteCreator: 'Are you sure to delete this creator?',
            confirmToModifyCreator: 'Are you sure to perform this operation?',
            applicationAndEngine: 'Manage',
            globalTaskQuery: 'Global Task Query',
            batchStop: 'Batch Stop',
            confirmToStop: 'Confirm To Stop',
            noDescription: 'No description',
            placeholderZip:
                'Please enter the workspace Python package path (only zip is supported)!',
            emptyString: 'Empty String',
            description: 'Description',
            name: 'Name',
            order: 'Order',
            addParameterConfig: 'Add Parameter Configuration',
            addEngineType: 'Add Engine Type',
            editDescriptionEngineConfig: 'Edit Description Engine Config',
            addAppType: 'Add Application Type',
            editContents: 'Add Contents',
            ConfirmEdit: 'Done',
            serviceRegistryCenter: 'Service Registry Center',
            addTags: 'Add Tags',
            labelEmptyError: 'Label cannot be empty',
            labelNoSpecialSymbol: 'Spance and Chinese characters are not allowed',
            labelLengthLimit: 'Label length should not exceed 16',
            unfold: 'Unfold',
            fold: 'Fold',
            jumpPage: 'Please check in the jump page...',
            initiator: 'Created From',
            inputOwnerHint: 'Please input owner',
            find: 'Find',
            errorCode: 'Error Code',
            errorDescription: 'Error Description',
            notLog: 'Log not obtained!',
            editedSuccess: 'Edited success!',
            stopEngineTip: 'Are you sure you want to stop the current engine?',
            addVariable: 'Add Variable',
            defaultValue: 'Default',
            noDefaultValue: 'No default value',
            stop: 'Stop',
            tip: 'Tip',
            serverTip: 'No Results（resultLocation:null）',
            log: 'Task Log',
            detail: 'Task Detail',
            result: 'Task Result',
            startUp: 'Start-up',
            tagEdit: 'Edit',
            tipForKill:
                'The unlock engines of ECM [{instance}}] will be killed',
            killAll: 'Kill Unlock Engine',
            allEngine: 'Include Multiple User Engine?',
            killFinishedInfo:
                'Expected to stop {killEngineNum} engines, will release ECM {cores}cores,{memory}G resources',
            yes: 'Yes',
            no: 'No',
            noDataTextBeforeSearch: 'Please input the execution code for query',
            noDataTextAfterSearch: 'No data yet',
            rename: 'Rename',
            instanceNum: 'Instance Number',
            keyTip: 'The key cannot be empty',
            instanceName: 'Instance Name',
            resources: 'Resources',
            reset: 'Reset',
            clearSearch: 'Clear',
            showOperations: 'Show Operations',
            hide: 'Hide',
            resetAll: 'Reset All',
            remove: 'Remove',
            submit: 'Submit',
            search: 'Search',
            save: 'Save',
            edit: 'Edit',
            cancel: 'Cancel',
            create: 'Create',
            noDataText: 'No data yet',
            noLog: 'No log yet',
            jobId: 'JobID',
            userName: 'Username',
            password: 'Password',
            unselect: 'Please select tasks',
            noselection: 'Please select first',
            searchName: 'Please enter username to search',
            generalView: 'Switch to the Common View',
            manageView: 'Switch to the Admin View',
            back: 'Back',
            prev: 'Previous Step',
            complete: 'Complete',
            close: 'Close',
            udfName: 'UDF Name',
            udfType: 'UDF Type',
            nextPage: 'Next Page',
            previousPage: 'Previous Page',
            all: 'All',
            common: 'Common',
            tenant: 'Tenant',
            inputTenant: 'Please Input Tenant',
            globalSettings: 'GlobalSettings',
            downloadLogs: 'Download Logs',
            downloadLogsConfirm: 'Are you sure to download logs?',
            resultSet: {
                prefixText:
                    'Because your result set is large, for a better experience, ',
                linkText: 'View result set',
                largeResultTips:
                    'The front end displays only 5000 pieces of data',
            },
            needPre: 'Need to select category and input username before',
            warning: {
                api: 'Requesting API, please hold on!',
                data: 'Requesting data, please hold on!',
                waiting: 'Please wait for API response!',
                biLoading: 'Connecting with Visualis, please hold on!',
                comingSoon: 'New version is being integrated, so stay tuned !',
                GJZ: 'Open source co-construction is in progress, so stay tuned!',
            },
            resourceManagement: {
                resourceUsage: 'Resource usage',
                applicationList: 'Applications',
            },
            tableColumns: {
                instanceName: 'Instance Name',
                initiator: 'Initiator',
                engineInstance: 'Engine Instance',
                engineType: 'Engine Type',
                serveType: 'Serve Type',
                appType: 'App Type',
                taskID: 'JobID',
                fileName: 'Source',
                executionCode: 'Execution Code',
                status: 'Status',
                label: 'Label',
                editLabel: 'Edit Label',
                engineVersion: 'Engine Version',
                engineVersionCannotBeNull: 'Engine Version Cannot Be Null',
                addApplicationRules:
                    'Application Name Cannot Have Special Symbols And Spaces',
                lockedResource: 'Locked Resources',
                usedResources: 'Used Resources',
                maximumAvailableResources: 'Maximum Available Resources',
                minimumAvailableResources: 'Minimum Available Resources',
                startTime: 'Start Time',
                costTime: 'Time Elapsed',
                executeApplicationName: 'Execution Engine',
                requestApplicationName: 'Application',
                creator: 'Created From',
                user: 'User',
                createdTime: 'Created at',
                updateTime: 'Update Time',
                failedReason: 'Key Information',
                control: {
                    title: 'Operations',
                    label: 'View',
                },
                queenRemain: 'Queen Remain',
                queueUsed: 'Queue Used',
                queueTop: 'Queue Max',
                engineRemain: 'Engine Remain',
                engineUsed: 'Engine Used',
                engineTop: 'Engine Max',
                versionTips:
                    'If no engine version is available, check whether the engine materials of the corresponding version are installed',
                applicationRole: 'Application role',
            },
            logLoading: 'Requesting logs, please hold on',
            title: 'Linkis Control Panel',
            info: '{num} new messages',
            hint: 'Please view in the redirected page……',
            sideNavList: {
                news: {
                    name: 'Latest Activities',
                    children: {
                        daily: 'Daily Operation Report',
                    },
                },
                function: {
                    name: 'Frequently Used',
                    children: {
                        globalHistory: 'Global History',
                        resource: 'Resource Management',
                        resourceEngineConnList: 'History Engine',
                        setting: 'Settings',
                        globalVariable: 'Global Variables',
                        microserviceManage: 'Microservice Management',
                        ECMManage: 'ECM Management',
                        udfFunctionTitle: 'UDF Function',
                        udfFunctionManage: 'UDF Management',
                        functionManagement: 'Function Management',
                        dataSourceManage: 'DataSource Management',
                        userResourceManagement: 'User Resource Management',
                        tenantTagManagement: 'Tenant Tag Management',
                        ipListManagement: 'White List Management',
                        errorCode: 'Error Manage',
                        gatewayAuthToken: 'Token Manage',
                        engineConfigurationTemplate:
                            'Engine Configuration Template',
                        rmExternalResourceProvider:
                            'External Resource Provider Manage',
                        configManagement: 'Config Management',
                        udfManager: 'UDF User Manage',
                        udfTree: 'UDF Tree',
                        datasourceAccess: 'Data source access permissions',
                        datasourceEnv: 'DataSource Environment',
                        datasourceType: 'DataSource Type',
                        datasourceTypeKey: 'Datasource Config Options',
                        EnginePluginManagement: 'Engine Plugin Management',
                        basedataManagement: 'Basic Data Management',
                        codeQuery: 'Code Retrieval',
                        EngineConnList: 'Engine Conn List',
                    },
                },
            },
            modal: {
                modalTitle: 'Prompt message ',
                modalDelete: 'Confirm whether to delete the [{name} option?',
                modalDeleteRecord: 'Confirm whether to delete the record?',
                modalDeleteTask: 'Confirm whether to stop the selected task?',
                modalDeleteInstance:
                    'Determines whether to stop the current selected instance?',
                modalDeleteSuccess: 'Deleted successfully',
                modalDeleteFail: 'Delete failed',
            },
            formItems: {
                id: {
                    placeholder: 'Please search by entering the ID',
                },
                date: {
                    label: ' Start Date',
                    placeholder: 'Please choose the start date',
                },
                instance: {
                    label: 'Instance',
                    placeholder: 'Please search by entering the instance',
                },
                creator: {
                    label: 'Creator',
                    placeholder: 'Please search by entering the creator',
                },
                engine: {
                    label: 'Engine',
                },
                status: {
                    label: 'Status',
                },
                appType: 'App Type',
                engineType: 'Engine',
            },
            columns: {
                taskID: 'Task ID',
                execId: 'Task Name',
                fileName: 'Script Name',
                executionCode: 'Execution Code',
                status: 'Status',
                costTime: 'Time Elapsed',
                failedReason: 'Key Information',
                executeApplicationName: 'Engine',
                requestApplicationName: 'Application',
                umUser: 'Username',
                progress: 'Progress',
                createdTime: 'Created at',
                updatedTime: 'Updated at',
                control: {
                    title: 'Operations',
                    label: 'View',
                },
                moduleName: 'Module Name',
                totalResource: 'Total Resources',
                usedResource: 'Used Resources',
                initializingResource: 'Initing Resources',
                memory: 'Memory',
                engineInstance: 'Engine Instance',
                applicationName: 'Application Name',
                usedTime: 'Started at',
                engineStatus: 'Status',
                username: 'Username',
            },
            shortcuts: {
                today: '1 Day',
                week: '1 Week',
                month: '1 Month',
            },
            statusType: {
                all: 'All',
                inited: 'Waiting',
                running: 'Running',
                succeed: 'Succeeded',
                cancelled: 'Canceled',
                failed: 'Failed',
                scheduled: 'Applying Resources',
                timeout: 'Timeout',
                retry: 'Retry',
                unknown: 'Unknown',
            },
            countList: {
                all: 'Total',
                succeed: 'Succeed',
                inited: 'Inited',
                running: 'Running',
                failed: 'Failed',
                others: 'Others',
            },
            header: 'Resource Manager',
            tabs: {
                first: 'User Sessions',
                second: 'User Resources',
                third: 'Server Resources',
            },
            noLimit: 'Unlimited',
            core: 'Cores',
            row: {
                applicationName: 'Application Name',
                usedTime: 'Started at',
                engineStatus: 'Status',
                engineInstance: 'Engine Instance',
                queueName: 'Queue Name',
                user: 'User',
                cpu: 'Used server CPU resources',
                memory: 'Used server memory resources',
                queueCpu: 'Used Yarn queue CPU resources',
                queueMemory: 'Used Yarn queue memory resources',
            },
            setting: {
                global: 'Global',
                globalSetting: 'Global Settings',
                hide: 'Hide',
                show: 'Show',
                advancedSetting: 'Advanced Settings',
                dataDev: 'Data Development',
            },
            globalVariable: 'Global Variables',
            rules: {
                first: {
                    required: 'The key of variable {text} is empty',
                    lengthLimit: 'Length between 1 to 128 characters',
                    letterTypeLimit:
                        'Started with alphabetic characters, spance and Chinese characters are not allowed',
                    placeholder: 'Please enter the variable name',
                },
                second: {
                    required: 'The value of variable {text} is empty',
                    lengthLimit: 'Length between 1 to 128 characters',
                    placeholder: 'Please enter the variable value',
                },
            },
            addArgs: 'New argument',
            emptyDataText: 'No global variable data yet',
            sameName: 'Duplicated key',
            error: {
                validate: 'Invalid items found, please check and then retry!',
            },
            success: {
                update: 'Successfully updated global variables!',
            },
            searchAppType: 'Please enter App Type',
            resetTip: 'Are you sure to reset the resource?',
            resetAllTip:
                'Whether to reset all user resources (this operation will only clean up user resource records, not the resources that have been generated)?',
            viewlog: 'View Log',
            datasource: {
                pleaseUpload: 'Please upload',
                pleaseInput: 'Please input',
                datasourceSrc: 'DataSource',
                connectTest: 'Test Connection',
                sourceName: 'DataSource Name',
                sourceDec: 'DataSource Description',
                sourceType: 'DataSource Type',
                creator: 'Creator',
                create: 'Add Source',
                exports: 'Export Sources',
                imports: 'Importing Sources',
                overdue: 'Expire',
                versionList: 'Version list',
                dataSourceName: 'DataSource Name',
                dataSourceType: 'DataSource Type',
                createSystem: 'Create System',
                dataSourceEnv: 'Available Space',
                status: 'Status',
                permissions: 'Permissions',
                label: 'Label',
                version: 'Version',
                desc: 'Description',
                action: 'Action',
                createUser: 'Create User',
                createTime: 'Create Time',
                versionDec: 'Version Description',
                watch: 'View',
                rollback: 'Rollback',
                publish: 'Publish',
                initVersion: 'Initial Version',
                updateVersion: 'Version Update',
                published: 'Published',
                unpublish: 'Unpublished',
                cannotPublish: 'Cannot publish',
                used: 'Available',
                commentValue: 'Roll back from version {text}',
                undefinedVersion: 'Cannot find the version of DataSource',
            },
            tenantTagManagement: {
                userName: 'User Name',
                appName: 'Application Name',
                tenantTag: 'Tenant Tag',
                search: 'Search',
                clear: 'Clear',
                create: 'Create',
                userCreator: 'User-Creator',
                createUser: 'Create User',
                createTime: 'Create Time',
                desc: 'Description',
                inputUser: 'Please Input User',
                inputApp: 'Please Input Application',
                inputTenant: 'Please Input Tenant Tag',
                inputDesc: 'Please Input Description',
                inputCreateUser: 'Please Input Creare User',
                yourTagMapping: 'Your Tag Mapping',
                notEmpty: 'Cannot be empty',
                maxLen: 'A maximum of 100 characters is allowed',
                contentError: 'English, numbers, asterisk and underline only',
                contentError1: 'English, numbers and underline only',
                contentError2: 'English, numbers, underscores and dashes only',
                check: 'Check',
                OK: 'OK',
                Cancel: 'Cancel',
                action: 'Action',
                edit: 'Edit',
                delete: 'Delete',
                userIsExisted: 'User Tag Already Exists',
                addSuccessful: 'Successfully Addded',
                editSuccessful: 'Successfully edited',
                confirmDel: 'Confirm Deletion',
                isConfirmDel:
                    'Are you sure you want to delete this tag({name})',
            },
            ipListManagement: {
                userName: 'User Name',
                appName: 'Application Name',
                ipList: 'IP List',
                search: 'Search',
                clear: 'Clear',
                create: 'Create',
                userCreator: 'User-Creator',
                createUser: 'Create User',
                createTime: 'Create Time',
                desc: 'Description',
                inputUser: 'Please Input User',
                inputApp: 'Please Input Application',
                inputIpList: 'Please Input IP List',
                inputDesc: 'Please Input Description',
                inputCreateUser: 'Please Input Creare User',
                yourTagMapping: 'Your Tag Mapping',
                notEmpty: 'Cannot be empty',
                maxLen: 'A maximum of 100 characters is allowed',
                contentError: 'English, numbers, asterisk and underline only',
                contentError1: 'English, numbers and underline only',
                contentError2: 'English, numbers, underscores and dashes only',
                ipContentError:
                    'Please enter IP addresses in correct format.(Multiple IP addresses pass through, separate)',
                check: 'Check',
                OK: 'OK',
                Cancel: 'Cancel',
                action: 'Action',
                edit: 'Edit',
                delete: 'Delete',
                userIsExisted: 'User Tag Already Exists',
                addSuccessful: 'Successfully Addded',
                editSuccessful: 'Successfully edited',
                confirmDel: 'Confirm Deletion',
                isConfirmDel:
                    'Are you sure you want to delete this tag({name})',
            },
            basedataManagement: {
                add: 'Add',
                remove: 'Remove',
                edit: 'Edit',
                searchLabel: 'Fuzzy Search:',
                searchPlaceholder: 'Please enter your search',
                search: 'Search',
                action: 'Action',
                categoryMaxLength: 'The length cannot exceed 100',
                tableId: 'Table ID',
                applicationId: 'Application ID',
                visitor: 'Visitor',
                field: 'Field',
                accessTime: 'Access Time',
                modal: {
                    confirm: 'Confirm',
                    cancel: 'Cancel',
                    modalTitle: 'Info',
                    modalFormat: 'Confirm deleting the {0} record?',
                    modalDelete1:
                        'Confirm that the record [{name}] should be deleted?',
                    modalDelete:
                        'Confirm that the record [{name}] should be deleted?',
                    modalDeleteSuccess: 'Successfully delete',
                    modalDeleteFail: 'Fail to delete',
                    modalAddSuccess: 'Successfully added',
                    modalAddFail: 'Fail to add',
                    modalEditSuccess: 'Edit successful',
                    modalEditFail: 'Edit failure',
                },
                addUDFAdmin: 'Add UDF administrator',
                gatewayAuthToken: {
                    tokenName: 'Token Name',
                    legalUsers: 'Legal Users',
                    legalHosts: 'Legal Hosts',
                    elapseDay: 'Elapse Day',
                    permanentlyValid: 'Permanently Valid',
                    businessOwner: 'Owner',
                    createTime: 'Create Time',
                    updateTime: 'Update Time',
                    updateBy: 'Update By',
                    searchPlaceholder: 'TokenName/Users/Hosts',
                    info: 'Elapse Day: -1 means permanent',
                    legalUsersInfo:
                        '* Allow all users; Multi-user use, separated, for example :user1,user2',
                    legalUsersValidate: {
                        empty: 'Please enter the Users',
                    },
                    legalHostsInfo:
                        '* Allow all hosts; Use multiple hosts, separated, for example :host1,host2',
                    legalHostsInfoValidate: {
                        empty: 'Please enter the Hosts',
                    },
                    elapseDayValidate: {
                        size: 'The Elapse Day cannot be less than -1',
                        empty: 'Please enter the elapse day',
                        GT0: 'Valid days must be greater than 0',
                    },
                },
                errorCode: {
                    errorCode: 'Code',
                    errorDesc: 'Desc',
                    errorRegex: 'Regex',
                    searchPlaceholder: 'Code/Desc/Regex',
                },
                rmExternalResourceProvider: {
                    resourceType: 'Resource Type',
                    name: 'Name',
                    labels: 'Labels',
                    config: 'Config',
                    searchPlaceholder: 'Name/Labels/Config',
                },
                udfManager: {
                    userName: 'User Name',
                    searchPlaceholder: 'UserName',
                    userNameValidate: {
                        size: 'Usernames cannot be longer than 20 characters',
                        empty: 'Please enter your username',
                    },
                },
                udfTree: {
                    name: 'Name',
                    category: 'Category',
                    userName: 'User Name',
                    description: 'Description',
                    parent: 'Parent',
                    createTime: 'Create Time',
                    updateTime: 'Update Time',
                    searchPlaceholder: 'Name/Category/Desc/UserName',
                    parentInfo:
                        'Parent classification, Root is the root directory',
                },
                datasourceEnv: {
                    envName: 'Env Name',
                    envDesc: 'Env Desc',
                    name: 'Name',
                    datasourceType: 'Datasource Type',
                    keytab: 'Kerboros',
                    parameter: 'Parameter',
                    createTime: 'Create Time',
                    createUser: 'Create User',
                    updateTime: 'Update Time',
                    modifyUser: 'Modify User',
                    searchPlaceholder: 'EnvName/EnvDesc/Param',
                },
                engineConfigurationTemplate: {
                    engineLabelId: 'Engine Label Id',
                    advanced: 'Advanced',
                    defaultValue: 'Default Value',
                    description: 'Description',
                    engineConnType: 'Engine Type',
                    key: 'Key',
                    level: 'Level',
                    name: 'Name',
                    treeName: 'Tree Name',
                    validateRange: 'Validate Range',
                    validateType: 'Validate Type',
                    hidden: 'hidden',
                    id: 'ID',
                    engineLabelList: 'Engine Label List',
                    yes: 'yes',
                    no: 'no',
                    delSuccess: 'Deletion succeeded',
                    delFail: 'Deletion failed',
                    ModSuccess: 'Modification succeeded',
                    ModFail: 'Modification failed',
                    edit: 'edit',
                },
                datasourceType: {
                    name: 'Name',
                    description: 'Description',
                    option: 'Option',
                    classifier: 'Classifier',
                    icon: 'Icon',
                    layers: 'Layers',
                    searchPlaceholder: 'Name/Desc/Classifier',
                    layersValidate: {
                        range: 'The minimum is 0',
                    },
                },
                datasourceTypeKey: {
                    key: 'Key',
                    dataSourceType: 'Datasource Type',
                    name: 'Name(Chinese)',
                    nameEn: 'Name',
                    valueType: 'Value Type',
                    scope: 'Scope',
                    require: 'Require',
                    defaultValue: 'Default Value',
                    description: 'Description(Chinese)',
                    descriptionEn: 'Description',
                    valueRegex: 'Value Regex',
                    createTime: 'Create Time',
                    updateTime: 'Update Time',
                    searchPlaceholder: 'Name',
                    searchName: '名称',
                    searchType: '类型',
                    all: 'All',
                },
            },
            EnginePluginManagement: {
                engineConnType: "Engine Type",
                engineConnVersion: "Engine Version",
                create: "Add Engine Plugin",
                fileName: "File Name",
                fileSize: "File Size",
                lastModified: "File Update Time",
                bmlResourceId: "Material Resource Id",
                bmlResourceVersion: "Material Resource Version",
                lastUpdateTime: "Update Time",
                createTime: "Creation Time",
                Reset: "Reset",
                delete: "Delete the version of the selected material",
                update: "Update Engine Plugin",
                updateFileOnly: "Update",
                resourceVersion: "Engine Material BML Version",
                user: "Affiliated Person",
                deleteCurrentbml: "Delete",
                versionList: "Version List",
                rollback: "Roll Back ",
                action: "Operation",
            },
            codeQuery: {
                executionCode: 'Execution Code',
                dateRange: 'Date Range',
                placeholder: {
                    executionCode: 'Please input execution code',
                    dateRange: 'Please select date range',
                    status: 'Please select status',
                },
                inputCode: 'Please input execution code',
                id: 'ID',
                code: 'Code',
                check: 'View',
                search: 'Search',
                clear: 'Clear',
                status: 'Status',
                submitUser: 'Submit User',
                createdTime: 'Created Time',
                searchRange: 'Only T-1 history code can be queried',
            },
            task: {
                projectName: 'Project Name',
                workflowName: 'Workflow Name',
                workflowIp: 'Workflow IP',
            },
        },
    },
};
