export default {
  en: {
    importSql: 'Import SQL',
    modelFromSql: 'Add Model From SQL',
    generateModel: 'Import SQL',
    pleImport: 'Upload SQL Files',
    sqlFiles: 'Upload',
    sqlBox: 'SQL Box',
    checkAll: 'Check All',
    cancelAll: 'Uncheck All',
    addTofavorite: 'Submit',
    messages: 'Error Messages:',
    suggestion: 'Suggestion:',
    filesSizeError: 'The total file size cannot exceed 5 MB',
    fileTypeError: 'Invalid file format。',
    uploadFileTips: 'Please upload .txt or .sql file which\'s no larger than 5MB in total. Please use semicolon to separate multiple SQLs.',
    submitConfirm: '{unCheckedSQL} validated SQL statements are not selected, do you want to ignore them and submit anyway?',
    addSuccess: '{sqlsNum} new SQL statement(s) has(have) been imported successfully. {importedNum} of them has(have) been added to the waiting list',
    end: '.',
    existedMsg1: ', and {existedNum} of them is(are) duplicated',
    existedMsg2: ' (where {blackNum} statement(s) has(have) been added to the black list and will not be accelerated)',
    renameError: 'Model with the same name already exists. Please rename it.',
    delSql: 'Are you sure you want to delete this SQL?',
    delSqlTitle: 'Delete SQL',
    recommendations: 'Recommendation',
    index: 'Index',
    convert: 'Convert to Recommendations',
    noConvert: 'Create New Models',
    newModelList: 'New Model',
    renameTips: 'The automatically generated model name may exceed the character limit and be automatically truncated. It is recommended to modify them for better management and retrieval.',
    newModelTips: 'You can select the new models you want and expand to see which SQL these models come from. Click the Submit button and the new models will be added to the model list, which you can view and edit on the model page.',
    originModelTips: 'You can observe the number of new recommendations for existing models and expand to see which SQL these recommendations come from. The new recommendations have been added to the recommendation lists of the corresponding models, where you can accept the required recommendations.',
    existedAnsweredModels: 'Some of the imported SQLs could be answered by existing models. Do you want to convert these SQLS to recommendations of the existing models? Otherwise, new models will be created.',
    th_name: 'Name',
    th_type: 'Type',
    measure: 'Measure',
    dimension: 'Dimension',
    cc: 'Computed Columns',
    th_column: 'Column',
    th_parameter: 'Function Parameter',
    th_expression: 'Expression',
    th_function: 'Function',
    uploadSizeTip: 'Please use semicolon to separate multiple SQLs. To avoid possible errors, please don\'t edit the uploaded file before the model is added.',
    selectModelsAndRecommends: 'Selected {models} model(s), {recommends} recommendation(s).',
    selectModelTips: 'Selected {models} model(s).',
    selectRecommendTips: 'Selected {recommends} recommendation(s).',
    sqlInfo: 'This model (recommendation) could be answered by how many imported SQLs',
    recommendType: 'Type',
    ADD: 'Add',
    AGG: 'Aggregate Index',
    TABLE: 'Table Index',
    successCreateModels: 'Successfully added {models} model(s)',
    successCreateModelsAndRecommends: 'Successfully added {models} model(s), accepted {recommends} recommendation(s), The added indexes would be ready for queries after being built.',
    successCreateRecommends: 'Successfully accepted {recommends} recommendation(s), The added indexes would be ready for queries after being built.',
    confirmCancel: 'Confirm to Cancel',
    backToEdit: 'Continue Editing',
    closeSqlDialogTip: 'Once cancel, all edits would be discarded. Are you sure you want to cancel?',
    recommendsOverSizeTip: 'Recommendations can\'t be shown properly due to the extreme large amount. Please try selecting fewer SQLs to import at a time.',
    recommendsOverSizeTitle: 'Can\'t Show All Recommendations',
    mergeSqlTip: 'Similar SQLs might have been merged. Non-equal join condition are not supported. ',
    preview: 'Preview',
    model: 'Model',
    sqlOverSizeTip: 'Up to 200 SQLs could be uploaded at a time. Please try selecting fewer files to upload.',
    recommendationTip: 'Please note that the selected recommendations would be effective immediately after proceeding',
    editSqlTips: 'You have unsaved edits. Do you want to continue?',
    confirmEditSqlText: 'Save and Continue',
    noRecommendsTip: 'No valid recommendation. Existing models might already include the same indexes.',
    noModelDetailsTip: 'The selected model\'s dimension, measure, computed column, aggregate index would be shown here.',
    noOriginDetailsTip: 'The selected recommendation\'s dimension, measure, computed column would be shown here.',
    importSuccess: 'Imported successfully',
    uploadRule1: 'Please upload .txt or .sql file',
    uploadRule2: 'Valid SQLs shall be included in the file',
    uploadRule3: 'The total file size can\'t be larger than 5 MB',
    uploadRule4: 'Up to {size} SQLs could be uploaded at a time',
    addBaseIndexCheckBox: 'Add Base Indexes',
    baseIndexTips: 'Base indexes include all dimensions and measures of the model and automatically update as the model changes by default（Only batch data is supported for now）',
    uploadErrorMsg: 'The included SQLs exceed the maximum limit ({maxCount}) at a time. Please check and upload again.'
  },
  'zh-cn': {
    importSql: '导入 SQL 文件',
    modelFromSql: 'SQL 建模',
    generateModel: '确认导入的 SQL',
    pleImport: '上传 SQL 文件',
    sqlFiles: '上传',
    sqlBox: 'SQL 窗口',
    checkAll: '全选',
    cancelAll: '取消全选',
    addTofavorite: '提交',
    messages: '错误信息：',
    suggestion: '修改建议：',
    filesSizeError: '总文件大小不能超过 5 MB',
    fileTypeError: '不支持的文件格式！',
    uploadFileTips: '请上传总量不超过 5MB 的 .txt 或 .sql 文件。多条 SQL 请使用英文分号隔开。',
    submitConfirm: '还有 {unCheckedSQL} 条正确的 SQL 未被选中，是否忽略并直接提交？',
    addSuccess: '共导入 {sqlsNum} 条查询。{importedNum} 条新增进入可加速列表',
    end: '。',
    existedMsg1: '，{existedNum} 条已存在',
    existedMsg2: '（其中 {blackNum} 条已被加入黑名单，未能进入加速列表）',
    renameError: '已存在同名的模型。',
    delSql: '确定删除这条查询语句吗？',
    delSqlTitle: '删除查询语句',
    recommendations: '优化建议',
    index: '索引',
    convert: '转换为优化建议',
    noConvert: '创建模型',
    newModelList: '新增模型',
    renameTips: '自动生成的模型名称可能超出字符限制自动截断，建议修改以便管理和检索。',
    newModelTips: '您可以勾选需要的新模型，并展开查看该模型来自于哪些 SQL。点击提交按钮，所勾选的模型将会被加入模型列表，您可以在模型页面进行查看和编辑。',
    originModelTips: '您可以查看已有模型的新增建议数量，并展开查看它们来自于哪些 SQL。新增优化建议已经被加入对应模型的优化建议列表中，您可以在对应模型的优化建议中选择并通过需要的建议。',
    existedAnsweredModels: '当前已有模型可回答部分导入的 SQL。是否将这部分 SQL 转换成对应模型的优化建议？或对这部分SQL创建新的模型。',
    th_name: '名称',
    th_type: '类型',
    th_column: '列',
    th_parameter: '函数参数',
    th_function: '函数',
    th_expression: '表达式',
    measure: '度量',
    dimension: '维度',
    cc: '可计算列',
    uploadSizeTip: '多条 SQL 请使用英文分号隔开。建模完成前请勿修改已上传的文件，否则可能导致出错。',
    selectModelsAndRecommends: '已选择 {models} 个模型，{recommends} 条优化建议',
    selectModelTips: '已选择 {models} 个模型',
    selectRecommendTips: '已选择 {recommends} 条优化建议',
    sqlInfo: '表示该模型（优化建议）可被多少条导入SQL击中',
    recommendType: '建议类型',
    ADD: '新增',
    AGG: '聚合索引',
    TABLE: '明细索引',
    successCreateModels: '成功添加 {models} 个模型',
    successCreateModelsAndRecommends: '成功添加 {models} 个模型，接受 {recommends} 条优化建议，新增索引在构建之后可以服务于查询。',
    successCreateRecommends: '成功接受 {recommends} 条优化建议，新增索引在构建之后可以服务于查询。',
    confirmCancel: '确认取消',
    backToEdit: '返回编辑',
    closeSqlDialogTip: '一旦取消，将退出SQL建模，同时所有编辑会被丢弃。确定要取消吗？',
    recommendsOverSizeTip: '优化建议超过显示上限。请尝试减少导入 SQL 的数量。',
    recommendsOverSizeTitle: '优化建议无法显示',
    mergeSqlTip: '相似的 SQL 会在此页面进行合并。非等值关联关系暂不支持。',
    preview: '预览',
    model: '模型',
    sqlOverSizeTip: '一次最多可上传 200 条 SQL。请重新上传。',
    recommendationTip: '请注意，所选的优化建议将立即生效',
    editSqlTips: 'SQL 编辑尚未保存，是否继续？',
    confirmEditSqlText: '保存并继续',
    noRecommendsTip: '没有有效的优化建议。现有模型可能已包含相同的索引。',
    noModelDetailsTip: '选中模型包含的维度、度量、可计算列、聚合索引等信息会显示在这里。',
    noOriginDetailsTip: '选中优化建议包含的维度、度量、可计算列等信息会显示在这里。',
    importSuccess: '导入成功',
    uploadRule1: '请上传 .txt 或 .sql 文件',
    uploadRule2: '文件包含有效的 SQL',
    uploadRule3: '文件大小总量不超过 5MB',
    uploadRule4: '一次最多可上传 {size} 条 SQL',
    addBaseIndexCheckBox: '添加基础索引',
    baseIndexTips: '基础索引包含模型全部维度和度量，默认随着模型变化自动更新（暂时仅支持批数据）',
    uploadErrorMsg: '上传的 SQL 数量超过单次上限 ({maxCount}) ，请检查后重新上传。'
  }
}
