/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiCommissionState;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiConfigStalenessStatus;
import com.cloudera.api.swagger.model.ApiEntityStatus;
import com.cloudera.api.swagger.model.ApiEntityTag;
import com.cloudera.api.swagger.model.ApiEntityType;
import com.cloudera.api.swagger.model.ApiHealthCheck;
import com.cloudera.api.swagger.model.ApiHealthSummary;
import com.cloudera.api.swagger.model.ApiHostRef;
import com.cloudera.api.swagger.model.ApiRoleConfigGroupRef;
import com.cloudera.api.swagger.model.ApiRoleState;
import com.cloudera.api.swagger.model.ApiServiceRef;
import com.cloudera.api.swagger.model.HaStatus;
import com.cloudera.api.swagger.model.ZooKeeperServerMode;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A role represents a specific entity that participate in a service. Examples are JobTrackers, DataNodes, HBase Masters. Each role is assigned a host where it runs on.")
public class ApiRole {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="hostRef")
    private ApiHostRef hostRef = null;
    @SerializedName(value="serviceRef")
    private ApiServiceRef serviceRef = null;
    @SerializedName(value="roleState")
    private ApiRoleState roleState = null;
    @SerializedName(value="commissionState")
    private ApiCommissionState commissionState = null;
    @SerializedName(value="healthSummary")
    private ApiHealthSummary healthSummary = null;
    @SerializedName(value="configStale")
    private Boolean configStale = null;
    @SerializedName(value="configStalenessStatus")
    private ApiConfigStalenessStatus configStalenessStatus = null;
    @SerializedName(value="healthChecks")
    private List<ApiHealthCheck> healthChecks = null;
    @SerializedName(value="haStatus")
    private HaStatus haStatus = null;
    @SerializedName(value="roleUrl")
    private String roleUrl = null;
    @SerializedName(value="maintenanceMode")
    private Boolean maintenanceMode = null;
    @SerializedName(value="maintenanceOwners")
    private List<ApiEntityType> maintenanceOwners = null;
    @SerializedName(value="config")
    private ApiConfigList config = null;
    @SerializedName(value="roleConfigGroupRef")
    private ApiRoleConfigGroupRef roleConfigGroupRef = null;
    @SerializedName(value="zooKeeperServerMode")
    private ZooKeeperServerMode zooKeeperServerMode = null;
    @SerializedName(value="entityStatus")
    private ApiEntityStatus entityStatus = null;
    @SerializedName(value="tags")
    private List<ApiEntityTag> tags = null;

    public ApiRole name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The name of the role. Optional when creating a role since API v6. If not specified, a name will be automatically generated for the role.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiRole type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the role, e.g. NAMENODE, DATANODE, TASKTRACKER.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ApiRole hostRef(ApiHostRef hostRef) {
        this.hostRef = hostRef;
        return this;
    }

    @ApiModelProperty(value="A reference to the host where this role runs.")
    public ApiHostRef getHostRef() {
        return this.hostRef;
    }

    public void setHostRef(ApiHostRef hostRef) {
        this.hostRef = hostRef;
    }

    public ApiRole serviceRef(ApiServiceRef serviceRef) {
        this.serviceRef = serviceRef;
        return this;
    }

    @ApiModelProperty(value="Readonly. A reference to the parent service.")
    public ApiServiceRef getServiceRef() {
        return this.serviceRef;
    }

    public void setServiceRef(ApiServiceRef serviceRef) {
        this.serviceRef = serviceRef;
    }

    public ApiRole roleState(ApiRoleState roleState) {
        this.roleState = roleState;
        return this;
    }

    @ApiModelProperty(value="Readonly. The configured run state of this role. Whether it's running, etc.")
    public ApiRoleState getRoleState() {
        return this.roleState;
    }

    public void setRoleState(ApiRoleState roleState) {
        this.roleState = roleState;
    }

    public ApiRole commissionState(ApiCommissionState commissionState) {
        this.commissionState = commissionState;
        return this;
    }

    @ApiModelProperty(value="Readonly. The commission state of this role. Available since API v2.")
    public ApiCommissionState getCommissionState() {
        return this.commissionState;
    }

    public void setCommissionState(ApiCommissionState commissionState) {
        this.commissionState = commissionState;
    }

    public ApiRole healthSummary(ApiHealthSummary healthSummary) {
        this.healthSummary = healthSummary;
        return this;
    }

    @ApiModelProperty(value="Readonly. The high-level health status of this role.")
    public ApiHealthSummary getHealthSummary() {
        return this.healthSummary;
    }

    public void setHealthSummary(ApiHealthSummary healthSummary) {
        this.healthSummary = healthSummary;
    }

    public ApiRole configStale(Boolean configStale) {
        this.configStale = configStale;
        return this;
    }

    @ApiModelProperty(value="Readonly. Expresses whether the role configuration is stale.")
    public Boolean getConfigStale() {
        return this.configStale;
    }

    public void setConfigStale(Boolean configStale) {
        this.configStale = configStale;
    }

    public ApiRole configStalenessStatus(ApiConfigStalenessStatus configStalenessStatus) {
        this.configStalenessStatus = configStalenessStatus;
        return this;
    }

    @ApiModelProperty(value="Readonly. Expresses the role's configuration staleness status. Available since API v6.")
    public ApiConfigStalenessStatus getConfigStalenessStatus() {
        return this.configStalenessStatus;
    }

    public void setConfigStalenessStatus(ApiConfigStalenessStatus configStalenessStatus) {
        this.configStalenessStatus = configStalenessStatus;
    }

    public ApiRole healthChecks(List<ApiHealthCheck> healthChecks) {
        this.healthChecks = healthChecks;
        return this;
    }

    public ApiRole addHealthChecksItem(ApiHealthCheck healthChecksItem) {
        if (this.healthChecks == null) {
            this.healthChecks = new ArrayList<ApiHealthCheck>();
        }
        this.healthChecks.add(healthChecksItem);
        return this;
    }

    @ApiModelProperty(value="Readonly. The list of health checks of this service.")
    public List<ApiHealthCheck> getHealthChecks() {
        return this.healthChecks;
    }

    public void setHealthChecks(List<ApiHealthCheck> healthChecks) {
        this.healthChecks = healthChecks;
    }

    public ApiRole haStatus(HaStatus haStatus) {
        this.haStatus = haStatus;
        return this;
    }

    @ApiModelProperty(value="Readonly. The HA status of this role.")
    public HaStatus getHaStatus() {
        return this.haStatus;
    }

    public void setHaStatus(HaStatus haStatus) {
        this.haStatus = haStatus;
    }

    public ApiRole roleUrl(String roleUrl) {
        this.roleUrl = roleUrl;
        return this;
    }

    @ApiModelProperty(value="Readonly. Link into the Cloudera Manager web UI for this specific role.")
    public String getRoleUrl() {
        return this.roleUrl;
    }

    public void setRoleUrl(String roleUrl) {
        this.roleUrl = roleUrl;
    }

    public ApiRole maintenanceMode(Boolean maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
        return this;
    }

    @ApiModelProperty(value="Readonly. Whether the role is in maintenance mode. Available since API v2.")
    public Boolean getMaintenanceMode() {
        return this.maintenanceMode;
    }

    public void setMaintenanceMode(Boolean maintenanceMode) {
        this.maintenanceMode = maintenanceMode;
    }

    public ApiRole maintenanceOwners(List<ApiEntityType> maintenanceOwners) {
        this.maintenanceOwners = maintenanceOwners;
        return this;
    }

    public ApiRole addMaintenanceOwnersItem(ApiEntityType maintenanceOwnersItem) {
        if (this.maintenanceOwners == null) {
            this.maintenanceOwners = new ArrayList<ApiEntityType>();
        }
        this.maintenanceOwners.add(maintenanceOwnersItem);
        return this;
    }

    @ApiModelProperty(value="Readonly. The list of objects that trigger this role to be in maintenance mode. Available since API v2.")
    public List<ApiEntityType> getMaintenanceOwners() {
        return this.maintenanceOwners;
    }

    public void setMaintenanceOwners(List<ApiEntityType> maintenanceOwners) {
        this.maintenanceOwners = maintenanceOwners;
    }

    public ApiRole config(ApiConfigList config) {
        this.config = config;
        return this;
    }

    @ApiModelProperty(value="The role configuration. Optional.")
    public ApiConfigList getConfig() {
        return this.config;
    }

    public void setConfig(ApiConfigList config) {
        this.config = config;
    }

    public ApiRole roleConfigGroupRef(ApiRoleConfigGroupRef roleConfigGroupRef) {
        this.roleConfigGroupRef = roleConfigGroupRef;
        return this;
    }

    @ApiModelProperty(value="Readonly. The reference to the role configuration group of this role. Available since API v3.")
    public ApiRoleConfigGroupRef getRoleConfigGroupRef() {
        return this.roleConfigGroupRef;
    }

    public void setRoleConfigGroupRef(ApiRoleConfigGroupRef roleConfigGroupRef) {
        this.roleConfigGroupRef = roleConfigGroupRef;
    }

    public ApiRole zooKeeperServerMode(ZooKeeperServerMode zooKeeperServerMode) {
        this.zooKeeperServerMode = zooKeeperServerMode;
        return this;
    }

    @ApiModelProperty(value="Readonly. The ZooKeeper server mode for this role. Note that for non-ZooKeeper Server roles this will be null. Available since API v6.")
    public ZooKeeperServerMode getZooKeeperServerMode() {
        return this.zooKeeperServerMode;
    }

    public void setZooKeeperServerMode(ZooKeeperServerMode zooKeeperServerMode) {
        this.zooKeeperServerMode = zooKeeperServerMode;
    }

    public ApiRole entityStatus(ApiEntityStatus entityStatus) {
        this.entityStatus = entityStatus;
        return this;
    }

    @ApiModelProperty(value="Readonly. The entity status for this role. Available since API v11.")
    public ApiEntityStatus getEntityStatus() {
        return this.entityStatus;
    }

    public void setEntityStatus(ApiEntityStatus entityStatus) {
        this.entityStatus = entityStatus;
    }

    public ApiRole tags(List<ApiEntityTag> tags) {
        this.tags = tags;
        return this;
    }

    public ApiRole addTagsItem(ApiEntityTag tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<ApiEntityTag>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(value="Tags associated with the role. Available since V41.")
    public List<ApiEntityTag> getTags() {
        return this.tags;
    }

    public void setTags(List<ApiEntityTag> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiRole apiRole = (ApiRole)o;
        return Objects.equals(this.name, apiRole.name) && Objects.equals(this.type, apiRole.type) && Objects.equals(this.hostRef, apiRole.hostRef) && Objects.equals(this.serviceRef, apiRole.serviceRef) && Objects.equals((Object)this.roleState, (Object)apiRole.roleState) && Objects.equals((Object)this.commissionState, (Object)apiRole.commissionState) && Objects.equals((Object)this.healthSummary, (Object)apiRole.healthSummary) && Objects.equals(this.configStale, apiRole.configStale) && Objects.equals((Object)this.configStalenessStatus, (Object)apiRole.configStalenessStatus) && Objects.equals(this.healthChecks, apiRole.healthChecks) && Objects.equals((Object)this.haStatus, (Object)apiRole.haStatus) && Objects.equals(this.roleUrl, apiRole.roleUrl) && Objects.equals(this.maintenanceMode, apiRole.maintenanceMode) && Objects.equals(this.maintenanceOwners, apiRole.maintenanceOwners) && Objects.equals(this.config, apiRole.config) && Objects.equals(this.roleConfigGroupRef, apiRole.roleConfigGroupRef) && Objects.equals((Object)this.zooKeeperServerMode, (Object)apiRole.zooKeeperServerMode) && Objects.equals((Object)this.entityStatus, (Object)apiRole.entityStatus) && Objects.equals(this.tags, apiRole.tags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.hostRef, this.serviceRef, this.roleState, this.commissionState, this.healthSummary, this.configStale, this.configStalenessStatus, this.healthChecks, this.haStatus, this.roleUrl, this.maintenanceMode, this.maintenanceOwners, this.config, this.roleConfigGroupRef, this.zooKeeperServerMode, this.entityStatus, this.tags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiRole {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    hostRef: ").append(this.toIndentedString(this.hostRef)).append("\n");
        sb.append("    serviceRef: ").append(this.toIndentedString(this.serviceRef)).append("\n");
        sb.append("    roleState: ").append(this.toIndentedString((Object)this.roleState)).append("\n");
        sb.append("    commissionState: ").append(this.toIndentedString((Object)this.commissionState)).append("\n");
        sb.append("    healthSummary: ").append(this.toIndentedString((Object)this.healthSummary)).append("\n");
        sb.append("    configStale: ").append(this.toIndentedString(this.configStale)).append("\n");
        sb.append("    configStalenessStatus: ").append(this.toIndentedString((Object)this.configStalenessStatus)).append("\n");
        sb.append("    healthChecks: ").append(this.toIndentedString(this.healthChecks)).append("\n");
        sb.append("    haStatus: ").append(this.toIndentedString((Object)this.haStatus)).append("\n");
        sb.append("    roleUrl: ").append(this.toIndentedString(this.roleUrl)).append("\n");
        sb.append("    maintenanceMode: ").append(this.toIndentedString(this.maintenanceMode)).append("\n");
        sb.append("    maintenanceOwners: ").append(this.toIndentedString(this.maintenanceOwners)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    roleConfigGroupRef: ").append(this.toIndentedString(this.roleConfigGroupRef)).append("\n");
        sb.append("    zooKeeperServerMode: ").append(this.toIndentedString((Object)this.zooKeeperServerMode)).append("\n");
        sb.append("    entityStatus: ").append(this.toIndentedString((Object)this.entityStatus)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

