/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiHdfsReplicationArguments;
import com.cloudera.api.swagger.model.ApiHiveTable;
import com.cloudera.api.swagger.model.ApiServiceRef;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Replication arguments for Hive services.")
public class ApiHiveReplicationArguments {
    @SerializedName(value="sourceService")
    private ApiServiceRef sourceService = null;
    @SerializedName(value="tableFilters")
    private List<ApiHiveTable> tableFilters = null;
    @SerializedName(value="exportDir")
    private String exportDir = null;
    @SerializedName(value="force")
    private Boolean force = null;
    @SerializedName(value="replicateData")
    private Boolean replicateData = null;
    @SerializedName(value="hdfsArguments")
    private ApiHdfsReplicationArguments hdfsArguments = null;
    @SerializedName(value="replicateImpalaMetadata")
    private Boolean replicateImpalaMetadata = null;
    @SerializedName(value="runInvalidateMetadata")
    private Boolean runInvalidateMetadata = null;
    @SerializedName(value="dryRun")
    private Boolean dryRun = null;
    @SerializedName(value="numThreads")
    private BigDecimal numThreads = null;
    @SerializedName(value="sentryMigration")
    private Boolean sentryMigration = null;
    @SerializedName(value="skipUrlPermissions")
    private Boolean skipUrlPermissions = null;

    public ApiHiveReplicationArguments sourceService(ApiServiceRef sourceService) {
        this.sourceService = sourceService;
        return this;
    }

    @ApiModelProperty(value="The service to replicate from.")
    public ApiServiceRef getSourceService() {
        return this.sourceService;
    }

    public void setSourceService(ApiServiceRef sourceService) {
        this.sourceService = sourceService;
    }

    public ApiHiveReplicationArguments tableFilters(List<ApiHiveTable> tableFilters) {
        this.tableFilters = tableFilters;
        return this;
    }

    public ApiHiveReplicationArguments addTableFiltersItem(ApiHiveTable tableFiltersItem) {
        if (this.tableFilters == null) {
            this.tableFilters = new ArrayList<ApiHiveTable>();
        }
        this.tableFilters.add(tableFiltersItem);
        return this;
    }

    @ApiModelProperty(value="Filters for tables to include in the replication. Optional. If not provided, include all tables in all databases.")
    public List<ApiHiveTable> getTableFilters() {
        return this.tableFilters;
    }

    public void setTableFilters(List<ApiHiveTable> tableFilters) {
        this.tableFilters = tableFilters;
    }

    public ApiHiveReplicationArguments exportDir(String exportDir) {
        this.exportDir = exportDir;
        return this;
    }

    @ApiModelProperty(value="Directory, in the HDFS service where the target Hive service's data is stored, where the export file will be saved. Optional. If not provided, Cloudera Manager will pick a directory for storing the data.")
    public String getExportDir() {
        return this.exportDir;
    }

    public void setExportDir(String exportDir) {
        this.exportDir = exportDir;
    }

    public ApiHiveReplicationArguments force(Boolean force) {
        this.force = force;
        return this;
    }

    @ApiModelProperty(value="Whether to force overwriting of mismatched tables. Defaults to false.")
    public Boolean getForce() {
        return this.force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public ApiHiveReplicationArguments replicateData(Boolean replicateData) {
        this.replicateData = replicateData;
        return this;
    }

    @ApiModelProperty(value="Whether to replicate table data stored in HDFS. Defaults to false. <p/> If set, the \"hdfsArguments\" property must be set to configure the HDFS replication job.")
    public Boolean getReplicateData() {
        return this.replicateData;
    }

    public void setReplicateData(Boolean replicateData) {
        this.replicateData = replicateData;
    }

    public ApiHiveReplicationArguments hdfsArguments(ApiHdfsReplicationArguments hdfsArguments) {
        this.hdfsArguments = hdfsArguments;
        return this;
    }

    @ApiModelProperty(value="Arguments for the HDFS replication job. <p/> This must be provided when choosing to replicate table data stored in HDFS. The \"sourceService\", \"sourcePath\" and \"dryRun\" properties of the HDFS arguments are ignored; their values are derived from the Hive replication's information. <p/> The \"destinationPath\" property is used slightly differently from the usual HDFS replication jobs. It is used to map the root path of the source service into the target service. It may be omitted, in which case the source and target paths will match. <p/> Example: if the destination path is set to \"/new_root\", a \"/foo/bar\" path in the source will be stored in \"/new_root/foo/bar\" in the target.")
    public ApiHdfsReplicationArguments getHdfsArguments() {
        return this.hdfsArguments;
    }

    public void setHdfsArguments(ApiHdfsReplicationArguments hdfsArguments) {
        this.hdfsArguments = hdfsArguments;
    }

    public ApiHiveReplicationArguments replicateImpalaMetadata(Boolean replicateImpalaMetadata) {
        this.replicateImpalaMetadata = replicateImpalaMetadata;
        return this;
    }

    @ApiModelProperty(value="Whether to replicate the impala metadata. (i.e. the metadata for impala UDFs and their corresponding binaries in HDFS).")
    public Boolean getReplicateImpalaMetadata() {
        return this.replicateImpalaMetadata;
    }

    public void setReplicateImpalaMetadata(Boolean replicateImpalaMetadata) {
        this.replicateImpalaMetadata = replicateImpalaMetadata;
    }

    public ApiHiveReplicationArguments runInvalidateMetadata(Boolean runInvalidateMetadata) {
        this.runInvalidateMetadata = runInvalidateMetadata;
        return this;
    }

    @ApiModelProperty(value="Whether to run invalidate metadata query or not")
    public Boolean getRunInvalidateMetadata() {
        return this.runInvalidateMetadata;
    }

    public void setRunInvalidateMetadata(Boolean runInvalidateMetadata) {
        this.runInvalidateMetadata = runInvalidateMetadata;
    }

    public ApiHiveReplicationArguments dryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    @ApiModelProperty(value="Whether to perform a dry run. Defaults to false")
    public Boolean getDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public ApiHiveReplicationArguments numThreads(BigDecimal numThreads) {
        this.numThreads = numThreads;
        return this;
    }

    @ApiModelProperty(value="Number of threads to use in multi-threaded export/import phase")
    public BigDecimal getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(BigDecimal numThreads) {
        this.numThreads = numThreads;
    }

    public ApiHiveReplicationArguments sentryMigration(Boolean sentryMigration) {
        this.sentryMigration = sentryMigration;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Boolean getSentryMigration() {
        return this.sentryMigration;
    }

    public void setSentryMigration(Boolean sentryMigration) {
        this.sentryMigration = sentryMigration;
    }

    public ApiHiveReplicationArguments skipUrlPermissions(Boolean skipUrlPermissions) {
        this.skipUrlPermissions = skipUrlPermissions;
        return this;
    }

    @ApiModelProperty(required=true, value="Is skipUrlPermissions on.")
    public Boolean getSkipUrlPermissions() {
        return this.skipUrlPermissions;
    }

    public void setSkipUrlPermissions(Boolean skipUrlPermissions) {
        this.skipUrlPermissions = skipUrlPermissions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHiveReplicationArguments apiHiveReplicationArguments = (ApiHiveReplicationArguments)o;
        return Objects.equals(this.sourceService, apiHiveReplicationArguments.sourceService) && Objects.equals(this.tableFilters, apiHiveReplicationArguments.tableFilters) && Objects.equals(this.exportDir, apiHiveReplicationArguments.exportDir) && Objects.equals(this.force, apiHiveReplicationArguments.force) && Objects.equals(this.replicateData, apiHiveReplicationArguments.replicateData) && Objects.equals(this.hdfsArguments, apiHiveReplicationArguments.hdfsArguments) && Objects.equals(this.replicateImpalaMetadata, apiHiveReplicationArguments.replicateImpalaMetadata) && Objects.equals(this.runInvalidateMetadata, apiHiveReplicationArguments.runInvalidateMetadata) && Objects.equals(this.dryRun, apiHiveReplicationArguments.dryRun) && Objects.equals(this.numThreads, apiHiveReplicationArguments.numThreads) && Objects.equals(this.sentryMigration, apiHiveReplicationArguments.sentryMigration) && Objects.equals(this.skipUrlPermissions, apiHiveReplicationArguments.skipUrlPermissions);
    }

    public int hashCode() {
        return Objects.hash(this.sourceService, this.tableFilters, this.exportDir, this.force, this.replicateData, this.hdfsArguments, this.replicateImpalaMetadata, this.runInvalidateMetadata, this.dryRun, this.numThreads, this.sentryMigration, this.skipUrlPermissions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHiveReplicationArguments {\n");
        sb.append("    sourceService: ").append(this.toIndentedString(this.sourceService)).append("\n");
        sb.append("    tableFilters: ").append(this.toIndentedString(this.tableFilters)).append("\n");
        sb.append("    exportDir: ").append(this.toIndentedString(this.exportDir)).append("\n");
        sb.append("    force: ").append(this.toIndentedString(this.force)).append("\n");
        sb.append("    replicateData: ").append(this.toIndentedString(this.replicateData)).append("\n");
        sb.append("    hdfsArguments: ").append(this.toIndentedString(this.hdfsArguments)).append("\n");
        sb.append("    replicateImpalaMetadata: ").append(this.toIndentedString(this.replicateImpalaMetadata)).append("\n");
        sb.append("    runInvalidateMetadata: ").append(this.toIndentedString(this.runInvalidateMetadata)).append("\n");
        sb.append("    dryRun: ").append(this.toIndentedString(this.dryRun)).append("\n");
        sb.append("    numThreads: ").append(this.toIndentedString(this.numThreads)).append("\n");
        sb.append("    sentryMigration: ").append(this.toIndentedString(this.sentryMigration)).append("\n");
        sb.append("    skipUrlPermissions: ").append(this.toIndentedString(this.skipUrlPermissions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

