/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.sso.artifact;

import org.opensaml.messaging.context.InOutOperationContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.EndpointResolver;
import org.opensaml.saml.common.binding.impl.DefaultEndpointResolver;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.metadata.resolver.RoleDescriptorResolver;
import org.opensaml.saml.metadata.resolver.impl.PredicateRoleDescriptorResolver;
import org.opensaml.saml.saml2.metadata.ArtifactResolutionService;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.security.SecurityException;
import org.opensaml.soap.client.SOAPClient;
import org.opensaml.soap.client.http.PipelineFactoryHttpSOAPClient;
import org.opensaml.soap.common.SOAPException;
import org.pac4j.core.context.WebContext;
import org.pac4j.saml.context.SAML2MessageContext;
import org.pac4j.saml.metadata.SAML2MetadataResolver;
import org.pac4j.saml.sso.artifact.FixedEntityIdResolver;
import org.pac4j.saml.sso.artifact.SOAPPipelineProvider;
import org.pac4j.saml.transport.AbstractPac4jDecoder;
import org.pac4j.saml.transport.Pac4jHTTPArtifactDecoder;

public class SAML2ArtifactBindingDecoder
extends AbstractPac4jDecoder {
    private final SAML2MetadataResolver idpMetadataResolver;
    private final SAML2MetadataResolver spMetadataResolver;
    private final SOAPPipelineProvider soapPipelineProvider;

    public SAML2ArtifactBindingDecoder(WebContext context, SAML2MetadataResolver idpMetadataResolver, SAML2MetadataResolver spMetadataResolver, SOAPPipelineProvider soapPipelineProvider) {
        super(context);
        this.idpMetadataResolver = idpMetadataResolver;
        this.spMetadataResolver = spMetadataResolver;
        this.soapPipelineProvider = soapPipelineProvider;
    }

    @Override
    public String getBindingURI(SAML2MessageContext messageContext) {
        return "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact";
    }

    protected void doDecode() throws MessageDecodingException {
        try {
            DefaultEndpointResolver endpointResolver = new DefaultEndpointResolver();
            endpointResolver.initialize();
            PredicateRoleDescriptorResolver roleResolver = new PredicateRoleDescriptorResolver(this.idpMetadataResolver.resolve());
            roleResolver.initialize();
            final SAML2MessageContext messageContext = new SAML2MessageContext();
            PipelineFactoryHttpSOAPClient<SAMLObject, SAMLObject> soapClient = new PipelineFactoryHttpSOAPClient<SAMLObject, SAMLObject>(){

                public void send(String endpoint, InOutOperationContext operationContext) throws SOAPException, SecurityException {
                    super.send(endpoint, operationContext);
                    SAML2ArtifactBindingDecoder.this.transferContext(operationContext, messageContext);
                }
            };
            soapClient.setPipelineFactory(this.soapPipelineProvider.getPipelineFactory());
            soapClient.setHttpClient(this.soapPipelineProvider.getHttpClientBuilder().buildClient());
            Pac4jHTTPArtifactDecoder artifactDecoder = new Pac4jHTTPArtifactDecoder();
            artifactDecoder.setWebContext(this.context);
            artifactDecoder.setSelfEntityIDResolver(new FixedEntityIdResolver(this.spMetadataResolver));
            artifactDecoder.setRoleDescriptorResolver((RoleDescriptorResolver)roleResolver);
            artifactDecoder.setArtifactEndpointResolver((EndpointResolver<ArtifactResolutionService>)endpointResolver);
            artifactDecoder.setPeerEntityRole(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
            artifactDecoder.setSOAPClient((SOAPClient)soapClient);
            artifactDecoder.setParserPool(this.getParserPool());
            artifactDecoder.initialize();
            artifactDecoder.decode();
            messageContext.setMessage(artifactDecoder.getMessageContext().getMessage());
            this.populateBindingContext(messageContext);
            this.setMessageContext(messageContext);
        }
        catch (Exception e) {
            throw new MessageDecodingException(e);
        }
    }

    protected void transferContext(InOutOperationContext<?, ?> operationContext, SAML2MessageContext messageContext) {
        messageContext.addSubcontext(operationContext.getInboundMessageContext().getSubcontext(SAMLPeerEntityContext.class));
    }
}

