/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.logout.impl;

import org.pac4j.core.context.ContextHelper;
import org.pac4j.core.context.WebContext;
import org.pac4j.saml.exceptions.SAMLException;
import org.pac4j.saml.profile.api.SAML2ResponseValidator;
import org.pac4j.saml.profile.impl.AbstractSAML2MessageReceiver;
import org.pac4j.saml.transport.AbstractPac4jDecoder;
import org.pac4j.saml.transport.Pac4jHTTPPostDecoder;
import org.pac4j.saml.transport.Pac4jHTTPRedirectDeflateDecoder;
import org.pac4j.saml.util.Configuration;

public class SAML2LogoutMessageReceiver
extends AbstractSAML2MessageReceiver {
    private static final String SAML2_SLO_PROFILE_URI = "urn:oasis:names:tc:SAML:2.0:profiles:SSO:logout";

    public SAML2LogoutMessageReceiver(SAML2ResponseValidator validator) {
        super(validator);
    }

    @Override
    protected AbstractPac4jDecoder getDecoder(WebContext webContext) {
        AbstractPac4jDecoder decoder;
        if (ContextHelper.isPost((WebContext)webContext)) {
            decoder = new Pac4jHTTPPostDecoder(webContext);
            try {
                decoder.setParserPool(Configuration.getParserPool());
                decoder.initialize();
                decoder.decode();
            }
            catch (Exception e) {
                throw new SAMLException("Error decoding POST SAML message", e);
            }
        } else if (ContextHelper.isGet((WebContext)webContext)) {
            decoder = new Pac4jHTTPRedirectDeflateDecoder(webContext);
            try {
                decoder.setParserPool(Configuration.getParserPool());
                decoder.initialize();
                decoder.decode();
            }
            catch (Exception e) {
                throw new SAMLException("Error decoding HTTP-Redirect SAML message", e);
            }
        } else {
            throw new SAMLException("Only GET or POST requests are accepted");
        }
        return decoder;
    }

    @Override
    protected String getProfileUri() {
        return SAML2_SLO_PROFILE_URI;
    }
}

