/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search.filter;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.search.NotFilter;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitNotFilter
extends GrammarAction<LdapMessageContainer<SearchRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitNotFilter.class);

    public InitNotFilter() {
        super("Initialize NOT filter");
    }

    public void action(LdapMessageContainer<SearchRequest> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_05136_EMPTY_NOT_FILTER_PDU, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        NotFilter notFilter = new NotFilter(tlv.getId());
        container.addCurrentFilter(notFilter);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05149_INITIALIZE_NOT_FILTER, (Object[])new Object[0]));
        }
    }
}

