/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import de.thetaphi.forbiddenapis.AsmUtils;
import java.util.regex.Pattern;

public final class ClassPatternRule {
    private final Pattern pattern;
    private final String glob;
    private final String message;

    public ClassPatternRule(String glob, String message) {
        if (glob == null) {
            throw new NullPointerException("glob");
        }
        this.glob = glob;
        this.pattern = AsmUtils.glob2Pattern(glob);
        this.message = message;
    }

    public boolean matches(String className) {
        return this.pattern.matcher(className).matches();
    }

    public String getPrintout(String className) {
        return this.message == null ? className : className + " [" + this.message + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.glob.hashCode();
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassPatternRule other = (ClassPatternRule)obj;
        if (!this.glob.equals(other.glob)) {
            return false;
        }
        return !(this.message == null ? other.message != null : !this.message.equals(other.message));
    }

    public String toString() {
        return "ClassPatternRule [glob=" + this.glob + ", message=" + this.message + "]";
    }
}

