/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="This is the model for interactive user session information in the API. <p> A user may have more than one active session. Each such session will have its own session object.")
public class ApiUserSession {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="remoteAddr")
    private String remoteAddr = null;
    @SerializedName(value="lastRequest")
    private String lastRequest = null;

    public ApiUserSession name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="The username associated with the session. <p> This will be the same value shown to the logged in user in the UI, which will normally be the same value they typed when logging in, but it is possible that in certain external authentication scenarios, it will differ from that value.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ApiUserSession remoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
        return this;
    }

    @ApiModelProperty(value="The remote IP address for the session. <p> This will be the remote IP address for the last request made as part of this session. It is not guaranteed to be the same IP address as was previously used, or the address used to initiate the session.")
    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public ApiUserSession lastRequest(String lastRequest) {
        this.lastRequest = lastRequest;
        return this;
    }

    @ApiModelProperty(value="The date and time of the last request received as part of this session. <p> This will be returned in ISO 8601 format from the REST API.")
    public String getLastRequest() {
        return this.lastRequest;
    }

    public void setLastRequest(String lastRequest) {
        this.lastRequest = lastRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiUserSession apiUserSession = (ApiUserSession)o;
        return Objects.equals(this.name, apiUserSession.name) && Objects.equals(this.remoteAddr, apiUserSession.remoteAddr) && Objects.equals(this.lastRequest, apiUserSession.lastRequest);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.remoteAddr, this.lastRequest);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiUserSession {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    remoteAddr: ").append(this.toIndentedString(this.remoteAddr)).append("\n");
        sb.append("    lastRequest: ").append(this.toIndentedString(this.lastRequest)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

