/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="This contains information about the host or host range on which provided host template will be applied.")
public class ApiClusterTemplateHostInfo {
    @SerializedName(value="hostName")
    private String hostName = null;
    @SerializedName(value="hostNameRange")
    private String hostNameRange = null;
    @SerializedName(value="rackId")
    private String rackId = null;
    @SerializedName(value="hostTemplateRefName")
    private String hostTemplateRefName = null;
    @SerializedName(value="roleRefNames")
    private List<String> roleRefNames = null;

    public ApiClusterTemplateHostInfo hostName(String hostName) {
        this.hostName = hostName;
        return this;
    }

    @ApiModelProperty(value="Host name")
    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public ApiClusterTemplateHostInfo hostNameRange(String hostNameRange) {
        this.hostNameRange = hostNameRange;
        return this;
    }

    @ApiModelProperty(value="Host range. Either this this or host name must be provided.")
    public String getHostNameRange() {
        return this.hostNameRange;
    }

    public void setHostNameRange(String hostNameRange) {
        this.hostNameRange = hostNameRange;
    }

    public ApiClusterTemplateHostInfo rackId(String rackId) {
        this.rackId = rackId;
        return this;
    }

    @ApiModelProperty(value="Rack Id")
    public String getRackId() {
        return this.rackId;
    }

    public void setRackId(String rackId) {
        this.rackId = rackId;
    }

    public ApiClusterTemplateHostInfo hostTemplateRefName(String hostTemplateRefName) {
        this.hostTemplateRefName = hostTemplateRefName;
        return this;
    }

    @ApiModelProperty(value="Pointing to the host template reference in the cluster template.")
    public String getHostTemplateRefName() {
        return this.hostTemplateRefName;
    }

    public void setHostTemplateRefName(String hostTemplateRefName) {
        this.hostTemplateRefName = hostTemplateRefName;
    }

    public ApiClusterTemplateHostInfo roleRefNames(List<String> roleRefNames) {
        this.roleRefNames = roleRefNames;
        return this;
    }

    public ApiClusterTemplateHostInfo addRoleRefNamesItem(String roleRefNamesItem) {
        if (this.roleRefNames == null) {
            this.roleRefNames = new ArrayList<String>();
        }
        this.roleRefNames.add(roleRefNamesItem);
        return this;
    }

    @ApiModelProperty(example="\"null\"", value="This will used to resolve the roles defined in the cluster template. This roleRefName will be used to connect this host with that a role reference defined in cluster template.")
    public List<String> getRoleRefNames() {
        return this.roleRefNames;
    }

    public void setRoleRefNames(List<String> roleRefNames) {
        this.roleRefNames = roleRefNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiClusterTemplateHostInfo apiClusterTemplateHostInfo = (ApiClusterTemplateHostInfo)o;
        return Objects.equals(this.hostName, apiClusterTemplateHostInfo.hostName) && Objects.equals(this.hostNameRange, apiClusterTemplateHostInfo.hostNameRange) && Objects.equals(this.rackId, apiClusterTemplateHostInfo.rackId) && Objects.equals(this.hostTemplateRefName, apiClusterTemplateHostInfo.hostTemplateRefName) && Objects.equals(this.roleRefNames, apiClusterTemplateHostInfo.roleRefNames);
    }

    public int hashCode() {
        return Objects.hash(this.hostName, this.hostNameRange, this.rackId, this.hostTemplateRefName, this.roleRefNames);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiClusterTemplateHostInfo {\n");
        sb.append("    hostName: ").append(this.toIndentedString(this.hostName)).append("\n");
        sb.append("    hostNameRange: ").append(this.toIndentedString(this.hostNameRange)).append("\n");
        sb.append("    rackId: ").append(this.toIndentedString(this.rackId)).append("\n");
        sb.append("    hostTemplateRefName: ").append(this.toIndentedString(this.hostTemplateRefName)).append("\n");
        sb.append("    roleRefNames: ").append(this.toIndentedString(this.roleRefNames)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

