/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.pool;

import org.ldaptive.pool.Activator;
import org.ldaptive.pool.Passivator;
import org.ldaptive.pool.PoolConfig;
import org.ldaptive.pool.PruneStrategy;
import org.ldaptive.pool.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPool<T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String name;
    private PoolConfig poolConfig;
    private Activator<T> activator;
    private Passivator<T> passivator;
    private Validator<T> validator;
    private PruneStrategy pruneStrategy;

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.logger.trace("setting name: {}", (Object)s);
        this.name = s;
    }

    public PoolConfig getPoolConfig() {
        return this.poolConfig;
    }

    public void setPoolConfig(PoolConfig pc) {
        this.logger.trace("setting poolConfig: {}", (Object)pc);
        this.poolConfig = pc;
    }

    public Activator<T> getActivator() {
        return this.activator;
    }

    public void setActivator(Activator<T> a) {
        this.logger.trace("setting activator: {}", a);
        this.activator = a;
    }

    public boolean activate(T t) {
        boolean success = false;
        if (this.activator == null) {
            success = true;
            this.logger.trace("no activator configured");
        } else {
            try {
                success = this.activator.activate(t);
            }
            catch (Exception e) {
                this.logger.warn("activate threw exception", (Throwable)e);
            }
            this.logger.trace("activation for {} = {}", t, (Object)success);
        }
        return success;
    }

    public Passivator<T> getPassivator() {
        return this.passivator;
    }

    public void setPassivator(Passivator<T> p) {
        this.logger.trace("setting passivator: {}", p);
        this.passivator = p;
    }

    public boolean passivate(T t) {
        boolean success = false;
        if (this.passivator == null) {
            success = true;
            this.logger.trace("no passivator configured");
        } else {
            try {
                success = this.passivator.passivate(t);
            }
            catch (Exception e) {
                this.logger.warn("passivate threw exception", (Throwable)e);
            }
            this.logger.trace("passivation for {} = {}", t, (Object)success);
        }
        return success;
    }

    public Validator<T> getValidator() {
        return this.validator;
    }

    public void setValidator(Validator<T> v) {
        this.logger.trace("setting validator: {}", v);
        this.validator = v;
    }

    public boolean validate(T t) {
        boolean success = false;
        if (this.validator == null) {
            success = true;
            this.logger.warn("validate called, but no validator configured");
        } else {
            try {
                success = this.validator.validate(t);
            }
            catch (Exception e) {
                this.logger.warn("validate threw exception", (Throwable)e);
            }
            this.logger.trace("validation for {} = {}", t, (Object)success);
        }
        return success;
    }

    public PruneStrategy getPruneStrategy() {
        return this.pruneStrategy;
    }

    public void setPruneStrategy(PruneStrategy ps) {
        this.logger.trace("setting pruneStrategy: {}", (Object)ps);
        this.pruneStrategy = ps;
    }
}

