/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.ad.io;

import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.ldaptive.io.AbstractStringValueTranscoder;

public class FileTimeValueTranscoder
extends AbstractStringValueTranscoder<Calendar> {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private static final long ERA_OFFSET = 11644473600000L;
    private static final long ONE_HUNDRED_NANOSECOND_INTERVAL = 10000L;

    @Override
    public Calendar decodeStringValue(String value) {
        Calendar calendar = Calendar.getInstance(UTC, DEFAULT_LOCALE);
        calendar.setTimeInMillis(Long.parseLong(value) / 10000L - 11644473600000L);
        return calendar;
    }

    @Override
    public String encodeStringValue(Calendar value) {
        return String.valueOf((value.getTimeInMillis() + 11644473600000L) * 10000L);
    }

    @Override
    public Class<Calendar> getType() {
        return Calendar.class;
    }
}

