/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.provider.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.knox.gateway.ha.provider.HaServiceConfig;
import org.apache.knox.gateway.ha.provider.URLManager;
import org.apache.knox.gateway.ha.provider.impl.i18n.HaMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public class DefaultURLManager
implements URLManager {
    private static final HaMessages LOG = (HaMessages)MessagesFactory.get(HaMessages.class);
    private ConcurrentLinkedQueue<String> urls = new ConcurrentLinkedQueue();

    @Override
    public boolean supportsConfig(HaServiceConfig config) {
        return true;
    }

    @Override
    public void setConfig(HaServiceConfig config) {
    }

    @Override
    public synchronized String getActiveURL() {
        return this.urls.peek();
    }

    @Override
    public synchronized void setActiveURL(String url) {
        String top = this.urls.peek();
        if (top.equalsIgnoreCase(url)) {
            return;
        }
        if (this.urls.contains(url)) {
            this.urls.remove(url);
            List<String> remainingList = this.getURLs();
            this.urls.clear();
            this.urls.add(url);
            this.urls.addAll(remainingList);
        }
    }

    @Override
    public synchronized List<String> getURLs() {
        return new ArrayList<String>(this.urls);
    }

    @Override
    public synchronized void setURLs(List<String> urls) {
        if (urls != null && !urls.isEmpty()) {
            this.urls.clear();
            this.urls.addAll(urls);
        }
    }

    @Override
    public synchronized void markFailed(String url) {
        String top = this.urls.peek();
        if (top != null) {
            String incomingHostPort;
            boolean pushToBottom = false;
            URI topUri = URI.create(top);
            URI incomingUri = URI.create(url);
            String topHostPort = topUri.getHost() + ":" + topUri.getPort();
            if (topHostPort.equals(incomingHostPort = incomingUri.getHost() + ":" + incomingUri.getPort())) {
                pushToBottom = true;
            }
            if (pushToBottom) {
                String failed = this.urls.poll();
                this.urls.offer(failed);
                LOG.markedFailedUrl(failed, this.urls.peek());
            }
        }
    }
}

