/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.admin;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.knox.gateway.services.GatewayServices;
import org.apache.knox.gateway.services.ServerInfoService;
import org.apache.knox.gateway.services.ServiceType;

@Path(value="/api/v1")
public class VersionResource {
    @Context
    private HttpServletRequest request;

    @GET
    @Produces(value={"application/json", "application/xml"})
    @Path(value="version")
    public Response getVersion() {
        ServerVersion version = this.getServerVersion();
        return Response.ok((Object)version).build();
    }

    private ServerVersion getServerVersion() {
        GatewayServices services = (GatewayServices)this.request.getServletContext().getAttribute("org.apache.knox.gateway.gateway.services");
        ServerInfoService sis = (ServerInfoService)services.getService(ServiceType.SERVER_INFO_SERVICE);
        return new ServerVersion(sis.getBuildVersion(), sis.getBuildHash());
    }

    @XmlRootElement(name="ServerVersion")
    public static class ServerVersion {
        @XmlElement(name="version")
        private String version;
        @XmlElement(name="hash")
        private String hash;

        public ServerVersion(String version, String hash) {
            this.version = version;
            this.hash = hash;
        }

        public ServerVersion() {
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }
    }
}

