/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.hbase;

import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class WebHBaseServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "WEBHBASE";
    public static final String SERVICE_TYPE = "HBASE";
    public static final String ROLE_TYPE = "HBASERESTSERVER";
    static final String SSL_ENABLED = "hbase_restserver_ssl_enable";
    static final String REST_SERVER_PORT = "hbase_restserver_port";

    @Override
    public String getService() {
        return SERVICE;
    }

    @Override
    public String getServiceType() {
        return SERVICE_TYPE;
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.API;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig) {
        String hostname = role.getHostRef().getHostname();
        String port = this.getRoleConfigValue(roleConfig, REST_SERVER_PORT);
        boolean sslEnabled = Boolean.parseBoolean(this.getRoleConfigValue(roleConfig, SSL_ENABLED));
        String scheme = sslEnabled ? "https" : "http";
        ServiceModel model = this.createServiceModel(String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port));
        model.addRoleProperty(this.getRoleType(), REST_SERVER_PORT, this.getRoleConfigValue(roleConfig, REST_SERVER_PORT));
        model.addRoleProperty(this.getRoleType(), SSL_ENABLED, this.getRoleConfigValue(roleConfig, SSL_ENABLED));
        return model;
    }
}

