/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.message.AbandonListener;
import org.apache.directory.api.ldap.model.message.AbandonableRequest;
import org.apache.directory.server.core.api.event.DirectoryListener;
import org.apache.directory.server.ldap.LdapServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchAbandonListener
implements AbandonListener {
    private static final Logger LOG = LoggerFactory.getLogger(SearchAbandonListener.class);
    private final LdapServer ldapServer;
    private Cursor<Entry> cursor;
    private DirectoryListener listener;

    public SearchAbandonListener(LdapServer ldapServer, Cursor<Entry> cursor, DirectoryListener listener) {
        if (ldapServer == null) {
            throw new IllegalArgumentException("ldapServer");
        }
        this.ldapServer = ldapServer;
        this.cursor = cursor;
        this.listener = listener;
    }

    public SearchAbandonListener(LdapServer ldapServer, DirectoryListener listener) {
        this(ldapServer, null, listener);
    }

    public SearchAbandonListener(LdapServer ldapServer, Cursor<Entry> cursor) {
        this(ldapServer, cursor, null);
    }

    public void requestAbandoned(AbandonableRequest req) {
        if (this.listener != null) {
            this.ldapServer.getDirectoryService().getEventService().removeListener(this.listener);
        }
    }
}

