/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.extended;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.util.Oid;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.ExtendedRequestDecorator;
import org.apache.directory.api.ldap.model.message.ExtendedRequest;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreExtendedRequestName
extends GrammarAction<LdapMessageContainer<ExtendedRequestDecorator<?>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreExtendedRequestName.class);

    public StoreExtendedRequestName() {
        super("Store ExtendedRequest Name");
    }

    public void action(LdapMessageContainer<ExtendedRequestDecorator<?>> container) throws DecoderException {
        ExtendedRequest req;
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_05122_NULL_NAME, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        byte[] requestNameBytes = tlv.getValue().getData();
        try {
            String requestName = Strings.utf8ToString((byte[])requestNameBytes);
            if (!Oid.isOid((String)requestName)) {
                String msg = I18n.err((I18n)I18n.ERR_05121_INVALID_REQUEST_NAME_OID, (Object[])new Object[]{Strings.utf8ToString((byte[])requestNameBytes), Strings.dumpBytes((byte[])requestNameBytes)});
                LOG.error(msg);
                throw new DecoderException(msg);
            }
            req = LdapApiServiceFactory.getSingleton().newExtendedRequest(requestName, null);
            req.setMessageId(container.getMessageId());
            container.setMessage(LdapApiServiceFactory.getSingleton().decorate(req));
        }
        catch (DecoderException de) {
            String msg = I18n.err((I18n)I18n.ERR_05121_INVALID_REQUEST_NAME_OID, (Object[])new Object[]{Strings.utf8ToString((byte[])requestNameBytes), Strings.dumpBytes((byte[])requestNameBytes)});
            LOG.error(I18n.err((I18n)I18n.ERR_05114_ERROR_MESSAGE, (Object[])new Object[]{msg, de.getMessage()}));
            throw de;
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05126_OID_READ, (Object[])new Object[]{req.getRequestName()}));
        }
    }
}

