/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.scribe.builder.api;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.extractors.OAuth2AccessTokenExtractor;
import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.Verb;

public class CasOAuthWrapperApi20
extends DefaultApi20 {
    private final String casServerUrl;
    private final boolean springSecurityCompliant;

    public CasOAuthWrapperApi20(String casServerUrl, boolean springSecurityCompliant) {
        this.casServerUrl = casServerUrl;
        this.springSecurityCompliant = springSecurityCompliant;
    }

    public TokenExtractor<OAuth2AccessToken> getAccessTokenExtractor() {
        if (this.springSecurityCompliant) {
            return OAuth2AccessTokenJsonExtractor.instance();
        }
        return OAuth2AccessTokenExtractor.instance();
    }

    public String getAccessTokenEndpoint() {
        return this.casServerUrl + "/accessToken?";
    }

    protected String getAuthorizationBaseUrl() {
        return this.casServerUrl + "/authorize";
    }

    public Verb getAccessTokenVerb() {
        if (this.springSecurityCompliant) {
            return Verb.PUT;
        }
        return Verb.POST;
    }

    public String getCasServerUrl() {
        return this.casServerUrl;
    }
}

