/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.topology.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.binder.DigesterLoader;
import org.apache.commons.digester3.binder.RulesModule;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.GatewayServer;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.service.definition.ServiceDefinition;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.config.client.RemoteConfigurationRegistryClient;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.topology.TopologyService;
import org.apache.knox.gateway.topology.ClusterConfigurationMonitorService;
import org.apache.knox.gateway.topology.Topology;
import org.apache.knox.gateway.topology.TopologyEvent;
import org.apache.knox.gateway.topology.TopologyListener;
import org.apache.knox.gateway.topology.TopologyMonitor;
import org.apache.knox.gateway.topology.TopologyProvider;
import org.apache.knox.gateway.topology.builder.TopologyBuilder;
import org.apache.knox.gateway.topology.discovery.ClusterConfigurationMonitor;
import org.apache.knox.gateway.topology.monitor.RemoteConfigurationMonitor;
import org.apache.knox.gateway.topology.monitor.RemoteConfigurationMonitorFactory;
import org.apache.knox.gateway.topology.simple.ProviderConfigurationParser;
import org.apache.knox.gateway.topology.simple.SimpleDescriptor;
import org.apache.knox.gateway.topology.simple.SimpleDescriptorFactory;
import org.apache.knox.gateway.topology.simple.SimpleDescriptorHandler;
import org.apache.knox.gateway.topology.validation.TopologyValidator;
import org.apache.knox.gateway.topology.xml.AmbariFormatXmlTopologyRules;
import org.apache.knox.gateway.topology.xml.KnoxFormatXmlTopologyRules;
import org.apache.knox.gateway.util.ServiceDefinitionsLoader;
import org.xml.sax.SAXException;

public class DefaultTopologyService
extends FileAlterationListenerAdaptor
implements TopologyService,
TopologyMonitor,
TopologyProvider,
FileFilter,
FileAlterationListener {
    private static final JAXBContext jaxbContext = DefaultTopologyService.getJAXBContext();
    private static Auditor auditor = AuditServiceFactory.getAuditService().getAuditor("audit", "knox", "knox");
    private static final List<String> SUPPORTED_TOPOLOGY_FILE_EXTENSIONS = new ArrayList<String>();
    private static GatewayMessages log;
    private static DigesterLoader digesterLoader;
    private List<FileAlterationMonitor> monitors = new ArrayList<FileAlterationMonitor>();
    private File topologiesDirectory;
    private File sharedProvidersDirectory;
    private File descriptorsDirectory;
    private DescriptorsMonitor descriptorsMonitor;
    private Set<TopologyListener> listeners;
    private Map<File, Topology> topologies;
    private AliasService aliasService;
    private RemoteConfigurationMonitor remoteMonitor;
    private GatewayConfig config;

    private static JAXBContext getJAXBContext() {
        String pkgName = Topology.class.getPackage().getName();
        String bindingFile = pkgName.replace(".", "/") + "/topology_binding-xml.xml";
        HashMap<String, String> properties = new HashMap<String, String>(1);
        properties.put("eclipselink.oxm.metadata-source", bindingFile);
        try {
            return JAXBContext.newInstance((String)pkgName, (ClassLoader)Topology.class.getClassLoader(), properties);
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    private Topology loadTopology(File file) throws IOException, SAXException, URISyntaxException, InterruptedException {
        Topology topology;
        long TIMEOUT = 250L;
        long DELAY = 50L;
        log.loadingTopologyFile(file.getAbsolutePath());
        long start = System.currentTimeMillis();
        while (true) {
            try {
                topology = this.loadTopologyAttempt(file);
            }
            catch (IOException | SAXException e) {
                if (System.currentTimeMillis() - start < 250L) {
                    log.failedToLoadTopologyRetrying(file.getAbsolutePath(), Long.toString(50L), e);
                    Thread.sleep(50L);
                    continue;
                }
                throw e;
            }
            break;
        }
        return topology;
    }

    private Topology loadTopologyAttempt(File file) throws IOException, SAXException, URISyntaxException {
        Digester digester = digesterLoader.newDigester();
        TopologyBuilder topologyBuilder = (TopologyBuilder)digester.parse((InputStream)FileUtils.openInputStream((File)file));
        if (null == topologyBuilder) {
            return null;
        }
        Topology topology = topologyBuilder.build();
        topology.setUri(file.toURI());
        topology.setName(FilenameUtils.removeExtension((String)file.getName()));
        topology.setTimestamp(file.lastModified());
        return topology;
    }

    private void redeployTopology(Topology topology) {
        File topologyFile = new File(topology.getUri());
        try {
            TopologyValidator tv = new TopologyValidator(topology);
            if (!tv.validateTopology()) {
                if (this.config != null && this.config.isTopologyValidationEnabled()) {
                    throw new SAXException(tv.getErrorString());
                }
                log.failedToValidateTopology(topology.getName(), tv.getErrorString());
            }
            long start = System.currentTimeMillis();
            long limit = 1000L;
            long elapsed = 1L;
            while (elapsed <= limit) {
                try {
                    long origTimestamp = topologyFile.lastModified();
                    long setTimestamp = Math.max(System.currentTimeMillis(), topologyFile.lastModified() + elapsed);
                    if (topologyFile.setLastModified(setTimestamp)) {
                        long newTimstamp = topologyFile.lastModified();
                        if (newTimstamp <= origTimestamp) {
                            Thread.sleep(10L);
                            elapsed = System.currentTimeMillis() - start;
                            continue;
                        }
                    } else {
                        auditor.audit("redeploy", topology.getName(), "topology", "failure");
                        log.failedToRedeployTopology(topology.getName());
                    }
                    break;
                }
                catch (InterruptedException e) {
                    auditor.audit("redeploy", topology.getName(), "topology", "failure");
                    log.failedToRedeployTopology(topology.getName(), e);
                    e.printStackTrace();
                }
            }
        }
        catch (SAXException e) {
            auditor.audit("redeploy", topology.getName(), "topology", "failure");
            log.failedToRedeployTopology(topology.getName(), e);
        }
    }

    private List<TopologyEvent> createChangeEvents(Map<File, Topology> oldTopologies, Map<File, Topology> newTopologies) {
        ArrayList<TopologyEvent> events = new ArrayList<TopologyEvent>();
        for (Map.Entry<File, Topology> oldTopology : oldTopologies.entrySet()) {
            if (newTopologies.containsKey(oldTopology.getKey())) continue;
            events.add(new TopologyEvent(TopologyEvent.Type.DELETED, oldTopology.getValue()));
        }
        for (Map.Entry<File, Topology> newTopology : newTopologies.entrySet()) {
            if (oldTopologies.containsKey(newTopology.getKey())) {
                Topology oldTopology = oldTopologies.get(newTopology.getKey());
                if (newTopology.getValue().getTimestamp() <= oldTopology.getTimestamp()) continue;
                events.add(new TopologyEvent(TopologyEvent.Type.UPDATED, newTopology.getValue()));
                continue;
            }
            events.add(new TopologyEvent(TopologyEvent.Type.CREATED, newTopology.getValue()));
        }
        return events;
    }

    private File calculateAbsoluteTopologiesDir(GatewayConfig config) {
        File topoDir = new File(config.getGatewayTopologyDir());
        topoDir = topoDir.getAbsoluteFile();
        return topoDir;
    }

    private File calculateAbsoluteConfigDir(GatewayConfig config) {
        String path = config.getGatewayConfDir();
        File configDir = path != null ? new File(path) : new File(config.getGatewayTopologyDir()).getParentFile();
        return configDir.getAbsoluteFile();
    }

    private void initListener(FileAlterationMonitor monitor, File directory, FileFilter filter, FileAlterationListener listener) {
        this.monitors.add(monitor);
        FileAlterationObserver observer = new FileAlterationObserver(directory, filter);
        observer.addListener(listener);
        monitor.addObserver(observer);
    }

    private void initListener(File directory, FileFilter filter, FileAlterationListener listener) throws IOException, SAXException {
        this.initListener(new FileAlterationMonitor(5000L), directory, filter, listener);
    }

    private Map<File, Topology> loadTopologies(File directory) {
        File[] existingTopologies;
        HashMap<File, Topology> map = new HashMap<File, Topology>();
        if (directory.isDirectory() && directory.canRead() && (existingTopologies = directory.listFiles(this)) != null) {
            for (File file : existingTopologies) {
                try {
                    Topology loadTopology = this.loadTopology(file);
                    if (null != loadTopology) {
                        map.put(file, loadTopology);
                        continue;
                    }
                    auditor.audit("load", file.getAbsolutePath(), "topology", "failure");
                    log.failedToLoadTopology(file.getAbsolutePath());
                }
                catch (Exception e) {
                    auditor.audit("load", file.getAbsolutePath(), "topology", "failure");
                    log.failedToLoadTopology(file.getAbsolutePath(), e);
                }
            }
        }
        return map;
    }

    public void setAliasService(AliasService as) {
        this.aliasService = as;
    }

    public void deployTopology(Topology t) {
        try {
            File temp = new File(this.topologiesDirectory.getAbsolutePath() + "/" + t.getName() + ".xml.temp");
            Marshaller mr = jaxbContext.createMarshaller();
            mr.setProperty("jaxb.formatted.output", (Object)true);
            mr.marshal((Object)t, temp);
            File topology = new File(this.topologiesDirectory.getAbsolutePath() + "/" + t.getName() + ".xml");
            if (!temp.renameTo(topology)) {
                FileUtils.forceDelete((File)temp);
                throw new IOException("Could not rename temp file");
            }
            TopologyValidator validator = new TopologyValidator(topology.getAbsolutePath());
            if (!validator.validateTopology()) {
                throw new SAXException(validator.getErrorString());
            }
        }
        catch (IOException | JAXBException | SAXException e) {
            auditor.audit("deploy", t.getName(), "topology", "failure");
            log.failedToDeployTopology(t.getName(), e);
        }
        this.reloadTopologies();
    }

    public void redeployTopologies(String topologyName) {
        for (Topology topology : this.getTopologies()) {
            if (topologyName != null && !topologyName.equals(topology.getName())) continue;
            this.redeployTopology(topology);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadTopologies() {
        try {
            DefaultTopologyService defaultTopologyService = this;
            synchronized (defaultTopologyService) {
                Map<File, Topology> oldTopologies = this.topologies;
                Map<File, Topology> newTopologies = this.loadTopologies(this.topologiesDirectory);
                List<TopologyEvent> events = this.createChangeEvents(oldTopologies, newTopologies);
                this.topologies = newTopologies;
                this.notifyChangeListeners(events);
            }
        }
        catch (Exception e) {
            log.failedToReloadTopologies(e);
        }
    }

    public void deleteTopology(Topology t) {
        File topoDir = this.topologiesDirectory;
        if (topoDir.isDirectory() && topoDir.canRead()) {
            for (File f : DefaultTopologyService.listFiles(topoDir)) {
                String fName = FilenameUtils.getBaseName((String)f.getName());
                if (!fName.equals(t.getName())) continue;
                f.delete();
            }
        }
        this.reloadTopologies();
    }

    private void notifyChangeListeners(List<TopologyEvent> events) {
        for (TopologyListener listener : this.listeners) {
            try {
                listener.handleTopologyEvent(events);
            }
            catch (RuntimeException e) {
                auditor.audit("load", "Topology_Event", "topology", "failure");
                log.failedToHandleTopologyEvents(e);
            }
        }
    }

    public Map<String, List<String>> getServiceTestURLs(Topology t, GatewayConfig config) {
        File tFile = null;
        HashMap<String, List<String>> urls = new HashMap<String, List<String>>();
        if (this.topologiesDirectory.isDirectory() && this.topologiesDirectory.canRead()) {
            for (File f : DefaultTopologyService.listFiles(this.topologiesDirectory)) {
                if (!FilenameUtils.removeExtension((String)f.getName()).equals(t.getName())) continue;
                tFile = f;
            }
        }
        if (tFile != null) {
            Set<ServiceDefinition> defs = ServiceDefinitionsLoader.getServiceDefinitions(new File(config.getGatewayServicesDir()));
            for (ServiceDefinition def : defs) {
                urls.put(def.getRole(), def.getTestURLs());
            }
        }
        return urls;
    }

    public Collection<Topology> getTopologies() {
        Map<File, Topology> map = this.topologies;
        return Collections.unmodifiableCollection(map.values());
    }

    public boolean deployProviderConfiguration(String name, String content) {
        RemoteConfigurationRegistryClient client;
        boolean result = DefaultTopologyService.writeConfig(this.sharedProvidersDirectory, name, content);
        if (this.remoteMonitor != null && (client = this.remoteMonitor.getClient()) != null) {
            String entryPath = "/knox/config/shared-providers/" + name;
            client.createEntry(entryPath, content);
            result = client.getEntryData(entryPath) != null;
        }
        return result;
    }

    public Collection<File> getProviderConfigurations() {
        ArrayList<File> providerConfigs = new ArrayList<File>();
        for (File providerConfig : DefaultTopologyService.listFiles(this.sharedProvidersDirectory)) {
            if (!SharedProviderConfigMonitor.SUPPORTED_EXTENSIONS.contains(FilenameUtils.getExtension((String)providerConfig.getName()))) continue;
            providerConfigs.add(providerConfig);
        }
        return providerConfigs;
    }

    public boolean deleteProviderConfiguration(String name) {
        return this.deleteProviderConfiguration(name, false);
    }

    public boolean deleteProviderConfiguration(String name, boolean force) {
        boolean result = false;
        boolean hasReferences = false;
        File providerConfig = DefaultTopologyService.getExistingFile(this.sharedProvidersDirectory, name);
        if (providerConfig != null) {
            List<String> references = this.descriptorsMonitor.getReferencingDescriptors(providerConfig.getAbsolutePath());
            hasReferences = !references.isEmpty();
        } else {
            result = true;
        }
        if (force || providerConfig == null || !hasReferences) {
            this.deleteRemoteEntry("/knox/config/shared-providers", name);
            result = providerConfig == null || !providerConfig.exists() || providerConfig.delete();
        } else {
            log.preventedDeletionOfSharedProviderConfiguration(providerConfig.getAbsolutePath());
        }
        return result;
    }

    public boolean deployDescriptor(String name, String content) {
        RemoteConfigurationRegistryClient client;
        boolean result = DefaultTopologyService.writeConfig(this.descriptorsDirectory, name, content);
        if (this.remoteMonitor != null && (client = this.remoteMonitor.getClient()) != null) {
            String entryPath = "/knox/config/descriptors/" + name;
            client.createEntry(entryPath, content);
            result = client.getEntryData(entryPath) != null;
        }
        return result;
    }

    public Collection<File> getDescriptors() {
        ArrayList<File> descriptors = new ArrayList<File>();
        for (File descriptor : DefaultTopologyService.listFiles(this.descriptorsDirectory)) {
            if (!DescriptorsMonitor.SUPPORTED_EXTENSIONS.contains(FilenameUtils.getExtension((String)descriptor.getName()))) continue;
            descriptors.add(descriptor);
        }
        return descriptors;
    }

    public boolean deleteDescriptor(String name) {
        this.deleteRemoteEntry("/knox/config/descriptors", name);
        File descriptor = DefaultTopologyService.getExistingFile(this.descriptorsDirectory, name);
        boolean result = descriptor == null || descriptor.delete();
        return result;
    }

    public void addTopologyChangeListener(TopologyListener listener) {
        this.listeners.add(listener);
    }

    public void startMonitor() throws Exception {
        for (FileAlterationMonitor monitor : this.monitors) {
            monitor.start();
        }
        if (this.remoteMonitor != null) {
            try {
                this.remoteMonitor.start();
            }
            catch (Exception e) {
                log.remoteConfigurationMonitorStartFailure(this.remoteMonitor.getClass().getTypeName(), e.getLocalizedMessage());
            }
        }
    }

    public void stopMonitor() throws Exception {
        for (FileAlterationMonitor monitor : this.monitors) {
            monitor.stop();
        }
        if (this.remoteMonitor != null) {
            this.remoteMonitor.stop();
        }
    }

    @Override
    public boolean accept(File file) {
        String extension;
        boolean accept = false;
        if (!file.isDirectory() && file.canRead() && SUPPORTED_TOPOLOGY_FILE_EXTENSIONS.contains(extension = FilenameUtils.getExtension((String)file.getName()))) {
            accept = true;
        }
        return accept;
    }

    public void onFileCreate(File file) {
        this.onFileChange(file);
    }

    public void onFileDelete(File file) {
        this.onFileChange(file);
    }

    public void onFileChange(File file) {
        this.reloadTopologies();
    }

    public void stop() {
    }

    public void start() {
        ClusterConfigurationMonitorService ccms = (ClusterConfigurationMonitorService)GatewayServer.getGatewayServices().getService(ServiceType.CLUSTER_CONFIGURATION_MONITOR_SERVICE);
        ccms.addListener((ClusterConfigurationMonitor.ConfigurationChangeListener)new TopologyDiscoveryTrigger(this, ccms));
    }

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        this.config = config;
        String gatewayConfDir = config.getGatewayConfDir();
        if (gatewayConfDir != null) {
            System.setProperty("org.apache.knox.gateway.conf.dir", gatewayConfDir);
        }
        try {
            this.listeners = new HashSet<TopologyListener>();
            this.topologies = new HashMap<File, Topology>();
            this.topologiesDirectory = this.calculateAbsoluteTopologiesDir(config);
            File configDirectory = this.calculateAbsoluteConfigDir(config);
            this.descriptorsDirectory = new File(configDirectory, "descriptors");
            this.sharedProvidersDirectory = new File(configDirectory, "shared-providers");
            this.initListener(this.topologiesDirectory, this, this);
            this.descriptorsMonitor = new DescriptorsMonitor(config, this.topologiesDirectory, this.aliasService);
            this.initListener(this.descriptorsDirectory, this.descriptorsMonitor, (FileAlterationListener)this.descriptorsMonitor);
            log.monitoringDescriptorChangesInDirectory(this.descriptorsDirectory.getAbsolutePath());
            SharedProviderConfigMonitor spm = new SharedProviderConfigMonitor(this.descriptorsMonitor, this.descriptorsDirectory);
            this.initListener(this.sharedProvidersDirectory, spm, (FileAlterationListener)spm);
            log.monitoringProviderConfigChangesInDirectory(this.sharedProvidersDirectory.getAbsolutePath());
            String[] descriptorFilenames = this.descriptorsDirectory.list();
            if (descriptorFilenames != null) {
                for (String descriptorFilename : descriptorFilenames) {
                    List<String> references;
                    File referencedProviderConfig;
                    if (!DescriptorsMonitor.isDescriptorFile(descriptorFilename)) continue;
                    String topologyName = FilenameUtils.getBaseName((String)descriptorFilename);
                    File existingDescriptorFile = DefaultTopologyService.getExistingFile(this.descriptorsDirectory, topologyName);
                    File matchingTopologyFile = DefaultTopologyService.getExistingFile(this.topologiesDirectory, topologyName);
                    if (matchingTopologyFile == null || matchingTopologyFile.lastModified() < existingDescriptorFile.lastModified()) {
                        this.descriptorsMonitor.onFileChange(existingDescriptorFile);
                        continue;
                    }
                    String normalizedDescriptorPath = FilenameUtils.normalize((String)existingDescriptorFile.getAbsolutePath());
                    SimpleDescriptor sd = SimpleDescriptorFactory.parse(normalizedDescriptorPath);
                    if (sd == null || (referencedProviderConfig = DefaultTopologyService.getExistingFile(this.sharedProvidersDirectory, FilenameUtils.getBaseName((String)sd.getProviderConfig()))) == null || (references = this.descriptorsMonitor.getReferencingDescriptors(referencedProviderConfig.getAbsolutePath())).contains(normalizedDescriptorPath)) continue;
                    references.add(normalizedDescriptorPath);
                }
            }
            this.remoteMonitor = RemoteConfigurationMonitorFactory.get(config);
        }
        catch (IOException | SAXException io) {
            throw new ServiceLifecycleException(io.getMessage());
        }
    }

    private boolean deleteRemoteEntry(String entryParent, String name) {
        RemoteConfigurationRegistryClient client;
        boolean result = true;
        if (this.remoteMonitor != null && (client = this.remoteMonitor.getClient()) != null) {
            List existingProviderConfigs = client.listChildEntries(entryParent);
            for (String entryName : existingProviderConfigs) {
                if (!FilenameUtils.getBaseName((String)entryName).equals(name)) continue;
                String entryPath = entryParent + "/" + entryName;
                client.deleteEntry(entryPath);
                boolean bl = result = !client.entryExists(entryPath);
                if (result) break;
                log.failedToDeletedRemoteConfigFile("descriptor", name);
                break;
            }
        }
        return result;
    }

    private static List<File> listFiles(File directory) {
        File[] files = directory.listFiles();
        List<File> result = files != null ? Arrays.asList(files) : Collections.emptyList();
        return result;
    }

    private static File getExistingFile(File directory, String basename) {
        File match = null;
        for (File file : DefaultTopologyService.listFiles(directory)) {
            if (!FilenameUtils.getBaseName((String)file.getName()).equals(basename)) continue;
            match = file;
            break;
        }
        return match;
    }

    private static boolean writeConfig(File dest, String name, String content) {
        boolean result = false;
        File destFile = new File(dest, name);
        try {
            FileUtils.writeStringToFile((File)destFile, (String)content, (Charset)StandardCharsets.UTF_8);
            log.wroteConfigurationFile(destFile.getAbsolutePath());
            result = true;
        }
        catch (IOException e) {
            log.failedToWriteConfigurationFile(destFile.getAbsolutePath(), e);
        }
        return result;
    }

    static {
        SUPPORTED_TOPOLOGY_FILE_EXTENSIONS.add("xml");
        SUPPORTED_TOPOLOGY_FILE_EXTENSIONS.add("conf");
        log = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
        digesterLoader = DigesterLoader.newLoader((RulesModule[])new RulesModule[]{new KnoxFormatXmlTopologyRules(), new AmbariFormatXmlTopologyRules()});
    }

    private static class TopologyDiscoveryTrigger
    implements ClusterConfigurationMonitor.ConfigurationChangeListener {
        private TopologyService topologyService;
        private ClusterConfigurationMonitorService ccms;

        TopologyDiscoveryTrigger(TopologyService topologyService, ClusterConfigurationMonitorService ccms) {
            this.topologyService = topologyService;
            this.ccms = ccms;
        }

        public void onConfigurationChange(String source, String clusterName) {
            log.noticedClusterConfigurationChange(source, clusterName);
            try {
                boolean affectedDescriptors = false;
                for (File descriptor : this.topologyService.getDescriptors()) {
                    String descriptorContent = FileUtils.readFileToString((File)descriptor, (Charset)StandardCharsets.UTF_8);
                    if (!descriptorContent.contains(source) || !descriptorContent.contains(clusterName)) continue;
                    affectedDescriptors = true;
                    log.triggeringTopologyRegeneration(source, clusterName, descriptor.getAbsolutePath());
                    descriptor.setLastModified(System.currentTimeMillis());
                }
                if (!affectedDescriptors) {
                    this.ccms.clearCache(source, clusterName);
                }
            }
            catch (Exception e) {
                log.errorRespondingToConfigChange(source, clusterName, e);
            }
        }
    }

    public static class SharedProviderConfigMonitor
    extends FileAlterationListenerAdaptor
    implements FileFilter {
        static final List<String> SUPPORTED_EXTENSIONS = ProviderConfigurationParser.SUPPORTED_EXTENSIONS;
        private DescriptorsMonitor descriptorsMonitor;
        private File descriptorsDir;

        SharedProviderConfigMonitor(DescriptorsMonitor descMonitor, File descriptorsDir) {
            this.descriptorsMonitor = descMonitor;
            this.descriptorsDir = descriptorsDir;
        }

        public void onFileCreate(File file) {
            this.onFileChange(file);
        }

        public void onFileDelete(File file) {
            this.onFileChange(file);
        }

        public void onFileChange(File file) {
            for (File descriptor : this.getReferencingDescriptors(file)) {
                descriptor.setLastModified(System.currentTimeMillis());
            }
        }

        private List<File> getReferencingDescriptors(File sharedProviderConfig) {
            ArrayList<File> references = new ArrayList<File>();
            for (File descriptor : DefaultTopologyService.listFiles(this.descriptorsDir)) {
                if (!DescriptorsMonitor.SUPPORTED_EXTENSIONS.contains(FilenameUtils.getExtension((String)descriptor.getName()))) continue;
                for (String reference : this.descriptorsMonitor.getReferencingDescriptors(FilenameUtils.normalize((String)sharedProviderConfig.getAbsolutePath()))) {
                    references.add(new File(reference));
                }
            }
            return references;
        }

        @Override
        public boolean accept(File file) {
            String extension;
            boolean accept = false;
            if (!file.isDirectory() && file.canRead() && SUPPORTED_EXTENSIONS.contains(extension = FilenameUtils.getExtension((String)file.getName()))) {
                accept = true;
            }
            return accept;
        }
    }

    public static class DescriptorsMonitor
    extends FileAlterationListenerAdaptor
    implements FileFilter {
        static final List<String> SUPPORTED_EXTENSIONS = new ArrayList<String>();
        private GatewayConfig gatewayConfig;
        private File topologiesDir;
        private AliasService aliasService;
        private Map<String, List<String>> providerConfigReferences = new HashMap<String, List<String>>();

        static boolean isDescriptorFile(String filename) {
            return SUPPORTED_EXTENSIONS.contains(FilenameUtils.getExtension((String)filename));
        }

        public DescriptorsMonitor(GatewayConfig config, File topologiesDir, AliasService aliasService) {
            this.gatewayConfig = config;
            this.topologiesDir = topologiesDir;
            this.aliasService = aliasService;
        }

        List<String> getReferencingDescriptors(String providerConfigPath) {
            String normalizedPath = FilenameUtils.normalize((String)providerConfigPath);
            return this.providerConfigReferences.computeIfAbsent(normalizedPath, p -> new ArrayList());
        }

        public void onFileCreate(File file) {
            this.onFileChange(file);
        }

        public void onFileDelete(File file) {
            for (String ext : SUPPORTED_TOPOLOGY_FILE_EXTENSIONS) {
                File topologyFile = new File(this.topologiesDir, FilenameUtils.getBaseName((String)file.getName()) + "." + ext);
                if (!topologyFile.exists()) continue;
                log.deletingTopologyForDescriptorDeletion(topologyFile.getName(), file.getName());
                topologyFile.delete();
            }
            String normalizedFilePath = FilenameUtils.normalize((String)file.getAbsolutePath());
            String reference = null;
            for (Map.Entry<String, List<String>> entry : this.providerConfigReferences.entrySet()) {
                if (!entry.getValue().contains(normalizedFilePath)) continue;
                reference = entry.getKey();
                break;
            }
            if (reference != null) {
                this.providerConfigReferences.get(reference).remove(normalizedFilePath);
                log.removedProviderConfigurationReference(normalizedFilePath, reference);
            }
        }

        public void onFileChange(File file) {
            try {
                String descriptorName;
                List<String> refs;
                Map<String, File> result = SimpleDescriptorHandler.handle(this.gatewayConfig, file, this.topologiesDir, new Service[]{this.aliasService});
                log.generatedTopologyForDescriptorChange(result.get("topology").getName(), file.getName());
                String providerConfig = FilenameUtils.normalize((String)result.get("reference").getAbsolutePath());
                if (!this.providerConfigReferences.containsKey(providerConfig)) {
                    this.providerConfigReferences.put(providerConfig, new ArrayList());
                }
                if (!(refs = this.providerConfigReferences.get(providerConfig)).contains(descriptorName = FilenameUtils.normalize((String)file.getAbsolutePath()))) {
                    for (List<String> descs : this.providerConfigReferences.values()) {
                        descs.remove(descriptorName);
                    }
                    refs.add(descriptorName);
                    log.addedProviderConfigurationReference(descriptorName, providerConfig);
                }
            }
            catch (IllegalArgumentException e) {
                log.simpleDescriptorHandlingError(file.getName(), e);
                String descriptorName = FilenameUtils.normalize((String)file.getAbsolutePath());
                for (List<String> descs : this.providerConfigReferences.values()) {
                    descs.remove(descriptorName);
                }
            }
            catch (Exception e) {
                log.simpleDescriptorHandlingError(file.getName(), e);
            }
        }

        @Override
        public boolean accept(File file) {
            String extension;
            boolean accept = false;
            if (!file.isDirectory() && file.canRead() && SUPPORTED_EXTENSIONS.contains(extension = FilenameUtils.getExtension((String)file.getName()))) {
                accept = true;
            }
            return accept;
        }

        static {
            SUPPORTED_EXTENSIONS.add("json");
            SUPPORTED_EXTENSIONS.add("yml");
            SUPPORTED_EXTENSIONS.add("yaml");
        }
    }
}

