/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.security.impl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.services.security.KeystoreService;
import org.apache.knox.gateway.services.security.KeystoreServiceException;
import org.apache.knox.gateway.services.security.MasterService;
import org.apache.knox.gateway.util.PasswordUtils;

public class DefaultAliasService
implements AliasService {
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private KeystoreService keystoreService;
    private MasterService masterService;
    private GatewayConfig config;

    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        this.config = config;
    }

    public void start() throws ServiceLifecycleException {
    }

    public void stop() throws ServiceLifecycleException {
    }

    public char[] getGatewayIdentityPassphrase() throws AliasServiceException {
        char[] passphrase = this.getPasswordFromAliasForGateway(this.config.getIdentityKeyPassphraseAlias());
        if (passphrase == null) {
            passphrase = this.getGatewayIdentityKeystorePassword();
        }
        if (passphrase == null) {
            passphrase = this.masterService.getMasterSecret();
        }
        return passphrase;
    }

    public char[] getGatewayIdentityKeystorePassword() throws AliasServiceException {
        char[] passphrase = this.getPasswordFromAliasForGateway(this.config.getIdentityKeystorePasswordAlias());
        if (passphrase == null) {
            passphrase = this.masterService.getMasterSecret();
        }
        return passphrase;
    }

    public char[] getSigningKeyPassphrase() throws AliasServiceException {
        char[] passphrase = this.getPasswordFromAliasForGateway(this.config.getSigningKeyPassphraseAlias());
        if (passphrase == null) {
            passphrase = this.getSigningKeystorePassword();
        }
        if (passphrase == null) {
            passphrase = this.masterService.getMasterSecret();
        }
        return passphrase;
    }

    public char[] getSigningKeystorePassword() throws AliasServiceException {
        char[] passphrase = this.getPasswordFromAliasForGateway(this.config.getSigningKeystorePasswordAlias());
        if (passphrase == null) {
            passphrase = this.masterService.getMasterSecret();
        }
        return passphrase;
    }

    public char[] getPasswordFromAliasForCluster(String clusterName, String alias) throws AliasServiceException {
        return this.getPasswordFromAliasForCluster(clusterName, alias, false);
    }

    public char[] getPasswordFromAliasForCluster(String clusterName, String alias, boolean generate) throws AliasServiceException {
        char[] credential;
        try {
            credential = this.keystoreService.getCredentialForCluster(clusterName, alias);
            if (credential == null && generate) {
                this.generateAliasForCluster(clusterName, alias);
                credential = this.keystoreService.getCredentialForCluster(clusterName, alias);
            }
        }
        catch (KeystoreServiceException e) {
            LOG.failedToGetCredentialForCluster(clusterName, (Exception)((Object)e));
            throw new AliasServiceException((Exception)((Object)e));
        }
        return credential;
    }

    public void setKeystoreService(KeystoreService ks) {
        this.keystoreService = ks;
    }

    public void setMasterService(MasterService ms) {
        this.masterService = ms;
    }

    public void generateAliasForCluster(String clusterName, String alias) throws AliasServiceException {
        try {
            this.keystoreService.getCredentialStoreForCluster(clusterName);
        }
        catch (KeystoreServiceException e) {
            LOG.failedToGenerateAliasForCluster(clusterName, e);
            throw new AliasServiceException((Exception)((Object)e));
        }
        String passwordString = PasswordUtils.generatePassword((int)16);
        this.addAliasForCluster(clusterName, alias, passwordString);
    }

    public void addAliasForCluster(String clusterName, String alias, String value) {
        try {
            this.keystoreService.addCredentialForCluster(clusterName, alias, value);
        }
        catch (KeystoreServiceException e) {
            LOG.failedToAddCredentialForCluster(clusterName, (Exception)((Object)e));
        }
    }

    public void removeAliasForCluster(String clusterName, String alias) throws AliasServiceException {
        try {
            this.keystoreService.removeCredentialForCluster(clusterName, alias);
        }
        catch (KeystoreServiceException e) {
            throw new AliasServiceException((Exception)((Object)e));
        }
    }

    public char[] getPasswordFromAliasForGateway(String alias) throws AliasServiceException {
        return this.getPasswordFromAliasForCluster("__gateway", alias);
    }

    public void generateAliasForGateway(String alias) throws AliasServiceException {
        this.generateAliasForCluster("__gateway", alias);
    }

    public Certificate getCertificateForGateway(String alias) {
        Certificate cert = null;
        try {
            cert = this.keystoreService.getKeystoreForGateway().getCertificate(alias);
        }
        catch (KeyStoreException | KeystoreServiceException e) {
            LOG.unableToRetrieveCertificateForGateway((Exception)e);
        }
        return cert;
    }

    public List<String> getAliasesForCluster(String clusterName) {
        ArrayList<String> list;
        block5: {
            list = new ArrayList<String>();
            try {
                KeyStore keyStore = this.keystoreService.getCredentialStoreForCluster(clusterName);
                if (keyStore == null) break block5;
                try {
                    Enumeration<String> e = keyStore.aliases();
                    while (e.hasMoreElements()) {
                        String alias = e.nextElement();
                        if (alias.contains("@")) continue;
                        list.add(alias);
                    }
                }
                catch (KeyStoreException e) {
                    LOG.failedToGetCredentialForCluster(clusterName, e);
                }
            }
            catch (KeystoreServiceException kse) {
                LOG.failedToGetCredentialForCluster(clusterName, (Exception)((Object)kse));
            }
        }
        return list;
    }
}

