/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public class ServletDispatch
implements Filter {
    private static final String DISPATCH_SERVLET_PARAM_NAME = "dispatchServletName";
    private ServletContext servletContext;
    private String servletName;

    public void init(FilterConfig config) throws ServletException {
        this.servletContext = config.getServletContext();
        this.servletName = config.getInitParameter(DISPATCH_SERVLET_PARAM_NAME);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.servletContext.getNamedDispatcher(this.servletName).forward(request, response);
    }

    public void destroy() {
        this.servletContext = null;
        this.servletName = null;
    }
}

