/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.svcregfunc.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriter;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteFunctionProcessor;
import org.apache.knox.gateway.services.hostmap.HostMapper;
import org.apache.knox.gateway.services.hostmap.HostMapperService;
import org.apache.knox.gateway.svcregfunc.api.ServiceMappedAddressFunctionDescriptor;
import org.apache.knox.gateway.svcregfunc.impl.ServiceRegistryFunctionProcessorBase;
import org.apache.knox.gateway.util.urltemplate.Host;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Port;
import org.apache.knox.gateway.util.urltemplate.Template;

public class ServiceMappedAddressFunctionProcessor
extends ServiceRegistryFunctionProcessorBase<ServiceMappedAddressFunctionDescriptor>
implements UrlRewriteFunctionProcessor<ServiceMappedAddressFunctionDescriptor> {
    private HostMapper hostmap = null;

    public String name() {
        return "serviceMappedAddr";
    }

    @Override
    public void initialize(UrlRewriteEnvironment environment, ServiceMappedAddressFunctionDescriptor descriptor) throws Exception {
        super.initialize(environment, descriptor);
        HostMapperService hostmapService = (HostMapperService)this.services().getService("HostMappingService");
        if (hostmapService != null) {
            this.hostmap = hostmapService.getHostMapper(this.cluster());
        }
    }

    public List<String> resolve(UrlRewriteContext context, List<String> parameters) throws Exception {
        ArrayList<String> results = null;
        if (parameters != null) {
            UrlRewriter.Direction direction = context.getDirection();
            results = new ArrayList<String>(parameters.size());
            for (String parameter : parameters) {
                parameter = this.resolve(direction, parameter);
                results.add(parameter);
            }
        }
        return results;
    }

    public String resolve(UrlRewriter.Direction direction, String parameter) throws Exception {
        String addr = parameter;
        String url = this.lookupServiceUrl(parameter);
        if (url != null) {
            Template template = Parser.parseLiteral((String)url);
            Host host = template.getHost();
            String hostStr = null;
            if (host != null) {
                hostStr = host.getFirstValue().getPattern();
                if (this.hostmap != null) {
                    switch (direction) {
                        case IN: {
                            hostStr = this.hostmap.resolveInboundHostName(hostStr);
                            break;
                        }
                        case OUT: {
                            hostStr = this.hostmap.resolveOutboundHostName(hostStr);
                        }
                    }
                }
            }
            Port port = template.getPort();
            String portStr = null;
            if (port != null) {
                portStr = port.getFirstValue().getPattern();
            }
            if (hostStr != null && portStr != null) {
                addr = hostStr + ":" + portStr;
            } else if (host != null && port == null) {
                addr = hostStr;
            } else if (host == null && port != null) {
                addr = ":" + portStr;
            }
        }
        return addr;
    }
}

