/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.id;

import com.nimbusds.oauth2.sdk.id.Subject;
import com.nimbusds.openid.connect.sdk.id.InvalidPairwiseSubjectException;
import com.nimbusds.openid.connect.sdk.id.SectorID;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.Provider;
import net.jcip.annotations.ThreadSafe;
import org.apache.commons.lang3.tuple.Pair;

@ThreadSafe
public abstract class PairwiseSubjectCodec {
    public static final Charset CHARSET = Charset.forName("UTF-8");
    private final byte[] salt;
    private Provider provider;

    public PairwiseSubjectCodec(byte[] salt) {
        this.salt = salt;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    public Subject encode(URI sectorURI, Subject localSub) {
        return this.encode(new SectorID(sectorURI), localSub);
    }

    public abstract Subject encode(SectorID var1, Subject var2);

    public Pair<SectorID, Subject> decode(Subject pairwiseSubject) throws InvalidPairwiseSubjectException {
        throw new UnsupportedOperationException("Pairwise subject decoding is not supported");
    }
}

