/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.shell.job;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.knox.gateway.shell.AbstractRequest;
import org.apache.knox.gateway.shell.BasicResponse;
import org.apache.knox.gateway.shell.KnoxSession;

class Java {
    Java() {
    }

    public static class Response
    extends BasicResponse {
        public Response(HttpResponse response) {
            super(response);
        }

        public String getJobId() throws IOException {
            return (String)JsonPath.read((String)this.getString(), (String)"$.id", (Predicate[])new Predicate[0]);
        }
    }

    public static class Request
    extends AbstractRequest<Response> {
        String jar;
        String app;
        String input;
        String output;
        List<NameValuePair> params = new ArrayList<NameValuePair>();

        public Request(KnoxSession session) {
            super(session);
        }

        public Request jar(String jar) {
            this.jar = jar;
            return this;
        }

        public Request app(String app) {
            this.app = app;
            return this;
        }

        public Request input(String dir) {
            this.input = dir;
            return this;
        }

        public Request output(String dir) {
            this.output = dir;
            return this;
        }

        public Request arg(String value) {
            this.addParam(this.params, "arg", value);
            return this;
        }

        @Override
        protected Callable<Response> callable() {
            return new Callable<Response>(){

                @Override
                public Response call() throws Exception {
                    URIBuilder uri = this.uri(new String[]{"/templeton/v1", "/mapreduce/jar"});
                    params.add((NameValuePair)new BasicNameValuePair("jar", jar));
                    params.add((NameValuePair)new BasicNameValuePair("class", app));
                    params.add((NameValuePair)new BasicNameValuePair("arg", input));
                    params.add((NameValuePair)new BasicNameValuePair("arg", output));
                    UrlEncodedFormEntity form = new UrlEncodedFormEntity(params);
                    HttpPost request = new HttpPost(uri.build());
                    request.setEntity((HttpEntity)form);
                    return new Response((HttpResponse)this.execute((HttpRequest)request));
                }
            };
        }
    }
}

