/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util.urltemplate;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.knox.gateway.util.urltemplate.Token;

abstract class Segment {
    static final String ANONYMOUS_PARAM = "";
    static final String DEFAULT_PATTERN = "";
    static final String STAR_PATTERN = "*";
    static final String GLOB_PATTERN = "**";
    static final char DOT = '.';
    static final char ESC = '\\';
    public static final int STATIC = 1;
    public static final int REGEX = 2;
    public static final int STAR = 3;
    public static final int DEFAULT = 4;
    public static final int GLOB = 5;
    public static final int UNKNOWN = 6;
    private Token token;
    private Map<String, Value> values;

    protected Segment(Token token) {
        this.token = token;
        this.values = new LinkedHashMap<String, Value>();
        this.values.put(token.effectivePattern, new Value(token));
    }

    protected Token getToken() {
        return this.token;
    }

    public int hashCode() {
        return this.token.parameterName.hashCode();
    }

    public boolean equals(Object obj) {
        boolean equal;
        block2: {
            equal = false;
            if (!(obj instanceof Segment)) break block2;
            Segment that = (Segment)obj;
            boolean bl = equal = this.token.parameterName.equals(that.token.parameterName) && this.values.size() == that.values.size();
            if (equal) {
                String pattern;
                Iterator<String> iterator = this.values.keySet().iterator();
                while (iterator.hasNext() && (equal = that.values.containsKey(pattern = iterator.next()))) {
                }
            }
        }
        return equal;
    }

    public String getParamName() {
        return this.token.parameterName;
    }

    public Collection<Value> getValues() {
        return this.values.values();
    }

    public Value getFirstValue() {
        Value first = null;
        if (!this.values.isEmpty()) {
            first = this.values.values().iterator().next();
        }
        return first;
    }

    public boolean matches(Segment that) {
        if (this.getClass().isInstance(that)) {
            for (Value thisValue : this.values.values()) {
                for (Value thatValue : that.values.values()) {
                    if (!thisValue.matches(thatValue)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    void addValue(Token token) {
        Value value = new Value(token);
        this.values.put(token.effectivePattern, value);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.getParamName());
        Collection<Value> values = this.getValues();
        if (values == null) {
            s.append("null");
        } else if (values.isEmpty()) {
            s.append("empty");
        } else {
            s.append("[");
            Iterator<Value> i = values.iterator();
            while (i.hasNext()) {
                s.append(i.next());
                if (!i.hasNext()) continue;
                s.append(",");
            }
            s.append("]");
        }
        return s.toString();
    }

    static final String createRegex(String segment) {
        StringBuilder regex = new StringBuilder(segment);
        int len = regex.length();
        block4: for (int i = len - 1; i >= 0; --i) {
            char c = regex.charAt(i);
            switch (c) {
                case '*': {
                    regex.insert(i, '.');
                    continue block4;
                }
                case '$': 
                case '.': 
                case '\\': 
                case '{': 
                case '}': {
                    regex.insert(i, '\\');
                    continue block4;
                }
            }
        }
        return regex.toString();
    }

    static final Pattern compileRegex(String segment) {
        segment = Segment.createRegex(segment);
        return Pattern.compile(segment);
    }

    public class Value {
        private int type;
        private Token token;
        private Pattern regex;

        private Value(Token token) {
            this.token = token;
            this.regex = null;
            String effectivePattern = token.effectivePattern;
            if (token.isLiteral()) {
                this.type = 1;
            } else if ("".equals(effectivePattern)) {
                this.type = 4;
            } else if (Segment.STAR_PATTERN.equals(effectivePattern)) {
                this.type = 3;
            } else if (Segment.GLOB_PATTERN.equals(effectivePattern)) {
                this.type = 5;
            } else if (effectivePattern != null && effectivePattern.contains(Segment.STAR_PATTERN)) {
                this.type = 2;
                this.regex = Segment.compileRegex(effectivePattern);
            } else {
                this.type = 1;
            }
        }

        private Value(Value that) {
            this.type = that.type;
            this.token = that.token;
            this.regex = that.regex;
        }

        Token getToken() {
            return this.token;
        }

        public int getType() {
            return this.type;
        }

        public String getPattern() {
            return this.token.originalPattern;
        }

        String getOriginalPattern() {
            return this.token.originalPattern;
        }

        String getEffectivePattern() {
            return this.token.effectivePattern;
        }

        public Pattern getRegex() {
            return this.regex;
        }

        public String toString() {
            return this.token.effectivePattern;
        }

        public boolean matches(Value that) {
            boolean matches = this.getClass().isInstance(that);
            if (matches) {
                switch (this.getType()) {
                    case 1: {
                        matches = this.token.originalPattern.equals(that.token.originalPattern);
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        matches = true;
                        break;
                    }
                    case 2: {
                        matches = this.regex.matcher(that.token.effectivePattern).matches();
                        break;
                    }
                    default: {
                        matches = false;
                    }
                }
            }
            return matches;
        }
    }
}

