/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.util.urltemplate;

import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.knox.gateway.util.urltemplate.Evaluator;
import org.apache.knox.gateway.util.urltemplate.Resolver;

class Function {
    private String funcName = null;
    private String paramName = null;
    private List<String> paramValue = null;

    static List<String> evaluate(String statement, Resolver resolver, Evaluator evaluator) {
        Function function = new Function(statement);
        List<String> results = function.evaluate(resolver, evaluator);
        return results;
    }

    Function(String statement) {
        if (statement != null) {
            StringTokenizer parser = new StringTokenizer(statement, "$()[]", true);
            State state = State.UNKNOWN;
            while (parser.hasMoreTokens()) {
                String token = parser.nextToken().trim();
                if (token.isEmpty()) continue;
                switch (state) {
                    case UNKNOWN: {
                        if ("$".equals(token)) {
                            state = State.FUNCTION;
                            break;
                        }
                        if ("(".equals(token)) {
                            state = State.VARIABLE;
                            break;
                        }
                        if ("[".equals(token)) {
                            state = State.LITERAL;
                            break;
                        }
                        this.paramName = token;
                        return;
                    }
                    case FUNCTION: {
                        if ("$".equals(token) || ")".equals(token) || "]".equals(token)) break;
                        if ("(".equals(token)) {
                            state = State.VARIABLE;
                            break;
                        }
                        if ("[".equals(token)) {
                            state = State.LITERAL;
                            break;
                        }
                        this.funcName = token;
                        state = State.UNKNOWN;
                        break;
                    }
                    case VARIABLE: {
                        if (!("$".equals(token) || "(".equals(token) || ")".equals(token) || "[".equals(token) || "]".equals(token))) {
                            this.paramName = token;
                            return;
                        }
                    }
                    case LITERAL: {
                        if (!("$".equals(token) || "(".equals(token) || ")".equals(token) || "[".equals(token) || "]".equals(token))) {
                            this.paramValue = Arrays.asList(token.split(","));
                        }
                        return;
                    }
                }
            }
        }
    }

    String getFunctionName() {
        return this.funcName;
    }

    String getParameterName() {
        return this.paramName;
    }

    List<String> getParameterValue() {
        return this.paramValue;
    }

    List<String> evaluate(Resolver resolver, Evaluator evaluator) {
        List<String> values = this.paramValue;
        if (this.paramName != null && resolver != null) {
            values = resolver.resolve(this.paramName);
        }
        if (this.funcName != null && evaluator != null) {
            values = evaluator.evaluate(this.funcName, values);
        }
        return values;
    }

    private static enum State {
        UNKNOWN,
        FUNCTION,
        VARIABLE,
        LITERAL;

    }
}

