# Tools

Minho provides several tools in order for you to easily create your runtime.

Basically, Minho tools can use `minho-build.json` file describing the runtime.

Then, you can create different forms (distributions) for your runtime:

* `package` creates a directory containing all required resources for the runtime (exploded form). Then, you go in this directory and just launch the runtime with `java -jar minho-boot-xx.jar`
* `jar` creates an uber jar packaging runtime resources in one archive. Then, you launch the runtime with `java -jar myruntime.jar`
* `archive` creates a zip archive containing runtime resources and startup script. After extracting this archive, you can launch the runtime with `./bin/minho.sh`

You have different options to create the runtime.

## `minho-build.json` file

All Minho tools are using a runtime descriptor: `minho-build.json`.

This file describe:

* `name` of the runtime
* `properties` used to specify extra information to build the runtime
* `dependencies` is the modules (libraries) to be included in the runtime (using `file`, `http`, `mvn` URL)

Here's an example of `minho-build.json` file:

```json
{
	"name": "my-runtime",
	"properties": {
		"include.transitive": "true"
	},
	"dependencies": [
		"minho:minho-boot",
		"mvn:commons-lang/commons-lang/2.6"
	]
}
```

_NB: `minho-build.json` can be written by hand or can be generated by the `minho-maven-plugin` for instance._

## CLI

`minho-build` is a command line to create the runtime based on `minho-build.json` descriptor.

### Installation

`minho-build` CLI is packaged as an archive (tar.gz or zip).

Extract the archive in the folder of your choice:

```bash
$ tar zxvf minho-build-1.0-SNAPSHOT.tar.gz
```
or

```bash
$ unzip minho-build-1.0-SNAPSHOT.zip
```

It's recommended (for convenience) to add CLI `bin` folder in your `PATH` (`export PATH=/path/to/minho-build/bin:$PATH`).

You can display `minho-build` help with the `--help` argument:

```bash
$ mino-build --help
usage: minho-build [package|jar|archive]
Default build action is package
 -f,--file <arg>   Location of the minho-build.json file
 -h,--help         print this message
```

### Use

By default, `minho-build` is looking for a `minho-build.json` in the current directory. You can specify the location of the `minho-build.json` file with the `-f` (`--file`) option.

`minho-build.json` describes your runtime:

* `name` is the runtime name (required), also used to generate the runtime output directory
* `version` is optional, and allows you to specify runtime version (it can be used to easily create docker tag for instance)
* `properties` are used to specify build behaviors (see later for details)
* `dependencies` is the list of all artifacts that should be included in your runtime

Here's a minimal example of `minho-build.json`:

```json
{
	"name": "my-runtime",
	"dependencies": [
		"minho:minho-boot",
		"minho:minho-banner"
	]
}
```

Once you have the `minho-build.json` file, you have three options (arguments) to create your runtime distribution:

* `package` (default) creates a folder with all runtime dependencies (exploded mode):

```bash
$ minho-build package
Oct 18, 2022 8:47:01 AM org.apache.karaf.minho.tooling.common.Runtime <init>
INFO: Creating Minho runtime package in folder my-runtime
```

Then, you can launch the runtime with `java -jar minho-boot-1.0-SNAPSHOT.jar` in the runtime folder:

```bash
$ java -jar my-runtime/minho-boot-1.0-SNAPSHOT.jar 
Oct 18, 2022 8:48:45 AM org.apache.karaf.minho.boot.Main main
INFO: Starting runtime in exploded mode
Minho lib: /home/jbonofre/Workspace/karaf5/tooling/cli/target/minho-build-1.0-SNAPSHOT/bin
Oct 18, 2022 8:48:45 AM org.apache.karaf.minho.boot.service.ServiceRegistry add
INFO: Adding config-service service (-2147483647)
Oct 18, 2022 8:48:45 AM org.apache.karaf.minho.boot.service.ServiceRegistry add
INFO: Adding lifecycle-service service (-1000)
Oct 18, 2022 8:48:45 AM org.apache.karaf.minho.boot.service.ServiceRegistry add
INFO: Adding classloader-service service (-1000)
Oct 18, 2022 8:48:45 AM org.apache.karaf.minho.boot.service.ServiceRegistry add
INFO: Adding minho-banner-service service (2147483647)
Oct 18, 2022 8:48:45 AM org.apache.karaf.minho.banner.WelcomeBannerService onRegister
INFO: 
 __  __ _       _           
|  \/  (_)_ __ | |__   ___  
| |\/| | | '_ \| '_ \ / _ \ 
| |  | | | | | | | | | (_) |
|_|  |_|_|_| |_|_| |_|\___/ 
  Apache Karaf Minho 1.x

Oct 18, 2022 8:48:45 AM org.apache.karaf.minho.boot.service.ServiceRegistry lambda$start$2
INFO: Starting services
Oct 18, 2022 8:48:45 AM org.apache.karaf.minho.boot.service.LifeCycleService start
INFO: Starting lifecycle service
```

* `jar` created an uber jar packaging the whole runtime:

```bash
$ minho-build jar
Oct 18, 2022 8:52:13 AM org.apache.karaf.minho.tooling.common.Runtime <init>
INFO: Creating Minho runtime package in folder my-runtime
Oct 18, 2022 8:52:14 AM org.apache.karaf.minho.tooling.common.Runtime createJar
INFO: Creating Minho runtime uber jar
Oct 18, 2022 8:52:14 AM org.apache.karaf.minho.tooling.common.Runtime lambda$createJar$2
INFO: services META-INF/services/org.apache.karaf.minho.boot.spi.Service
Oct 18, 2022 8:52:14 AM org.apache.karaf.minho.tooling.common.Runtime lambda$createJar$2
INFO: services META-INF/services/org.apache.karaf.minho.boot.spi.Service
Oct 18, 2022 8:52:14 AM org.apache.karaf.minho.tooling.common.Runtime lambda$createJar$3
INFO: Adding jar entry /tmp/temp_my-runtime14876578769792859300/exploded/org
Oct 18, 2022 8:52:14 AM org.apache.karaf.minho.tooling.common.Runtime lambda$createJar$3
INFO: Adding jar entry /tmp/temp_my-runtime14876578769792859300/exploded/META-INF
Oct 18, 2022 8:52:14 AM org.apache.karaf.minho.tooling.common.Runtime lambda$addJarContent$4
WARNING: Can't add jar content duplicate entry: META-INF/MANIFEST.MF
```

You now have `my-runtime.jar` in `my-runtime` folder. You can copy this jar wherever you want (including another machine), and you can launch directly the runtime using this uber jar e.g. `java -jar my-runtime.jar`:

```bash
$ java -jar my-runtime.jar
Oct 18, 2022 8:53:57 AM org.apache.karaf.minho.boot.Main main
INFO: Starting runtime in exploded mode
Minho lib: /home/jbonofre/Workspace/karaf5/tooling/cli/target/minho-build-1.0-SNAPSHOT/bin
Oct 18, 2022 8:53:57 AM org.apache.karaf.minho.boot.service.ServiceRegistry add
INFO: Adding config-service service (-2147483647)
Oct 18, 2022 8:53:57 AM org.apache.karaf.minho.boot.service.ServiceRegistry add
INFO: Adding lifecycle-service service (-1000)
Oct 18, 2022 8:53:57 AM org.apache.karaf.minho.boot.service.ServiceRegistry add
INFO: Adding classloader-service service (-1000)
Oct 18, 2022 8:53:57 AM org.apache.karaf.minho.boot.service.ServiceRegistry add
INFO: Adding minho-banner-service service (2147483647)
Oct 18, 2022 8:53:57 AM org.apache.karaf.minho.banner.WelcomeBannerService onRegister
INFO:
 __  __ _       _
|  \/  (_)_ __ | |__   ___
| |\/| | | '_ \| '_ \ / _ \
| |  | | | | | | | | | (_) |
|_|  |_|_|_| |_|_| |_|\___/
  Apache Karaf Minho 1.x

Oct 18, 2022 8:53:57 AM org.apache.karaf.minho.boot.service.ServiceRegistry lambda$start$2
INFO: Starting services
Oct 18, 2022 8:53:57 AM org.apache.karaf.minho.boot.service.LifeCycleService start
INFO: Starting lifecycle service
```

* `archive` created a zip file containing the runtime, including a startup script:

```bash
$ minho-build archive
Oct 18, 2022 8:56:01 AM org.apache.karaf.minho.tooling.common.Runtime <init>
INFO: Creating Minho runtime package in folder my-runtime
Oct 18, 2022 8:56:02 AM org.apache.karaf.minho.tooling.common.Runtime createArchive
INFO: Creating Minho runtime archive
```

You now have `my-archive.zip` in the `my-archive` folder. You can move this zip file wherever you want (including other machines) and extract in the directory of your choice:

```bash
$ unzip my-runtime.zip
Archive:  my-runtime.zip
  inflating: minho-boot-1.0-SNAPSHOT.jar
   creating: bin/
  inflating: bin/minho.sh
  inflating: minho-banner-1.0-SNAPSHOT.jar
```

Then you can launch the runtime using `bin/minsho.sh` script:

```bash
$ cd bin
$ sh minho.sh
Oct 18, 2022 8:58:40 AM org.apache.karaf.minho.boot.Main main
INFO: Starting runtime in exploded mode
Minho lib: /home/jbonofre/Workspace/karaf5/tooling/cli/target/minho-build-1.0-SNAPSHOT/bin/temp
Oct 18, 2022 8:58:40 AM org.apache.karaf.minho.boot.service.ServiceRegistry add
INFO: Adding config-service service (-2147483647)
Oct 18, 2022 8:58:40 AM org.apache.karaf.minho.boot.service.ServiceRegistry add
INFO: Adding lifecycle-service service (-1000)
Oct 18, 2022 8:58:40 AM org.apache.karaf.minho.boot.service.ServiceRegistry add
INFO: Adding classloader-service service (-1000)
Oct 18, 2022 8:58:40 AM org.apache.karaf.minho.boot.service.ServiceRegistry add
INFO: Adding minho-banner-service service (2147483647)
Oct 18, 2022 8:58:40 AM org.apache.karaf.minho.banner.WelcomeBannerService onRegister
INFO:
 __  __ _       _
|  \/  (_)_ __ | |__   ___
| |\/| | | '_ \| '_ \ / _ \
| |  | | | | | | | | | (_) |
|_|  |_|_|_| |_|_| |_|\___/
  Apache Karaf Minho 1.x

Oct 18, 2022 8:58:40 AM org.apache.karaf.minho.boot.service.ServiceRegistry lambda$start$2
INFO: Starting services
Oct 18, 2022 8:58:40 AM org.apache.karaf.minho.boot.service.LifeCycleService start
INFO: Starting lifecycle service
```

## Apache Maven plugin

If you plan to build the runtime using [Apache Maven](https://maven.apache.org), Minho provides a Maven plugin.

You can add `minho-maven-plugin` in your `pom.xml`:

```xml
<?xml version="1.0" encoding="UTF-8"?>
<project xmlns="http://maven.apache.org/POM/4.0.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 https://maven.apache.org/xsd/maven-4.0.0.xsd">

	<modelVersion>4.0.0</modelVersion>

	<groupId>my.group.id</groupId>
	<artifactId>my-runtime</artifactId>
	<version>1.0-SNAPSHOT</version>
	<name>My Minho Runtime</name>

	<build>
		<plugins>
			<plugin>
				<groupId>org.apache.karaf.minho.tooling</groupId>
				<artifactId>minho-maven-plugin</artifactId>
				<version>1.0-SNAPSHOT</version>
				<executions>
					<execution>
						<id>package</id>
						<goals>
							<goal>package</goal>
						</goals>
						<configuration>
							<minhoBuild>${project.basedir}/src/main/resources/minho-build.json</minhoBuild>
						</configuration>
					</execution>
				</executions>
			</plugin>
		</plugins>
	</build>

</project>
```

You can now build your runtime with `mvn clean install`:

```bash
$ mvn clean install
...
[INFO] --- maven-jar-plugin:2.4:jar (default-jar) @ my-runtime ---
[INFO] Building jar: /home/jbonofre/Workspace/karaf5/tooling/cli/target/test/target/my-runtime-1.0-SNAPSHOT.jar
[INFO]
[INFO] --- minho-maven-plugin:1.0-SNAPSHOT:package (package) @ my-runtime ---
Downloading from apache.snapshots: https://repository.apache.org/snapshots/org/apache/karaf/minho/tooling/common/1.0-SNAPSHOT/maven-metadata.xml
Downloading from apache.snapshots: https://repository.apache.org/snapshots/org/apache/karaf/minho/minho-boot/1.0-SNAPSHOT/maven-metadata.xml
[INFO] Creating Minho runtime package
Oct 18, 2022 1:56:28 PM org.apache.karaf.minho.tooling.common.Runtime <init>
INFO: Creating Minho runtime package in folder my-runtime
[INFO]
[INFO] --- maven-install-plugin:2.4:install (default-install) @ my-runtime ---
[INFO] Installing /home/jbonofre/Workspace/karaf5/tooling/cli/target/test/target/my-runtime-1.0-SNAPSHOT.jar to /home/jbonofre/.m2/repository/my/group/id/my-runtime/1.0-SNAPSHOT/my-runtime-1.0-SNAPSHOT.jar
[INFO] Installing /home/jbonofre/Workspace/karaf5/tooling/cli/target/test/pom.xml to /home/jbonofre/.m2/repository/my/group/id/my-runtime/1.0-SNAPSHOT/my-runtime-1.0-SNAPSHOT.pom
[INFO] ------------------------------------------------------------------------
[INFO] BUILD SUCCESS
[INFO] ------------------------------------------------------------------------
[INFO] Total time:  1.554 s
[INFO] Finished at: 2022-10-18T13:56:28+02:00
[INFO] ------------------------------------------------------------------------
```

You now have `my-runtime` directory created in your project.

The `minho-maven-plugin` `goal` defines the build action: `package`, `jar`, `archive`.

## Gradle

**Coming soon!**

## REST

**Coming soon!**

## Minho Creator

**Coming soon!**

