/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.apache.log4j.spi.LoggingEventFieldResolver;

public class InFixToPostFix {
    private static final Map precedenceMap = new HashMap();
    private static final List operators = new Vector();

    public String convert(String expression) {
        return this.infixToPostFix(new CustomTokenizer(expression));
    }

    public static boolean isOperand(String s) {
        String symbol = s.toLowerCase(Locale.ENGLISH);
        return !operators.contains(symbol);
    }

    boolean precedes(String s1, String s2) {
        int index2;
        String symbol1 = s1.toLowerCase(Locale.ENGLISH);
        String symbol2 = s2.toLowerCase(Locale.ENGLISH);
        if (!precedenceMap.keySet().contains(symbol1)) {
            return false;
        }
        if (!precedenceMap.keySet().contains(symbol2)) {
            return false;
        }
        int index1 = (Integer)precedenceMap.get(symbol1);
        boolean precedesResult = index1 < (index2 = ((Integer)precedenceMap.get(symbol2)).intValue());
        return precedesResult;
    }

    String infixToPostFix(CustomTokenizer tokenizer) {
        String space = " ";
        StringBuffer postfix = new StringBuffer();
        Stack<String> stack = new Stack<String>();
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            boolean inText = token.startsWith("'") && !token.endsWith("'") || token.startsWith("\"") && !token.endsWith("\"");
            String quoteChar = token.substring(0, 1);
            if (inText) {
                while (inText && tokenizer.hasMoreTokens()) {
                    inText = !(token = token + " " + tokenizer.nextToken()).endsWith(quoteChar);
                }
            }
            if ("(".equals(token)) {
                postfix.append(this.infixToPostFix(tokenizer));
                postfix.append(" ");
                continue;
            }
            if (")".equals(token)) {
                while (stack.size() > 0) {
                    postfix.append(stack.pop().toString());
                    postfix.append(" ");
                }
                return postfix.toString();
            }
            if (InFixToPostFix.isOperand(token)) {
                postfix.append(token);
                postfix.append(" ");
                continue;
            }
            if (stack.size() > 0) {
                String peek = stack.peek().toString();
                if (this.precedes(peek, token)) {
                    stack.push(token);
                    continue;
                }
                boolean bypass = false;
                do {
                    if (stack.size() > 0 && !this.precedes(stack.peek().toString(), token)) {
                        postfix.append(stack.pop().toString());
                        postfix.append(" ");
                        continue;
                    }
                    bypass = true;
                } while (!bypass);
                stack.push(token);
                continue;
            }
            stack.push(token);
        }
        while (stack.size() > 0) {
            postfix.append(stack.pop().toString());
            postfix.append(" ");
        }
        return postfix.toString();
    }

    static {
        operators.add("<=");
        operators.add(">=");
        operators.add("!=");
        operators.add("==");
        operators.add("~=");
        operators.add("||");
        operators.add("&&");
        operators.add("like");
        operators.add("exists");
        operators.add("!");
        operators.add("<");
        operators.add(">");
        precedenceMap.put("<", new Integer(3));
        precedenceMap.put(">", new Integer(3));
        precedenceMap.put("<=", new Integer(3));
        precedenceMap.put(">=", new Integer(3));
        precedenceMap.put("!", new Integer(3));
        precedenceMap.put("!=", new Integer(3));
        precedenceMap.put("==", new Integer(3));
        precedenceMap.put("~=", new Integer(3));
        precedenceMap.put("like", new Integer(3));
        precedenceMap.put("exists", new Integer(3));
        precedenceMap.put("||", new Integer(2));
        precedenceMap.put("&&", new Integer(2));
    }

    public static class CustomTokenizer {
        private LinkedList linkedList = new LinkedList();

        public CustomTokenizer(String input) {
            this.parseInput(input, this.linkedList);
        }

        public void parseInput(String input, LinkedList linkedList) {
            List keywords = LoggingEventFieldResolver.KEYWORD_LIST;
            keywords.remove("PROP.");
            int pos = 0;
            while (pos < input.length()) {
                if (this.nextValueIs(input, pos, "'") || this.nextValueIs(input, pos, "\"")) {
                    pos = this.handleQuotedString(input, pos, linkedList);
                }
                if (this.nextValueIs(input, pos, "PROP.")) {
                    pos = this.handleProperty(input, pos, linkedList);
                }
                boolean operatorFound = false;
                for (String operator : operators) {
                    if (!this.nextValueIs(input, pos, operator)) continue;
                    operatorFound = true;
                    pos = this.handle(pos, linkedList, operator);
                }
                boolean keywordFound = false;
                for (String keyword : keywords) {
                    if (!this.nextValueIs(input, pos, keyword)) continue;
                    keywordFound = true;
                    pos = this.handle(pos, linkedList, keyword);
                }
                if (operatorFound || keywordFound) continue;
                if (this.nextValueIs(input, pos, ")")) {
                    pos = this.handle(pos, linkedList, ")");
                    continue;
                }
                if (this.nextValueIs(input, pos, "(")) {
                    pos = this.handle(pos, linkedList, "(");
                    continue;
                }
                if (this.nextValueIs(input, pos, " ")) {
                    ++pos;
                    continue;
                }
                pos = this.handleText(input, pos, linkedList);
            }
        }

        private boolean nextValueIs(String input, int pos, String value) {
            return input.length() >= pos + value.length() && input.substring(pos, pos + value.length()).equalsIgnoreCase(value);
        }

        private int handle(int pos, LinkedList linkedList, String value) {
            linkedList.add(value);
            return pos + value.length();
        }

        private int handleQuotedString(String input, int pos, LinkedList linkedList) {
            String quoteChar = input.substring(pos, pos + 1);
            int nextSingleQuotePos = input.indexOf(quoteChar, pos + 1);
            if (nextSingleQuotePos < 0) {
                throw new IllegalArgumentException("Missing an end quote");
            }
            String result = input.substring(pos, nextSingleQuotePos + 1);
            linkedList.add(result);
            return nextSingleQuotePos + 1;
        }

        private int handleText(String input, int pos, LinkedList linkedList) {
            StringBuffer text = new StringBuffer("");
            int newPos = pos;
            while (newPos < input.length()) {
                if (this.nextValueIs(input, newPos, " ")) {
                    linkedList.add(text);
                    return newPos;
                }
                if (this.nextValueIs(input, newPos, "(")) {
                    linkedList.add(text);
                    return newPos;
                }
                if (this.nextValueIs(input, newPos, ")")) {
                    linkedList.add(text);
                    return newPos;
                }
                for (String operator : operators) {
                    if (!this.nextValueIs(input, newPos, operator)) continue;
                    linkedList.add(text);
                    return newPos;
                }
                text.append(input.substring(newPos++, newPos));
            }
            if (!text.toString().trim().equals("")) {
                linkedList.add(text);
            }
            return newPos;
        }

        private int handleProperty(String input, int pos, LinkedList linkedList) {
            int propertyPos = pos + "PROP.".length();
            StringBuffer propertyName = new StringBuffer("PROP.");
            while (propertyPos < input.length()) {
                if (this.nextValueIs(input, propertyPos, " ")) {
                    linkedList.add(propertyName);
                    return propertyPos;
                }
                if (this.nextValueIs(input, propertyPos, "(")) {
                    linkedList.add(propertyName);
                    return propertyPos;
                }
                if (this.nextValueIs(input, propertyPos, ")")) {
                    linkedList.add(propertyName);
                    return propertyPos;
                }
                for (String operator : operators) {
                    if (!this.nextValueIs(input, propertyPos, operator)) continue;
                    linkedList.add(propertyName);
                    return propertyPos;
                }
                propertyName.append(input.substring(propertyPos++, propertyPos));
            }
            linkedList.add(propertyName);
            return propertyPos;
        }

        public boolean hasMoreTokens() {
            return this.linkedList.size() > 0;
        }

        public String nextToken() {
            return this.linkedList.remove().toString();
        }
    }
}

