/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.bundle.command;

import java.util.Collection;
import org.apache.karaf.bundle.command.BundlesCommand;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.fusesource.jansi.Ansi;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWiring;

@Command(scope="bundle", name="classes", description="Displays a list of classes/resources contained in the bundle")
@Service
public class Classes
extends BundlesCommand {
    @Option(name="-a", aliases={"--display-all-files"}, description="List all classes and files in the bundle", required=false, multiValued=false)
    boolean displayAllFiles;

    @Override
    protected void executeOnBundle(Bundle bundle) throws Exception {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (wiring != null) {
            Collection resources = this.displayAllFiles ? wiring.listResources("/", null, 1) : wiring.listResources("/", "*class", 1);
            Collection localResources = this.displayAllFiles ? wiring.listResources("/", null, 3) : wiring.listResources("/", "/*.class", 3);
            for (String resource : resources) {
                if (localResources.contains(resource)) {
                    System.out.println(Ansi.ansi().a(Ansi.Attribute.INTENSITY_BOLD).a(resource).a(Ansi.Attribute.RESET));
                    continue;
                }
                System.out.println(resource);
            }
        } else {
            System.out.println("Bundle " + bundle.getBundleId() + " is not resolved.");
        }
    }
}

