/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.region;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Conditional;
import org.apache.karaf.features.Dependency;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.Library;
import org.apache.karaf.features.ScopeFilter;
import org.apache.karaf.features.internal.download.DownloadCallback;
import org.apache.karaf.features.internal.download.DownloadManager;
import org.apache.karaf.features.internal.download.Downloader;
import org.apache.karaf.features.internal.download.StreamProvider;
import org.apache.karaf.features.internal.region.RepositoryManager;
import org.apache.karaf.features.internal.region.SubsystemResolveContext;
import org.apache.karaf.features.internal.repository.BaseRepository;
import org.apache.karaf.features.internal.resolver.CapabilityImpl;
import org.apache.karaf.features.internal.resolver.FeatureResource;
import org.apache.karaf.features.internal.resolver.RequirementImpl;
import org.apache.karaf.features.internal.resolver.ResolverUtil;
import org.apache.karaf.features.internal.resolver.ResourceBuilder;
import org.apache.karaf.features.internal.resolver.ResourceImpl;
import org.apache.karaf.features.internal.resolver.ResourceUtils;
import org.apache.karaf.features.internal.resolver.SimpleFilter;
import org.apache.karaf.features.internal.service.Overrides;
import org.apache.karaf.features.internal.util.MapUtils;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class Subsystem
extends ResourceImpl {
    private static final String ALL_FILTER = "(|(!(all=*))(all=*))";
    private static final String SUBSYSTEM_FILTER = String.format("(%s=%s)", "type", "karaf.subsystem");
    private static final String FEATURE_FILTER = String.format("(%s=%s)", "type", "karaf.feature");
    private static final String SUBSYSTEM_OR_FEATURE_FILTER = String.format("(|%s%s)", SUBSYSTEM_FILTER, FEATURE_FILTER);
    private static final Map<String, Set<String>> SHARE_ALL_POLICY = Collections.singletonMap("org.eclipse.equinox.allow.all", Collections.singleton("(|(!(all=*))(all=*))"));
    private static final Map<String, Set<String>> SHARE_NONE_POLICY = Collections.singletonMap("osgi.identity", Collections.singleton(SUBSYSTEM_FILTER));
    private final String name;
    private final boolean acceptDependencies;
    private final Subsystem parent;
    private final Feature feature;
    private final boolean mandatory;
    private final List<Subsystem> children = new ArrayList<Subsystem>();
    private final Map<String, Set<String>> importPolicy;
    private final Map<String, Set<String>> exportPolicy;
    private final List<Resource> installable = new ArrayList<Resource>();
    private final Map<String, DependencyInfo> dependencies = new HashMap<String, DependencyInfo>();
    private final List<Requirement> dependentFeatures = new ArrayList<Requirement>();
    private final List<String> bundles = new ArrayList<String>();

    public Subsystem(String name) {
        super(name, "karaf.subsystem", Version.emptyVersion);
        this.name = name;
        this.parent = null;
        this.acceptDependencies = true;
        this.feature = null;
        this.importPolicy = SHARE_NONE_POLICY;
        this.exportPolicy = SHARE_NONE_POLICY;
        this.mandatory = true;
    }

    public Subsystem(String name, Feature feature, Subsystem parent, boolean mandatory) {
        super(name, "karaf.subsystem", Version.emptyVersion);
        this.name = name;
        this.parent = parent;
        this.acceptDependencies = feature.getScoping() != null && feature.getScoping().acceptDependencies();
        this.feature = feature;
        this.mandatory = mandatory;
        if (feature.getScoping() != null) {
            this.importPolicy = this.createPolicy(feature.getScoping().getImports());
            this.importPolicy.put("osgi.identity", Collections.singleton(SUBSYSTEM_OR_FEATURE_FILTER));
            this.exportPolicy = this.createPolicy(feature.getScoping().getExports());
            this.exportPolicy.put("osgi.identity", Collections.singleton(SUBSYSTEM_OR_FEATURE_FILTER));
        } else {
            this.importPolicy = SHARE_ALL_POLICY;
            this.exportPolicy = SHARE_ALL_POLICY;
        }
        ResourceUtils.addIdentityRequirement((ResourceImpl)this, feature.getName(), "karaf.feature", new VersionRange(VersionTable.getVersion(feature.getVersion()), true));
    }

    public Subsystem(String name, Subsystem parent, boolean acceptDependencies, boolean mandatory) {
        super(name, "karaf.subsystem", Version.emptyVersion);
        this.name = name;
        this.parent = parent;
        this.acceptDependencies = acceptDependencies;
        this.feature = null;
        this.mandatory = mandatory;
        this.importPolicy = SHARE_ALL_POLICY;
        this.exportPolicy = SHARE_NONE_POLICY;
    }

    public List<Resource> getInstallable() {
        return this.installable;
    }

    public String getName() {
        return this.name;
    }

    public Subsystem getParent() {
        return this.parent;
    }

    public Collection<Subsystem> getChildren() {
        return this.children;
    }

    public Subsystem getChild(String name) {
        for (Subsystem child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public boolean isAcceptDependencies() {
        return this.acceptDependencies;
    }

    public Map<String, Set<String>> getImportPolicy() {
        return this.importPolicy;
    }

    public Map<String, Set<String>> getExportPolicy() {
        return this.exportPolicy;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public Subsystem createSubsystem(String name, boolean acceptDependencies) {
        if (this.feature != null) {
            throw new UnsupportedOperationException("Can not create application subsystems inside a feature subsystem");
        }
        String childName = this.getName() + "/" + name;
        Subsystem as = new Subsystem(childName, this, acceptDependencies, true);
        this.children.add(as);
        ResourceUtils.addIdentityRequirement((ResourceImpl)this, childName, "karaf.subsystem", (VersionRange)null);
        this.installable.add(as);
        return as;
    }

    public void addSystemResource(Resource resource) {
        this.installable.add(resource);
    }

    public void requireFeature(String name, String range, boolean mandatory) {
        if (mandatory) {
            ResourceUtils.addIdentityRequirement((ResourceImpl)this, name, "karaf.feature", range);
        } else {
            ResourceImpl res = new ResourceImpl();
            ResourceUtils.addIdentityRequirement(res, name, "karaf.feature", range, false);
            this.dependentFeatures.addAll(res.getRequirements(null));
        }
    }

    public void require(String requirement) throws BundleException {
        String req;
        String type;
        int idx = requirement.indexOf(58);
        if (idx >= 0) {
            type = requirement.substring(0, idx);
            req = requirement.substring(idx + 1);
        } else {
            type = "feature";
            req = requirement;
        }
        switch (type) {
            case "feature": {
                this.addRequirement(ResourceUtils.toFeatureRequirement(req));
                break;
            }
            case "requirement": {
                this.addRequirement(req);
                break;
            }
            case "bundle": {
                this.bundles.add(req);
            }
        }
    }

    protected void addRequirement(String requirement) throws BundleException {
        for (Requirement req : ResourceBuilder.parseRequirement(this, requirement)) {
            Object range = req.getAttributes().get("version");
            if (range instanceof String) {
                req.getAttributes().put("version", new VersionRange((String)range));
            }
            this.addRequirement(req);
        }
    }

    public Map<String, BundleInfo> getBundleInfos() {
        HashMap<String, BundleInfo> infos = new HashMap<String, BundleInfo>();
        for (DependencyInfo di : this.dependencies.values()) {
            infos.put(di.getLocation(), di);
        }
        return infos;
    }

    public void build(Collection<Feature> features) throws Exception {
        this.doBuild(features, true);
    }

    private void doBuild(Collection<Feature> features, boolean mandatory) throws Exception {
        for (Subsystem subsystem : this.children) {
            subsystem.doBuild(features, true);
        }
        if (this.feature != null) {
            for (Dependency dependency : this.feature.getDependencies()) {
                Subsystem ss = this;
                while (!ss.isAcceptDependencies()) {
                    ss = ss.getParent();
                }
                ss.requireFeature(dependency.getName(), dependency.getVersion(), false);
            }
            for (Conditional conditional : this.feature.getConditional()) {
                Feature fcond = conditional.asFeature();
                String ssName = this.name + "#" + (fcond.hasVersion() ? fcond.getName() + "-" + fcond.getVersion() : fcond.getName());
                Subsystem fs = this.getChild(ssName);
                if (fs != null) continue;
                fs = new Subsystem(ssName, fcond, this, true);
                fs.doBuild(features, false);
                this.installable.add(fs);
                this.children.add(fs);
            }
        }
        ArrayList<Requirement> processed = new ArrayList<Requirement>();
        block4: while (true) {
            List<Requirement> list = this.getRequirements("osgi.identity");
            list.addAll(this.dependentFeatures);
            list.removeAll(processed);
            if (list.isEmpty()) break;
            Iterator<Requirement> iterator = list.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block4;
                Requirement requirement = iterator.next();
                String name = (String)requirement.getAttributes().get("osgi.identity");
                String type = (String)requirement.getAttributes().get("type");
                VersionRange range = (VersionRange)requirement.getAttributes().get("version");
                if ("karaf.feature".equals(type)) {
                    for (Feature feature : features) {
                        String ssName;
                        Subsystem fs;
                        if (!feature.getName().equals(name) || range != null && !range.contains(VersionTable.getVersion(feature.getVersion())) || feature == this.feature || (fs = this.getChild(ssName = this.name + "#" + (feature.hasVersion() ? feature.getName() + "-" + feature.getVersion() : feature.getName()))) != null) continue;
                        fs = new Subsystem(ssName, feature, this, mandatory && !SubsystemResolveContext.isOptional(requirement));
                        fs.build(features);
                        this.installable.add(fs);
                        this.children.add(fs);
                    }
                }
                processed.add(requirement);
            }
            break;
        }
    }

    public Set<String> collectPrerequisites() {
        HashSet<String> prereqs = new HashSet<String>();
        this.doCollectPrerequisites(prereqs);
        return prereqs;
    }

    private void doCollectPrerequisites(Set<String> prereqs) {
        for (Subsystem child : this.children) {
            child.doCollectPrerequisites(prereqs);
        }
        if (this.feature != null) {
            for (Dependency dep : this.feature.getDependencies()) {
                if (!dep.isPrerequisite()) continue;
                prereqs.add(dep.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void downloadBundles(DownloadManager manager, Set<String> overrides, String featureResolutionRange, String serviceRequirements, RepositoryManager repos) throws Exception {
        void var12_45;
        String loc;
        void var12_37;
        for (Subsystem child : this.children) {
            child.downloadBundles(manager, overrides, featureResolutionRange, serviceRequirements, repos);
        }
        final ConcurrentHashMap bundles = new ConcurrentHashMap();
        Downloader downloader = manager.createDownloader();
        HashMap<BundleInfo, Conditional> infos = new HashMap<BundleInfo, Conditional>();
        if (this.feature != null) {
            for (Conditional conditional : this.feature.getConditional()) {
                for (BundleInfo bundleInfo : conditional.getBundles()) {
                    infos.put(bundleInfo, conditional);
                }
            }
            for (BundleInfo bundleInfo : this.feature.getBundles()) {
                infos.put(bundleInfo, null);
            }
        }
        final boolean removeServiceRequirements = "disable".equals(serviceRequirements) ? true : (this.feature != null && "default".equals(serviceRequirements) ? !"http://karaf.apache.org/xmlns/features/v1.3.0".equals(this.feature.getNamespace()) && !"http://karaf.apache.org/xmlns/features/v1.4.0".equals(this.feature.getNamespace()) : false);
        for (Map.Entry entry : infos.entrySet()) {
            BundleInfo bundleInfo = (BundleInfo)entry.getKey();
            final String string = bundleInfo.getLocation();
            downloader.download(string, new DownloadCallback(){

                @Override
                public void downloaded(StreamProvider provider) throws Exception {
                    ResourceImpl res = Subsystem.this.createResource(string, Subsystem.this.getMetadata(provider), removeServiceRequirements);
                    bundles.put(string, res);
                }
            });
        }
        Clause[] clauseArray = Parser.parseClauses(this.bundles.toArray(new String[this.bundles.size()]));
        int n = clauseArray.length;
        boolean bl = false;
        while (var12_37 < n) {
            Clause clause = clauseArray[var12_37];
            loc = clause.getName();
            downloader.download(loc, new DownloadCallback(){

                @Override
                public void downloaded(StreamProvider provider) throws Exception {
                    ResourceImpl res = Subsystem.this.createResource(loc, Subsystem.this.getMetadata(provider), removeServiceRequirements);
                    bundles.put(loc, res);
                }
            });
            ++var12_37;
        }
        for (String string : overrides) {
            final String string2 = Overrides.extractUrl(string);
            downloader.download(string2, new DownloadCallback(){

                @Override
                public void downloaded(StreamProvider provider) throws Exception {
                    ResourceImpl res = Subsystem.this.createResource(string2, Subsystem.this.getMetadata(provider), removeServiceRequirements);
                    bundles.put(string2, res);
                }
            });
        }
        if (this.feature != null) {
            for (Library library : this.feature.getLibraries()) {
                if (!library.isExport()) continue;
                final String string = library.getLocation();
                downloader.download(string, new DownloadCallback(){

                    @Override
                    public void downloaded(StreamProvider provider) throws Exception {
                        ResourceImpl res = Subsystem.this.createResource(string, Subsystem.this.getMetadata(provider), removeServiceRequirements);
                        bundles.put(string, res);
                    }
                });
            }
        }
        downloader.await();
        Overrides.override(bundles, overrides);
        if (this.feature != null) {
            ResourceImpl res;
            HashMap<Conditional, FeatureResource> hashMap = new HashMap<Conditional, FeatureResource>();
            for (Conditional conditional : this.feature.getConditional()) {
                FeatureResource featureResource = FeatureResource.build(this.feature, conditional, featureResolutionRange, bundles);
                ResourceUtils.addIdentityRequirement(this, featureResource, false);
                ResourceUtils.addIdentityRequirement(featureResource, this, true);
                this.installable.add(featureResource);
                hashMap.put(conditional, featureResource);
            }
            FeatureResource featureResource = FeatureResource.build(this.feature, featureResolutionRange, bundles);
            ResourceUtils.addIdentityRequirement(featureResource, this);
            this.installable.add(featureResource);
            for (Map.Entry entry : infos.entrySet()) {
                int sl;
                BundleInfo bi = (BundleInfo)entry.getKey();
                String loc5 = bi.getLocation();
                Conditional cond = (Conditional)entry.getValue();
                res = (ResourceImpl)bundles.get(loc5);
                int n2 = sl = bi.getStartLevel() <= 0 ? this.feature.getStartLevel() : bi.getStartLevel();
                if (bi.isDependency()) {
                    this.addDependency(res, false, bi.isStart(), sl);
                } else {
                    this.doAddDependency(res, cond == null, bi.isStart(), sl);
                }
                if (cond == null) continue;
                ResourceUtils.addIdentityRequirement(res, (Resource)hashMap.get(cond), true);
            }
            for (Library library : this.feature.getLibraries()) {
                if (!library.isExport()) continue;
                loc = library.getLocation();
                ResourceImpl res2 = (ResourceImpl)bundles.get(loc);
                this.addDependency(res2, false, false, 0);
            }
            for (String string : this.feature.getResourceRepositories()) {
                BaseRepository repo = repos.getRepository(this.feature.getRepositoryUrl(), string);
                for (Resource resource : repo.getResources()) {
                    res = this.cloneResource(resource);
                    this.addDependency(res, false, true, 0);
                }
            }
        }
        Clause[] clauseArray2 = Parser.parseClauses(this.bundles.toArray(new String[this.bundles.size()]));
        int n3 = clauseArray2.length;
        boolean bl2 = false;
        while (var12_45 < n3) {
            Clause clause = clauseArray2[var12_45];
            loc = clause.getName();
            boolean dependency = Boolean.parseBoolean(clause.getAttribute("dependency"));
            boolean start = clause.getAttribute("start") == null || Boolean.parseBoolean(clause.getAttribute("start"));
            int startLevel = 0;
            try {
                startLevel = Integer.parseInt(clause.getAttribute("start-level"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (dependency) {
                this.addDependency((ResourceImpl)bundles.get(loc), false, start, startLevel);
            } else {
                this.doAddDependency((ResourceImpl)bundles.get(loc), true, start, startLevel);
                ResourceUtils.addIdentityRequirement(this, (Resource)bundles.get(loc));
            }
            ++var12_45;
        }
        for (DependencyInfo dependencyInfo : this.dependencies.values()) {
            this.installable.add(dependencyInfo.resource);
            ResourceUtils.addIdentityRequirement(dependencyInfo.resource, this, dependencyInfo.mandatory);
        }
    }

    ResourceImpl cloneResource(Resource resource) {
        ResourceImpl res = new ResourceImpl();
        for (Capability cap : resource.getCapabilities(null)) {
            res.addCapability(new CapabilityImpl(res, cap.getNamespace(), new HashMap<String, String>(cap.getDirectives()), new HashMap<String, Object>(cap.getAttributes())));
        }
        for (Requirement req : resource.getRequirements(null)) {
            SimpleFilter sf = req instanceof RequirementImpl ? ((RequirementImpl)req).getFilter() : (req.getDirectives().containsKey("filter") ? SimpleFilter.parse((String)req.getDirectives().get("filter")) : SimpleFilter.convert(req.getAttributes()));
            res.addRequirement(new RequirementImpl(res, req.getNamespace(), new HashMap<String, String>(req.getDirectives()), new HashMap<String, Object>(req.getAttributes()), sf));
        }
        return res;
    }

    Map<String, String> getMetadata(StreamProvider provider) throws IOException {
        try (ZipInputStream zis = new ZipInputStream(provider.open());){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (!"META-INF/MANIFEST.MF".equals(entry.getName())) continue;
                Attributes attributes = new Manifest(zis).getMainAttributes();
                HashMap<String, String> headers = new HashMap<String, String>();
                for (Map.Entry<Object, Object> attr : attributes.entrySet()) {
                    headers.put(attr.getKey().toString(), attr.getValue().toString());
                }
                HashMap<String, String> hashMap = headers;
                return hashMap;
            }
        }
        throw new IllegalArgumentException("Resource " + provider.getUrl() + " does not contain a manifest");
    }

    void addDependency(ResourceImpl resource, boolean mandatory, boolean start, int startLevel) {
        if (this.isAcceptDependencies()) {
            this.doAddDependency(resource, mandatory, start, startLevel);
        } else {
            this.parent.addDependency(resource, mandatory, start, startLevel);
        }
    }

    private void doAddDependency(ResourceImpl resource, boolean mandatory, boolean start, int startLevel) {
        String id = ResolverUtil.getSymbolicName(resource) + "|" + ResolverUtil.getVersion(resource);
        DependencyInfo info = this.dependencies.get(id);
        if (info == null) {
            info = new DependencyInfo();
            this.dependencies.put(id, info);
        }
        info.resource = resource;
        info.mandatory |= mandatory;
        info.start |= start;
        info.startLevel = info.startLevel > 0 && startLevel > 0 ? Math.min(info.startLevel, startLevel) : Math.max(info.startLevel, startLevel);
    }

    Map<String, Set<String>> createPolicy(List<? extends ScopeFilter> filters) {
        HashMap<String, Set<String>> policy = new HashMap<String, Set<String>>();
        for (ScopeFilter scopeFilter : filters) {
            MapUtils.addToMapSet(policy, scopeFilter.getNamespace(), scopeFilter.getFilter());
        }
        return policy;
    }

    ResourceImpl createResource(String uri, Map<String, String> headers, boolean removeServiceRequirements) throws Exception {
        try {
            return ResourceBuilder.build(uri, headers, removeServiceRequirements);
        }
        catch (BundleException e) {
            throw new Exception("Unable to create resource for bundle " + uri, e);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    class DependencyInfo
    implements BundleInfo {
        ResourceImpl resource;
        boolean mandatory;
        boolean start;
        int startLevel;

        DependencyInfo() {
        }

        @Override
        public boolean isStart() {
            return this.start;
        }

        @Override
        public int getStartLevel() {
            return this.startLevel;
        }

        @Override
        public String getLocation() {
            return ResourceUtils.getUri(this.resource);
        }

        @Override
        public boolean isDependency() {
            return !this.mandatory;
        }
    }
}

