/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.resolver;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.karaf.features.internal.resolver.BaseClause;
import org.apache.karaf.features.internal.resolver.ResourceBuilder;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

public class CapabilityImpl
extends BaseClause
implements Capability {
    private final Resource resource;
    private final String namespace;
    private final Map<String, String> dirs;
    private final Map<String, Object> attrs;
    private final Set<String> mandatory;

    public CapabilityImpl(Resource resource, String namespace, Map<String, String> dirs, Map<String, Object> attrs) {
        this.namespace = namespace;
        this.resource = resource;
        this.dirs = dirs;
        this.attrs = attrs;
        Set mandatory = Collections.emptySet();
        String value = this.dirs.get("mandatory");
        if (value != null) {
            List<String> names = ResourceBuilder.parseDelimitedString(value, ",");
            mandatory = new HashSet(names.size());
            for (String name : names) {
                if (this.attrs.containsKey(name)) {
                    mandatory.add(name);
                    continue;
                }
                throw new IllegalArgumentException("Mandatory attribute '" + name + "' does not exist.");
            }
        }
        this.mandatory = mandatory;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.dirs;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attrs;
    }

    public boolean isAttributeMandatory(String name) {
        return !this.mandatory.isEmpty() && this.mandatory.contains(name);
    }
}

