/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import jline.console.ConsoleReader;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.commands.CommandException;
import org.apache.karaf.shell.console.CloseShellException;
import org.fusesource.jansi.Ansi;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShellUtil.class);

    public static String getBundleName(Bundle bundle) {
        if (bundle != null) {
            String name = (String)bundle.getHeaders().get("Bundle-Name");
            return name == null ? "Bundle " + Long.toString(bundle.getBundleId()) : name + " (" + Long.toString(bundle.getBundleId()) + ")";
        }
        return "[STALE BUNDLE]";
    }

    public static String getUnderlineString(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            sb.append('-');
        }
        return sb.toString();
    }

    public static String getValueString(Object obj) {
        if (obj == null) {
            return "null";
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof Collection) {
            Object[] array = ((Collection)obj).toArray();
            return ShellUtil.getValueString(array);
        }
        if (obj.getClass().isArray()) {
            Object[] array = (Object[])obj;
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (int i = 0; i < array.length; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(ShellUtil.getValueString(array[i]));
            }
            sb.append("]");
            return sb.toString();
        }
        return obj.toString();
    }

    public static boolean isASystemBundle(BundleContext bundleContext, Bundle bundle) {
        int level = ((BundleStartLevel)bundle.adapt(BundleStartLevel.class)).getStartLevel();
        int sbsl = 49;
        String sbslProp = bundleContext.getProperty("karaf.systemBundlesStartLevel");
        if (sbslProp != null) {
            try {
                sbsl = Integer.valueOf(sbslProp);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return level <= sbsl;
    }

    public static boolean accessToSystemBundleIsAllowed(long bundleId, CommandSession session) throws IOException {
        String str;
        do {
            String msg;
            ConsoleReader reader;
            if (!"yes".equalsIgnoreCase(str = (reader = (ConsoleReader)session.get(".jline.reader")).readLine(msg = "You are about to access system bundle " + bundleId + ".  Do you wish to continue (yes/no): "))) continue;
            return true;
        } while (!"no".equalsIgnoreCase(str));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadClassPathResource(Class<?> clazz, String path) {
        InputStream is = clazz.getResourceAsStream(path);
        if (is == null) {
            is = clazz.getClassLoader().getResourceAsStream(path);
        }
        if (is == null) {
            return "Unable to load description from " + path;
        }
        try {
            int c;
            InputStreamReader r = new InputStreamReader(is);
            StringWriter sw = new StringWriter();
            while ((c = ((Reader)r).read()) != -1) {
                sw.append((char)c);
            }
            String string = sw.toString();
            return string;
        }
        catch (IOException e) {
            String string = "Unable to load description from " + path;
            return string;
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {}
        }
    }

    public static boolean getBoolean(CommandSession session, String name) {
        Object s = session.get(name);
        if (s == null) {
            s = System.getProperty(name);
        }
        if (s == null) {
            return false;
        }
        if (s instanceof Boolean) {
            return (Boolean)s;
        }
        return Boolean.parseBoolean(s.toString());
    }

    public static void logException(CommandSession session, Throwable t) {
        try {
            boolean isCommandNotFound = "org.apache.felix.gogo.runtime.CommandNotFoundException".equals(t.getClass().getName());
            if (isCommandNotFound) {
                LOGGER.debug("Unknown command entered", t);
            } else if (t instanceof CommandException) {
                LOGGER.debug("Command exception (Undefined option, ...)", t);
            } else if (!(t instanceof CloseShellException)) {
                LOGGER.error("Exception caught while executing command", t);
            }
            session.put("karaf.lastException", t);
            if (t instanceof CommandException) {
                session.getConsole().println(((CommandException)t).getNiceHelp());
            } else if (isCommandNotFound) {
                String str = Ansi.ansi().fg(Ansi.Color.RED).a("Command not found: ").a(Ansi.Attribute.INTENSITY_BOLD).a(t.getClass().getMethod("getCommand", new Class[0]).invoke((Object)t, new Object[0])).a(Ansi.Attribute.INTENSITY_BOLD_OFF).fg(Ansi.Color.DEFAULT).toString();
                session.getConsole().println(str);
            }
            if (ShellUtil.getBoolean(session, "karaf.printStackTraces")) {
                session.getConsole().print(Ansi.ansi().fg(Ansi.Color.RED).toString());
                t.printStackTrace(session.getConsole());
                session.getConsole().print(Ansi.ansi().fg(Ansi.Color.DEFAULT).toString());
            } else if (!(t instanceof CloseShellException || t instanceof CommandException || isCommandNotFound)) {
                session.getConsole().print(Ansi.ansi().fg(Ansi.Color.RED).toString());
                session.getConsole().println("Error executing command: " + (t.getMessage() != null ? t.getMessage() : t.getClass().getName()));
                session.getConsole().print(Ansi.ansi().fg(Ansi.Color.DEFAULT).toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

