/*
 * Decompiled with CFR 0.152.
 */
package org.jledit.jline;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Properties;
import org.jledit.utils.Urls;

public final class JlineConfiguration {
    public static final String JLINE_CONFIGURATION = "jline.configuration";
    public static final String JLINE_RC = ".jline.rc";
    private static volatile Properties properties;

    private JlineConfiguration() {
    }

    private static Properties initProperties() {
        URL url = JlineConfiguration.determineUrl();
        Properties props = new Properties();
        try {
            JlineConfiguration.loadProperties(url, props);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties(URL url, Properties props) throws IOException {
        InputStream input = url.openStream();
        try {
            props.load(new BufferedInputStream(input));
        }
        finally {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static URL determineUrl() {
        String tmp = System.getProperty(JLINE_CONFIGURATION);
        if (tmp != null) {
            return Urls.create(tmp);
        }
        File file = new File(JlineConfiguration.getUserHome(), JLINE_RC);
        return Urls.create(file);
    }

    public static void reset() {
        properties = null;
        JlineConfiguration.getProperties();
    }

    public static Properties getProperties() {
        if (properties == null) {
            properties = JlineConfiguration.initProperties();
        }
        return properties;
    }

    public static String getString(String name, String defaultValue) {
        String value = System.getProperty(name);
        if (value == null && (value = JlineConfiguration.getProperties().getProperty(name)) == null) {
            value = defaultValue;
        }
        return value;
    }

    public static String getString(String name) {
        return JlineConfiguration.getString(name, null);
    }

    public static boolean getBoolean(String name, boolean defaultValue) {
        String value = JlineConfiguration.getString(name);
        if (value == null) {
            return defaultValue;
        }
        return value.length() == 0 || value.equalsIgnoreCase("1") || value.equalsIgnoreCase("on") || value.equalsIgnoreCase("true");
    }

    public static int getInteger(String name, int defaultValue) {
        String str = JlineConfiguration.getString(name);
        if (str == null) {
            return defaultValue;
        }
        return Integer.parseInt(str);
    }

    public static long getLong(String name, long defaultValue) {
        String str = JlineConfiguration.getString(name);
        if (str == null) {
            return defaultValue;
        }
        return Long.parseLong(str);
    }

    public static String getLineSeparator() {
        return System.getProperty("line.separator");
    }

    public static File getUserHome() {
        return new File(System.getProperty("user.home"));
    }

    public static String getOsName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static boolean isWindows() {
        return JlineConfiguration.getOsName().startsWith("windows");
    }

    public static String getFileEncoding() {
        return System.getProperty("file.encoding");
    }

    public static String getEncoding() {
        String ctype = System.getenv("LC_CTYPE");
        if (ctype != null && ctype.indexOf(46) > 0) {
            return ctype.substring(ctype.indexOf(46) + 1);
        }
        return System.getProperty("input.encoding", Charset.defaultCharset().name());
    }
}

