/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console.impl.jline;

import java.nio.charset.Charset;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import jline.Terminal;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.jaas.boot.principal.RolePrincipal;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;
import org.apache.karaf.jaas.modules.JaasHelper;
import org.apache.karaf.shell.console.Console;
import org.apache.karaf.shell.console.ConsoleFactory;
import org.apache.karaf.shell.console.impl.jline.DelayedStarted;
import org.apache.karaf.shell.console.impl.jline.TerminalFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalConsoleManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalConsoleManager.class);
    private ConsoleFactory consoleFactory;
    private BundleContext bundleContext;
    private TerminalFactory terminalFactory;
    private Console console;
    private boolean start;
    private final int defaultStartLevel;
    private CommandProcessor commandProcessor;
    private ThreadIO threadIO;
    private ServiceRegistration registration;

    public LocalConsoleManager(boolean start, String defaultStartLevel, BundleContext bundleContext, TerminalFactory terminalFactory, ConsoleFactory consoleFactory, CommandProcessor commandProcessor, ThreadIO threadIO) throws Exception {
        this.start = start;
        this.defaultStartLevel = Integer.parseInt(defaultStartLevel);
        this.bundleContext = bundleContext;
        this.terminalFactory = terminalFactory;
        this.consoleFactory = consoleFactory;
        this.commandProcessor = commandProcessor;
        this.threadIO = threadIO;
        this.start();
    }

    public void start() throws Exception {
        if (!this.start) {
            return;
        }
        final Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new UserPrincipal("karaf"));
        String roles = System.getProperty("karaf.local.roles");
        if (roles != null) {
            for (String role : roles.split("[,]")) {
                subject.getPrincipals().add((Principal)new RolePrincipal(role.trim()));
            }
        }
        final Terminal terminal = this.terminalFactory.getTerminal();
        final Runnable callback = new Runnable(){

            @Override
            public void run() {
                try {
                    LocalConsoleManager.this.bundleContext.getBundle(0L).stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        final String encoding = LocalConsoleManager.getEncoding();
        Runnable consoleStarter = new Runnable(){

            @Override
            public void run() {
                new Thread("Karaf Console Local for user " + JaasHelper.getUserName((Subject)subject)){

                    @Override
                    public void run() {
                        JaasHelper.doAs((Subject)subject, (PrivilegedAction)new PrivilegedAction<Object>(){

                            @Override
                            public Object run() {
                                LocalConsoleManager.this.console = LocalConsoleManager.this.consoleFactory.createLocal(LocalConsoleManager.this.commandProcessor, LocalConsoleManager.this.threadIO, terminal, encoding, callback);
                                LocalConsoleManager.this.registration = LocalConsoleManager.this.bundleContext.registerService(CommandSession.class, (Object)LocalConsoleManager.this.console.getSession(), null);
                                CommandSession session = LocalConsoleManager.this.console.getSession();
                                session.put("USER", JaasHelper.getUserName((Subject)subject));
                                LocalConsoleManager.this.console.run();
                                return null;
                            }
                        });
                    }
                }.start();
            }
        };
        boolean delayconsole = Boolean.parseBoolean(System.getProperty("karaf.delay.console"));
        if (delayconsole) {
            DelayedStarted watcher = new DelayedStarted(consoleStarter, this.bundleContext, System.in);
            new Thread(watcher).start();
        } else {
            consoleStarter.run();
        }
    }

    public void stop() throws Exception {
        if (this.registration != null) {
            this.registration.unregister();
        }
        if (this.console != null) {
            this.console.close(false);
        }
    }

    public static String getEncoding() {
        String envEncoding = LocalConsoleManager.extractEncodingFromCtype(System.getenv("LC_CTYPE"));
        if (envEncoding != null) {
            return envEncoding;
        }
        return System.getProperty("input.encoding", Charset.defaultCharset().name());
    }

    static String extractEncodingFromCtype(String ctype) {
        if (ctype != null && ctype.indexOf(46) > 0) {
            String encodingAndModifier = ctype.substring(ctype.indexOf(46) + 1);
            if (encodingAndModifier.indexOf(64) > 0) {
                return encodingAndModifier.substring(0, encodingAndModifier.indexOf(64));
            }
            return encodingAndModifier;
        }
        return null;
    }
}

