/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.ssh;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.KeyPair;
import java.util.List;
import jline.Terminal;
import jline.console.ConsoleReader;
import org.apache.karaf.shell.commands.Argument;
import org.apache.karaf.shell.commands.Command;
import org.apache.karaf.shell.commands.Option;
import org.apache.karaf.shell.console.OsgiCommandSupport;
import org.apache.karaf.shell.ssh.KnownHostsManager;
import org.apache.karaf.shell.ssh.ServerKeyVerifierImpl;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.SshClient;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.local.AgentImpl;
import org.apache.sshd.agent.local.LocalAgentFactory;
import org.apache.sshd.client.ServerKeyVerifier;
import org.apache.sshd.client.UserInteraction;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.util.NoCloseInputStream;
import org.apache.sshd.common.util.NoCloseOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="ssh", name="ssh", description="Connects to a remote SSH server")
public class SshAction
extends OsgiCommandSupport {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Option(name="-l", aliases={"--username"}, description="The user name for remote login", required=false, multiValued=false)
    private String username;
    @Option(name="-P", aliases={"--password"}, description="The password for remote login", required=false, multiValued=false)
    private String password;
    @Option(name="-p", aliases={"--port"}, description="The port to use for SSH connection", required=false, multiValued=false)
    private int port = 22;
    @Option(name="-k", aliases={"--keyfile"}, description="The private keyFile location when using key login, need have BouncyCastle registered as security provider using this flag", required=false, multiValued=false)
    private String keyFile;
    @Option(name="-q", description="Quiet Mode. Do not ask for confirmations", required=false, multiValued=false)
    private boolean quiet;
    @Option(name="-r", aliases={"--retries"}, description="Retry connection establishment (up to attempts times)", required=false, multiValued=false)
    private int retries = 0;
    @Argument(index=0, name="hostname", description="The host name to connect to via SSH", required=true, multiValued=false)
    private String hostname;
    @Argument(index=1, name="command", description="Optional command to execute", required=false, multiValued=true)
    private List<String> command;
    private ClientSession sshSession;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        if (this.hostname.indexOf(64) >= 0) {
            if (this.username == null) {
                this.username = this.hostname.substring(0, this.hostname.indexOf(64));
            }
            this.hostname = this.hostname.substring(this.hostname.indexOf(64) + 1, this.hostname.length());
        }
        System.out.println("Connecting to host " + this.hostname + " on port " + this.port);
        if (this.username == null) {
            this.username = (String)this.session.get("USER");
        }
        if (this.username == null) {
            this.log.debug("Prompting user for login");
            if (this.username == null) {
                this.username = this.readLine("Login: ");
            }
        }
        SshClient client = SshClient.setUpDefaultClient();
        this.setupAgent(this.username, this.keyFile, client);
        KnownHostsManager knownHostsManager = new KnownHostsManager(new File(System.getProperty("user.home"), ".sshkaraf/known_hosts"));
        ServerKeyVerifierImpl serverKeyVerifier = new ServerKeyVerifierImpl(knownHostsManager, this.quiet);
        client.setServerKeyVerifier((ServerKeyVerifier)serverKeyVerifier);
        this.log.debug("Created client: {}", (Object)client);
        client.setUserInteraction(new UserInteraction(){

            public void welcome(String banner) {
                System.out.println(banner);
            }

            public String[] interactive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
                String[] answers = new String[prompt.length];
                try {
                    for (int i = 0; i < prompt.length; ++i) {
                        answers[i] = SshAction.this.readLine(prompt[i] + " ", echo[i] ? null : Character.valueOf('*'));
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                return answers;
            }
        });
        client.start();
        try {
            ClientSession sshSession = ((ConnectFuture)client.connect(this.username, this.hostname, this.port).await()).getSession();
            Object oldIgnoreInterrupts = this.session.get("karaf.ignoreInterrupts");
            try {
                ClientChannel channel;
                if (this.password != null) {
                    sshSession.addPasswordIdentity(this.password);
                }
                sshSession.auth().verify();
                System.out.println("Connected");
                this.session.put("karaf.ignoreInterrupts", (Object)Boolean.TRUE);
                StringBuilder sb = new StringBuilder();
                if (this.command != null) {
                    for (String cmd : this.command) {
                        if (sb.length() > 0) {
                            sb.append(' ');
                        }
                        sb.append(cmd);
                    }
                }
                if (sb.length() > 0) {
                    channel = sshSession.createChannel("exec", sb.append("\n").toString());
                    channel.setIn((InputStream)new ByteArrayInputStream(new byte[0]));
                } else {
                    channel = sshSession.createChannel("shell");
                    channel.setIn((InputStream)new NoCloseInputStream(System.in));
                    ((ChannelShell)channel).setPtyColumns(this.getTermWidth());
                    ((ChannelShell)channel).setupSensibleDefaultPty();
                    ((ChannelShell)channel).setAgentForwarding(true);
                    Object ctype = this.session.get("LC_CTYPE");
                    if (ctype != null) {
                        ((ChannelShell)channel).setEnv("LC_CTYPE", ctype.toString());
                    }
                }
                channel.setOut((OutputStream)new NoCloseOutputStream((OutputStream)System.out));
                channel.setErr((OutputStream)new NoCloseOutputStream((OutputStream)System.err));
                channel.open().verify();
                channel.waitFor(2, 0L);
            }
            finally {
                this.session.put("karaf.ignoreInterrupts", oldIgnoreInterrupts);
                sshSession.close(false);
            }
        }
        finally {
            client.stop();
        }
        return null;
    }

    private int getTermWidth() {
        Terminal term = (Terminal)this.session.get(".jline.terminal");
        return term != null ? term.getWidth() : 80;
    }

    public String readLine(String msg) throws IOException {
        return this.readLine(msg, null);
    }

    public String readLine(String msg, Character mask) throws IOException {
        ConsoleReader reader = (ConsoleReader)this.session.get(".jline.reader");
        return reader.readLine(msg, mask);
    }

    private void setupAgent(String user, String keyFile, SshClient client) {
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource("karaf.key");
        SshAgent agent = this.startAgent(user, url, keyFile);
        client.setAgentFactory((SshAgentFactory)new LocalAgentFactory(agent));
        client.getProperties().put("SSH_AUTH_SOCK", "local");
    }

    private SshAgent startAgent(String user, URL privateKeyUrl, String keyFile) {
        InputStream is = null;
        try {
            AgentImpl agent = new AgentImpl();
            is = privateKeyUrl.openStream();
            ObjectInputStream r = new ObjectInputStream(is);
            KeyPair keyPair = (KeyPair)r.readObject();
            is.close();
            agent.addIdentity(keyPair, user);
            if (keyFile != null) {
                String[] keyFiles = new String[]{keyFile};
                FileKeyPairProvider fileKeyPairProvider = new FileKeyPairProvider(keyFiles);
                for (KeyPair key : fileKeyPairProvider.loadKeys()) {
                    agent.addIdentity(key, user);
                }
            }
            return agent;
        }
        catch (Throwable e) {
            this.close(is);
            System.err.println("Error starting ssh agent for: " + e.getMessage());
            return null;
        }
    }

    private static ClientSession connectWithRetries(SshClient client, String username, String host, int port, int maxAttempts) throws Exception, InterruptedException {
        ClientSession session = null;
        int retries = 0;
        do {
            ConnectFuture future = client.connect(username, host, port);
            future.await();
            try {
                session = future.getSession();
            }
            catch (Exception ex) {
                if (retries++ < maxAttempts) {
                    Thread.sleep(2000L);
                    System.out.println("retrying (attempt " + retries + ") ...");
                    continue;
                }
                throw ex;
            }
        } while (session == null);
        return session;
    }

    private void close(Closeable is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

