/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jsonschema.spi.builtin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonValue;
import org.apache.johnzon.jsonschema.JsonSchemaValidator;
import org.apache.johnzon.jsonschema.JsonSchemaValidatorFactory;
import org.apache.johnzon.jsonschema.ValidationResult;
import org.apache.johnzon.jsonschema.spi.ValidationContext;
import org.apache.johnzon.jsonschema.spi.ValidationExtension;
import org.apache.johnzon.jsonschema.spi.builtin.BaseValidation;

public class ItemsValidation
implements ValidationExtension {
    private final JsonSchemaValidatorFactory factory;

    public ItemsValidation(JsonSchemaValidatorFactory factory) {
        this.factory = factory;
    }

    @Override
    public Optional<Function<JsonValue, Stream<ValidationResult.ValidationError>>> create(ValidationContext model) {
        return Optional.ofNullable(model.getSchema().get((Object)"items")).map(items -> {
            switch (items.getValueType()) {
                case OBJECT: {
                    JsonSchemaValidator objectValidator = this.factory.newInstance(items.asJsonObject());
                    return new ItemsValidator(model.toPointer(), model.getValueProvider(), Collections.singleton(objectValidator));
                }
                case ARRAY: {
                    return new ItemsValidator(model.toPointer(), model.getValueProvider(), items.asJsonArray().stream().filter(it -> it.getValueType() == JsonValue.ValueType.OBJECT).map(it -> this.factory.newInstance(it.asJsonObject())).collect(Collectors.toList()));
                }
            }
            return null;
        });
    }

    private static class ItemsValidator
    extends BaseValidation {
        private final Collection<JsonSchemaValidator> objectValidators;

        private ItemsValidator(String pointer, Function<JsonValue, JsonValue> extractor, Collection<JsonSchemaValidator> objectValidators) {
            super(pointer, extractor, JsonValue.ValueType.ARRAY);
            this.objectValidators = objectValidators;
        }

        @Override
        protected Stream<ValidationResult.ValidationError> onArray(JsonArray array) {
            ArrayList errors = null;
            for (int i = 0; i < array.size(); ++i) {
                JsonValue value = (JsonValue)array.get(i);
                Collection itemErrors = this.objectValidators.stream().flatMap(validator -> validator.apply(value).getErrors().stream()).collect(Collectors.toList());
                if (itemErrors == null || itemErrors.isEmpty()) continue;
                if (errors == null) {
                    errors = new ArrayList();
                }
                String suffix = "[" + i + "]";
                errors.addAll(itemErrors.stream().map(e -> new ValidationResult.ValidationError(this.pointer + e.getField() + suffix, e.getMessage())).collect(Collectors.toList()));
            }
            return errors == null ? Stream.empty() : errors.stream();
        }

        public String toString() {
            return "Items{validators=" + this.objectValidators + ", pointer='" + this.pointer + '\'' + '}';
        }
    }
}

