/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.node;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.Expression;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.node.Node;
import io.burt.jmespath.node.Operator;
import io.burt.jmespath.node.OperatorNode;

public abstract class ComparisonNode<T>
extends OperatorNode<T> {
    protected ComparisonNode(Adapter<T> runtime, Expression<T> left, Expression<T> right) {
        super(runtime, left, right);
    }

    public static <U> Node<U> create(Adapter<U> runtime, Operator operator, Expression<U> left, Expression<U> right) {
        switch (operator) {
            case EQUALS: {
                return new EqualsNode<U>(runtime, left, right);
            }
            case NOT_EQUALS: {
                return new NotEqualsNode<U>(runtime, left, right);
            }
            case GREATER_THAN: {
                return new GreaterThanNode<U>(runtime, left, right);
            }
            case GREATER_THAN_OR_EQUALS: {
                return new GreaterThanOrEqualsNode<U>(runtime, left, right);
            }
            case LESS_THAN: {
                return new LessThanNode<U>(runtime, left, right);
            }
            case LESS_THAN_OR_EQUALS: {
                return new LessThanOrEqualsNode<U>(runtime, left, right);
            }
        }
        throw new IllegalStateException(String.format("Unknown operator encountered: %s", new Object[]{operator}));
    }

    @Override
    public T search(T input) {
        Object leftResult = this.operand(0).search(input);
        Object rightResult = this.operand(1).search(input);
        JmesPathType leftType = this.runtime.typeOf(leftResult);
        JmesPathType rightType = this.runtime.typeOf(rightResult);
        if (leftType == JmesPathType.NUMBER && rightType == JmesPathType.NUMBER) {
            return this.compareNumbers(leftResult, rightResult);
        }
        return this.compareObjects(leftResult, rightResult);
    }

    protected int comparisonResult(T leftResult, T rightResult) {
        return this.runtime.compare(leftResult, rightResult);
    }

    protected T compareObjects(T leftResult, T rightResult) {
        return this.runtime.createNull();
    }

    protected abstract T compareNumbers(T var1, T var2);

    @Override
    protected String internalToString() {
        return String.format("%s, %s, %s", this.operatorToString(), this.operand(0), this.operand(1));
    }

    protected abstract String operatorToString();

    @Override
    protected int internalHashCode() {
        return this.operatorToString().hashCode();
    }

    public static class LessThanOrEqualsNode<T>
    extends ComparisonNode<T> {
        public LessThanOrEqualsNode(Adapter<T> runtime, Expression<T> left, Expression<T> right) {
            super(runtime, left, right);
        }

        @Override
        protected T compareNumbers(T leftResult, T rightResult) {
            return this.runtime.createBoolean(this.comparisonResult(leftResult, rightResult) <= 0);
        }

        @Override
        protected String operatorToString() {
            return "<=";
        }
    }

    public static class LessThanNode<T>
    extends ComparisonNode<T> {
        public LessThanNode(Adapter<T> runtime, Expression<T> left, Expression<T> right) {
            super(runtime, left, right);
        }

        @Override
        protected T compareNumbers(T leftResult, T rightResult) {
            return this.runtime.createBoolean(this.comparisonResult(leftResult, rightResult) < 0);
        }

        @Override
        protected String operatorToString() {
            return "<";
        }
    }

    public static class GreaterThanOrEqualsNode<T>
    extends ComparisonNode<T> {
        public GreaterThanOrEqualsNode(Adapter<T> runtime, Expression<T> left, Expression<T> right) {
            super(runtime, left, right);
        }

        @Override
        protected T compareNumbers(T leftResult, T rightResult) {
            return this.runtime.createBoolean(this.comparisonResult(leftResult, rightResult) >= 0);
        }

        @Override
        protected String operatorToString() {
            return ">=";
        }
    }

    public static class GreaterThanNode<T>
    extends ComparisonNode<T> {
        public GreaterThanNode(Adapter<T> runtime, Expression<T> left, Expression<T> right) {
            super(runtime, left, right);
        }

        @Override
        protected T compareNumbers(T leftResult, T rightResult) {
            return this.runtime.createBoolean(this.comparisonResult(leftResult, rightResult) > 0);
        }

        @Override
        protected String operatorToString() {
            return ">";
        }
    }

    public static class NotEqualsNode<T>
    extends ComparisonNode<T> {
        public NotEqualsNode(Adapter<T> runtime, Expression<T> left, Expression<T> right) {
            super(runtime, left, right);
        }

        @Override
        protected T compareObjects(T leftResult, T rightResult) {
            return this.runtime.createBoolean(this.comparisonResult(leftResult, rightResult) != 0);
        }

        @Override
        protected T compareNumbers(T leftResult, T rightResult) {
            return this.runtime.createBoolean(this.comparisonResult(leftResult, rightResult) != 0);
        }

        @Override
        protected String operatorToString() {
            return "!=";
        }
    }

    public static class EqualsNode<T>
    extends ComparisonNode<T> {
        public EqualsNode(Adapter<T> runtime, Expression<T> left, Expression<T> right) {
            super(runtime, left, right);
        }

        @Override
        protected T compareObjects(T leftResult, T rightResult) {
            return this.runtime.createBoolean(this.comparisonResult(leftResult, rightResult) == 0);
        }

        @Override
        protected T compareNumbers(T leftResult, T rightResult) {
            return this.runtime.createBoolean(this.comparisonResult(leftResult, rightResult) == 0);
        }

        @Override
        protected String operatorToString() {
            return "==";
        }
    }
}

