/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.lib.cache;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Cache;

public class CacheSimple<K, V>
implements Cache<K, V> {
    private final V[] values;
    private final K[] keys;
    private final int sizeMinusOne;
    private int currentSize = 0;

    public CacheSimple(int miniumSize) {
        int size = Integer.highestOneBit(miniumSize);
        if (size < miniumSize) {
            size <<= 1;
        }
        this.sizeMinusOne = size - 1;
        Object[] x = new Object[size];
        this.values = x;
        Object[] z = new Object[size];
        this.keys = z;
    }

    @Override
    public void clear() {
        Arrays.fill(this.values, null);
        Arrays.fill(this.keys, null);
        this.currentSize = 0;
    }

    @Override
    public boolean containsKey(K key) {
        Objects.requireNonNull(key);
        return key.equals(this.keys[this.calcIndex(key)]);
    }

    private int calcIndex(K key) {
        return key.hashCode() & this.sizeMinusOne;
    }

    @Override
    public V getIfPresent(K key) {
        Objects.requireNonNull(key);
        int idx = this.calcIndex(key);
        if (key.equals(this.keys[idx])) {
            return this.values[idx];
        }
        return null;
    }

    @Override
    public V get(K key, Function<K, V> function) {
        boolean isExistingKeyNotNull;
        Objects.requireNonNull(key);
        Objects.requireNonNull(function);
        int idx = this.calcIndex(key);
        boolean bl = isExistingKeyNotNull = this.keys[idx] != null;
        if (isExistingKeyNotNull && this.keys[idx].equals(key)) {
            return this.values[idx];
        }
        V value = function.apply(key);
        if (value != null) {
            this.values[idx] = value;
            if (!isExistingKeyNotNull) {
                ++this.currentSize;
            }
            this.keys[idx] = key;
        }
        return value;
    }

    @Override
    public void put(K key, V thing) {
        Objects.requireNonNull(key);
        if (thing == null) {
            this.remove(key);
            return;
        }
        int idx = this.calcIndex(key);
        if (!thing.equals(this.values[idx])) {
            this.values[idx] = thing;
        }
        if (!key.equals(this.keys[idx])) {
            if (this.keys[idx] == null) {
                ++this.currentSize;
            }
            this.keys[idx] = key;
        }
    }

    @Override
    public void remove(K key) {
        Objects.requireNonNull(key);
        int idx = this.calcIndex(key);
        if (key.equals(this.keys[idx])) {
            this.keys[idx] = null;
            this.values[idx] = null;
            --this.currentSize;
        }
    }

    @Override
    public long size() {
        return this.currentSize;
    }

    @Override
    public Iterator<K> keys() {
        return Iter.iter(Arrays.asList(this.keys)).filter(Objects::nonNull);
    }

    @Override
    public boolean isEmpty() {
        return this.currentSize == 0;
    }

    int getAllocatedSize() {
        return this.keys.length;
    }
}

