/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mailbox.tools.indexer;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.apache.james.json.DTOModule;
import org.apache.james.server.task.json.dto.TaskDTO;
import org.apache.james.server.task.json.dto.TaskDTOModule;
import org.apache.mailbox.tools.indexer.RunningOptionsDTO;
import org.apache.mailbox.tools.indexer.SingleMailboxReindexingTask;

public class SingleMailboxReindexingTaskDTO
implements TaskDTO {
    private final String type;
    private final String mailboxId;
    private final Optional<RunningOptionsDTO> runningOptions;

    private static SingleMailboxReindexingTaskDTO of(SingleMailboxReindexingTask task, String typeName) {
        return new SingleMailboxReindexingTaskDTO(typeName, task.getMailboxId().serialize(), Optional.of(RunningOptionsDTO.toDTO(task.getRunningOptions())));
    }

    public static TaskDTOModule<SingleMailboxReindexingTask, SingleMailboxReindexingTaskDTO> module(SingleMailboxReindexingTask.Factory factory) {
        return (TaskDTOModule)DTOModule.forDomainObject(SingleMailboxReindexingTask.class).convertToDTO(SingleMailboxReindexingTaskDTO.class).toDomainObjectConverter(factory::create).toDTOConverter(SingleMailboxReindexingTaskDTO::of).typeName(SingleMailboxReindexingTask.TYPE.asString()).withFactory(TaskDTOModule::new);
    }

    public SingleMailboxReindexingTaskDTO(@JsonProperty(value="type") String type, @JsonProperty(value="mailboxId") String mailboxId, @JsonProperty(value="runningOptions") Optional<RunningOptionsDTO> runningOptions) {
        this.type = type;
        this.mailboxId = mailboxId;
        this.runningOptions = runningOptions;
    }

    public String getType() {
        return this.type;
    }

    public String getMailboxId() {
        return this.mailboxId;
    }

    public Optional<RunningOptionsDTO> getRunningOptions() {
        return this.runningOptions;
    }
}

