/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.mail;

import java.util.UUID;
import org.apache.james.backends.postgres.PostgresDataDefinition;
import org.apache.james.backends.postgres.PostgresIndex;
import org.apache.james.backends.postgres.PostgresTable;
import org.jooq.Constraint;
import org.jooq.DataType;
import org.jooq.Field;
import org.jooq.OrderField;
import org.jooq.Record;
import org.jooq.Table;
import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

public interface PostgresMailboxMemberDataDefinition {
    public static final PostgresDataDefinition MODULE = PostgresDataDefinition.builder().addTable(new PostgresTable[]{PostgresMailboxMemberTable.TABLE}).addIndex(new PostgresIndex[]{PostgresMailboxMemberTable.MAILBOX_MEMBER_USERNAME_INDEX}).build();

    public static interface PostgresMailboxMemberTable {
        public static final Table<Record> TABLE_NAME = DSL.table((String)"mailbox_member");
        public static final Field<String> USER_NAME = DSL.field((String)"user_name", (DataType)SQLDataType.VARCHAR((int)255));
        public static final Field<UUID> MAILBOX_ID = DSL.field((String)"mailbox_id", (DataType)SQLDataType.UUID.notNull());
        public static final PostgresTable TABLE = PostgresTable.name((String)TABLE_NAME.getName()).createTableStep((dsl, tableName) -> dsl.createTableIfNotExists(tableName).column(USER_NAME).column(MAILBOX_ID).constraint((Constraint)DSL.primaryKey((Field[])new Field[]{USER_NAME, MAILBOX_ID}))).supportsRowLevelSecurity().build();
        public static final PostgresIndex MAILBOX_MEMBER_USERNAME_INDEX = PostgresIndex.name((String)"mailbox_member_username_index").createIndexStep((dsl, indexName) -> dsl.createIndexIfNotExists(indexName).on(TABLE_NAME, new OrderField[]{USER_NAME}));
    }
}

