/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.tools;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.DereferencePolicy;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.IntermediateResponse;
import com.unboundid.ldap.sdk.IntermediateResponseListener;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPSearchException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.RootDSE;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResult;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchResultReference;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.unboundidds.extensions.StreamDirectoryValuesExtendedRequest;
import com.unboundid.ldap.sdk.unboundidds.extensions.StreamDirectoryValuesIntermediateResponse;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPDiff;
import com.unboundid.ldap.sdk.unboundidds.tools.LDAPDiffCompactDN;
import com.unboundid.ldap.sdk.unboundidds.tools.ToolMessages;
import com.unboundid.util.DNFileReader;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

final class LDAPDiffDNDumper
extends Thread
implements SearchResultListener,
IntermediateResponseListener {
    private static final long serialVersionUID = -6528470329756007939L;
    @NotNull
    private final AtomicReference<Boolean> streamValuesIntermediateResponseErrorEncounteredRef;
    @NotNull
    private final AtomicReference<LDAPException> exceptionRef;
    private final boolean missingOnly;
    private final boolean quiet;
    @NotNull
    private final DN baseDN;
    @Nullable
    private final File dnFile;
    @NotNull
    private final Filter filter;
    @NotNull
    private final List<DN> excludeBranches;
    private long lastProgressValue;
    @NotNull
    private final LDAPConnectionPool connectionPool;
    @NotNull
    private final LDAPDiff ldapDiff;
    @Nullable
    private final Schema schema;
    @NotNull
    private final SearchScope scope;
    @NotNull
    private final TreeSet<LDAPDiffCompactDN> dnSet;

    LDAPDiffDNDumper(@NotNull LDAPDiff ldapDiff, @NotNull String name, @Nullable File dnFile, @NotNull LDAPConnectionPool connectionPool, @NotNull DN baseDN, @NotNull SearchScope scope, @NotNull List<DN> excludeBranches, @NotNull Filter filter, @Nullable Schema schema, boolean missingOnly, boolean quiet, @NotNull TreeSet<LDAPDiffCompactDN> dnSet) {
        super(name);
        this.setDaemon(true);
        this.ldapDiff = ldapDiff;
        this.dnFile = dnFile;
        this.connectionPool = connectionPool;
        this.baseDN = baseDN;
        this.scope = scope;
        this.excludeBranches = excludeBranches;
        this.filter = filter;
        this.schema = schema;
        this.missingOnly = missingOnly;
        this.quiet = quiet;
        this.dnSet = dnSet;
        this.lastProgressValue = 0L;
        this.streamValuesIntermediateResponseErrorEncounteredRef = new AtomicReference();
        this.exceptionRef = new AtomicReference();
    }

    @Nullable
    LDAPException getProcessingException() {
        return this.exceptionRef.get();
    }

    @Override
    public void run() {
        if (this.dnFile != null) {
            this.readDNsFromFile();
        } else {
            this.readDNsFromLDAP();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readDNsFromFile() {
        try {
            DNFileReader dnFileReader = new DNFileReader(this.dnFile);
            while (true) {
                DN dn;
                try {
                    dn = dnFileReader.readDN();
                }
                catch (LDAPException e) {
                    Debug.debugException(e);
                    this.exceptionRef.set(e);
                    return;
                }
                if (dn == null) {
                    return;
                }
                if (!dn.matchesBaseAndScope(this.baseDN, this.scope) || this.isWithinExcludeBranch(dn)) continue;
                TreeSet<LDAPDiffCompactDN> treeSet = this.dnSet;
                synchronized (treeSet) {
                    LDAPDiffCompactDN compactDN = new LDAPDiffCompactDN(dn, this.baseDN);
                    if (this.missingOnly && this.dnSet.contains(compactDN)) {
                        this.dnSet.remove(compactDN);
                    } else {
                        this.dnSet.add(new LDAPDiffCompactDN(dn, this.baseDN));
                        if (!this.quiet && (long)this.dnSet.size() != this.lastProgressValue && this.dnSet.size() % 1000 == 0) {
                            this.lastProgressValue = this.dnSet.size();
                            this.ldapDiff.wrapOut(0, LDAPDiff.WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_DN_DUMPER_PROGRESS.get(this.dnSet.size()));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.exceptionRef.set(new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_LDAP_DIFF_DN_DUMPER_ERROR_READING_FROM_FILE.get(this.dnFile.getAbsolutePath(), StaticUtils.getExceptionMessage(e)), e));
            return;
        }
    }

    private void readDNsFromLDAP() {
        SearchResult searchResult;
        if (this.readDNsWithStreamValues()) {
            return;
        }
        try {
            SearchRequest searchRequest = new SearchRequest((SearchResultListener)this, this.baseDN.toString(), this.scope, DereferencePolicy.NEVER, 0, 0, false, this.filter, "1.1");
            searchResult = this.connectionPool.search(searchRequest);
        }
        catch (LDAPSearchException e) {
            Debug.debugException(e);
            searchResult = e.getSearchResult();
        }
        switch (searchResult.getResultCode().intValue()) {
            case 0: {
                break;
            }
            case 32: {
                break;
            }
            case 10: {
                this.exceptionRef.compareAndSet(null, new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_LDAP_DIFF_SEARCH_FAILED_WITH_REFERRAL.get(Arrays.toString(searchResult.getReferralURLs()))));
                break;
            }
            default: {
                this.exceptionRef.compareAndSet(null, new LDAPException(searchResult.getResultCode(), ToolMessages.ERR_LDAP_DIFF_SEARCH_FAILED.get(String.valueOf(searchResult))));
            }
        }
    }

    private boolean readDNsWithStreamValues() {
        try {
            if (!this.filter.equals(Filter.createPresenceFilter("objectClass"))) {
                return false;
            }
            RootDSE rootDSE = this.connectionPool.getRootDSE();
            if (rootDSE == null) {
                return false;
            }
            if (!rootDSE.supportsExtendedOperation("1.3.6.1.4.1.30221.2.6.6")) {
                return false;
            }
            boolean withinNamingContext = false;
            String[] namingContextDNs = rootDSE.getNamingContextDNs();
            if (namingContextDNs != null) {
                for (String namingContextDN : namingContextDNs) {
                    if (!this.baseDN.isDescendantOf(new DN(namingContextDN, this.schema), true)) continue;
                    withinNamingContext = true;
                    break;
                }
            }
            if (!withinNamingContext) {
                return false;
            }
            StreamDirectoryValuesExtendedRequest streamValuesRequest = new StreamDirectoryValuesExtendedRequest(this.baseDN.toString(), this.scope, false, null, 1000, new Control[0]);
            streamValuesRequest.setIntermediateResponseListener(this);
            ExtendedResult streamValuesResult = this.connectionPool.processExtendedOperation(streamValuesRequest);
            if (streamValuesResult.getResultCode() == ResultCode.SUCCESS) {
                return this.streamValuesIntermediateResponseErrorEncounteredRef.get() == null;
            }
            if (Debug.debugEnabled()) {
                Debug.debug(Level.WARNING, DebugType.LDAP, "The server returned non-success result " + streamValuesResult + " in response to stream directory values extended request " + streamValuesRequest + ".  Falling back to searching for entries to examine.");
            }
            return false;
        }
        catch (Exception e) {
            Debug.debugException(e);
            return false;
        }
    }

    private boolean isWithinExcludeBranch(@NotNull DN dn) {
        for (DN excludeBranch : this.excludeBranches) {
            if (!dn.isDescendantOf(excludeBranch, true)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void searchEntryReturned(@NotNull SearchResultEntry searchEntry) {
        block8: {
            try {
                DN dn = searchEntry.getParsedDN();
                if (!dn.matchesBaseAndScope(this.baseDN, this.scope) || this.isWithinExcludeBranch(dn)) break block8;
                LDAPDiffCompactDN compactDN = new LDAPDiffCompactDN(dn, this.baseDN);
                TreeSet<LDAPDiffCompactDN> treeSet = this.dnSet;
                synchronized (treeSet) {
                    if (this.missingOnly && this.dnSet.contains(compactDN)) {
                        this.dnSet.remove(compactDN);
                    } else {
                        this.dnSet.add(compactDN);
                        if (!this.quiet && (long)this.dnSet.size() != this.lastProgressValue && this.dnSet.size() % 1000 == 0) {
                            this.lastProgressValue = this.dnSet.size();
                            this.ldapDiff.wrapOut(0, LDAPDiff.WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_DN_DUMPER_PROGRESS.get(this.dnSet.size()));
                        }
                    }
                }
            }
            catch (LDAPException e) {
                Debug.debugException(e);
                this.exceptionRef.compareAndSet(null, new LDAPException(e.getResultCode(), ToolMessages.ERR_LDAP_DIFF_SEARCH_ENTRY_ERROR.get(searchEntry.getDN(), StaticUtils.getExceptionMessage(e)), e));
            }
        }
    }

    @Override
    public void searchReferenceReturned(@NotNull SearchResultReference searchReference) {
        this.exceptionRef.compareAndSet(null, new LDAPException(ResultCode.LOCAL_ERROR, ToolMessages.ERR_LDAP_DIFF_REFERENCE_ENCOUNTERED.get(String.valueOf(searchReference))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intermediateResponseReturned(@NotNull IntermediateResponse intermediateResponse) {
        if (this.streamValuesIntermediateResponseErrorEncounteredRef.get() != null) {
            return;
        }
        try {
            StreamDirectoryValuesIntermediateResponse streamValuesIR = new StreamDirectoryValuesIntermediateResponse(intermediateResponse);
            List<ASN1OctetString> valueOctetStrings = streamValuesIR.getValues();
            ArrayList<LDAPDiffCompactDN> compactDNs = new ArrayList<LDAPDiffCompactDN>(valueOctetStrings.size());
            for (ASN1OctetString valueOctetString : valueOctetStrings) {
                DN dn = new DN(valueOctetString.stringValue(), this.schema);
                if (!dn.matchesBaseAndScope(this.baseDN, this.scope) || this.isWithinExcludeBranch(dn)) continue;
                compactDNs.add(new LDAPDiffCompactDN(dn, this.baseDN));
            }
            TreeSet<LDAPDiffCompactDN> treeSet = this.dnSet;
            synchronized (treeSet) {
                for (LDAPDiffCompactDN compactDN : compactDNs) {
                    if (this.missingOnly && this.dnSet.contains(compactDN)) {
                        this.dnSet.remove(compactDN);
                        continue;
                    }
                    this.dnSet.add(compactDN);
                    if (this.quiet || (long)this.dnSet.size() == this.lastProgressValue || this.dnSet.size() % 1000 != 0) continue;
                    this.lastProgressValue = this.dnSet.size();
                    this.ldapDiff.wrapOut(0, LDAPDiff.WRAP_COLUMN, ToolMessages.INFO_LDAP_DIFF_DN_DUMPER_PROGRESS.get(this.dnSet.size()));
                }
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            this.streamValuesIntermediateResponseErrorEncounteredRef.set(Boolean.TRUE);
        }
    }
}

