/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import java.net.URL;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.jwt.OidcJwtTokenVerifier;
import org.apache.james.jwt.introspection.IntrospectionEndpoint;
import org.apache.james.mailbox.Authorizator;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.protocols.api.OIDCSASLParser;
import org.apache.james.protocols.api.OidcSASLConfiguration;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.hook.AuthHook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class UsersRepositoryAuthHook
implements AuthHook {
    private static final Logger LOGGER = LoggerFactory.getLogger(UsersRepositoryAuthHook.class);
    private final UsersRepository users;
    private final Authorizator authorizator;

    @Inject
    public UsersRepositoryAuthHook(UsersRepository users, Authorizator authorizator) {
        this.users = users;
        this.authorizator = authorizator;
    }

    public HookResult doAuth(SMTPSession session, Username username, String password) {
        try {
            if (this.users.test(username, password)) {
                session.setUsername(username);
                session.setRelayingAllowed(true);
                return HookResult.builder().hookReturnCode(HookReturnCode.ok()).smtpDescription("Authentication Successful").build();
            }
        }
        catch (UsersRepositoryException e) {
            LOGGER.info("Unable to access UsersRepository", (Throwable)e);
        }
        return HookResult.DECLINED;
    }

    public HookResult doSasl(SMTPSession session, OidcSASLConfiguration configuration, String initialResponse) {
        return OIDCSASLParser.parse((String)initialResponse).flatMap(oidcInitialResponseValue -> this.validateToken(configuration, oidcInitialResponseValue.getToken()).map(authenticatedUser -> {
            Username associatedUser = Username.of((String)oidcInitialResponseValue.getAssociatedUser());
            if (!associatedUser.equals(authenticatedUser)) {
                return this.doAuthWithDelegation(session, (Username)authenticatedUser, associatedUser);
            }
            return this.saslSuccess(session, (Username)authenticatedUser);
        })).orElse(HookResult.DECLINED);
    }

    private HookResult doAuthWithDelegation(SMTPSession session, Username authenticatedUser, Username associatedUser) {
        try {
            if (Authorizator.AuthorizationState.ALLOWED.equals((Object)this.authorizator.user(authenticatedUser).canLoginAs(associatedUser))) {
                return this.saslSuccess(session, associatedUser);
            }
        }
        catch (MailboxException e) {
            LOGGER.info("Unable to authorization", (Throwable)e);
        }
        return HookResult.DECLINED;
    }

    private HookResult saslSuccess(SMTPSession session, Username username) {
        try {
            this.users.assertValid(username);
            session.setUsername(username);
            session.setRelayingAllowed(true);
            return HookResult.builder().hookReturnCode(HookReturnCode.ok()).smtpDescription("Authentication successful.").build();
        }
        catch (UsersRepositoryException e) {
            LOGGER.warn("Invalid username", (Throwable)e);
            return HookResult.DECLINED;
        }
    }

    private Optional<Username> validateToken(OidcSASLConfiguration oidcSASLConfiguration, String token) {
        if (oidcSASLConfiguration.isCheckTokenByIntrospectionEndpoint()) {
            return UsersRepositoryAuthHook.validTokenWithIntrospection(oidcSASLConfiguration, token);
        }
        if (oidcSASLConfiguration.isCheckTokenByUserinfoEndpoint()) {
            return this.validTokenWithUserInfo(oidcSASLConfiguration, token);
        }
        return OidcJwtTokenVerifier.verifySignatureAndExtractClaim((String)token, (URL)oidcSASLConfiguration.getJwksURL(), (String)oidcSASLConfiguration.getClaim()).map(Username::of);
    }

    private Optional<Username> validTokenWithUserInfo(OidcSASLConfiguration oidcSASLConfiguration, String token) {
        return Mono.from((Publisher)OidcJwtTokenVerifier.verifyWithUserinfo((String)token, (URL)oidcSASLConfiguration.getJwksURL(), (String)oidcSASLConfiguration.getClaim(), (URL)((URL)oidcSASLConfiguration.getUserInfoEndpoint().orElseThrow()))).blockOptional().map(Username::of);
    }

    private static Optional<Username> validTokenWithIntrospection(OidcSASLConfiguration oidcSASLConfiguration, String token) {
        return Mono.from((Publisher)OidcJwtTokenVerifier.verifyWithIntrospection((String)token, (URL)oidcSASLConfiguration.getJwksURL(), (String)oidcSASLConfiguration.getClaim(), (IntrospectionEndpoint)oidcSASLConfiguration.getIntrospectionEndpoint().map(endpoint -> new IntrospectionEndpoint(endpoint, oidcSASLConfiguration.getIntrospectionEndpointAuthorization())).orElseThrow())).blockOptional().map(Username::of);
    }
}

