/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.util.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCUtil.class);

    public boolean tableExists(DatabaseMetaData dbMetaData, String tableName) throws SQLException {
        return this.tableExistsCaseSensitive(dbMetaData, tableName) || this.tableExistsCaseSensitive(dbMetaData, tableName.toUpperCase(Locale.US)) || this.tableExistsCaseSensitive(dbMetaData, tableName.toLowerCase(Locale.US));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExistsCaseSensitive(DatabaseMetaData dbMetaData, String tableName) throws SQLException {
        ResultSet rsTables = dbMetaData.getTables(null, null, tableName, null);
        try {
            boolean bl = rsTables.next();
            return bl;
        }
        finally {
            this.closeJDBCResultSet(rsTables);
        }
    }

    public boolean columnExists(DatabaseMetaData dbMetaData, String tableName, String columnName) throws SQLException {
        return this.columnExistsCaseSensitive(dbMetaData, tableName, columnName) || this.columnExistsCaseSensitive(dbMetaData, tableName, columnName.toUpperCase(Locale.US)) || this.columnExistsCaseSensitive(dbMetaData, tableName, columnName.toLowerCase(Locale.US)) || this.columnExistsCaseSensitive(dbMetaData, tableName.toUpperCase(Locale.US), columnName) || this.columnExistsCaseSensitive(dbMetaData, tableName.toUpperCase(Locale.US), columnName.toUpperCase(Locale.US)) || this.columnExistsCaseSensitive(dbMetaData, tableName.toUpperCase(Locale.US), columnName.toLowerCase(Locale.US)) || this.columnExistsCaseSensitive(dbMetaData, tableName.toLowerCase(Locale.US), columnName) || this.columnExistsCaseSensitive(dbMetaData, tableName.toLowerCase(Locale.US), columnName.toUpperCase(Locale.US)) || this.columnExistsCaseSensitive(dbMetaData, tableName.toLowerCase(Locale.US), columnName.toLowerCase(Locale.US));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean columnExistsCaseSensitive(DatabaseMetaData dbMetaData, String tableName, String columnName) throws SQLException {
        ResultSet rsTables = dbMetaData.getColumns(null, null, tableName, columnName);
        try {
            boolean bl = rsTables.next();
            return bl;
        }
        finally {
            this.closeJDBCResultSet(rsTables);
        }
    }

    public void closeJDBCConnection(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException sqle) {
            LOGGER.error("Unexpected exception while closing database connection.", (Throwable)sqle);
        }
    }

    public void closeJDBCStatement(Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sqle) {
            LOGGER.error("Unexpected exception while closing database statement.", (Throwable)sqle);
        }
    }

    public void closeJDBCResultSet(ResultSet aResultSet) {
        try {
            if (aResultSet != null) {
                aResultSet.close();
            }
        }
        catch (SQLException sqle) {
            LOGGER.error("Unexpected exception while closing database result set.", (Throwable)sqle);
        }
    }
}

