/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.domainlist.lib;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.james.core.Domain;
import org.apache.james.domainlist.api.DomainList;
import org.apache.james.domainlist.api.DomainListException;
import org.apache.james.domainlist.api.DomainListManagementMBean;

public class DomainListManagement
extends StandardMBean
implements DomainListManagementMBean {
    private DomainList domainList;

    public DomainListManagement() throws NotCompliantMBeanException {
        super(DomainListManagementMBean.class);
    }

    @Inject
    public void setDomainList(DomainList domainList) {
        this.domainList = domainList;
    }

    public void addDomain(String domain) throws Exception {
        try {
            this.domainList.addDomain(Domain.of((String)domain));
        }
        catch (DomainListException e) {
            throw new Exception(e.getMessage());
        }
    }

    public boolean containsDomain(String domain) throws Exception {
        try {
            return this.domainList.containsDomain(Domain.of((String)domain));
        }
        catch (DomainListException e) {
            throw new Exception(e.getMessage());
        }
    }

    public List<String> getDomains() throws Exception {
        try {
            return (List)this.domainList.getDomains().stream().map(Domain::name).collect(ImmutableList.toImmutableList());
        }
        catch (DomainListException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void removeDomain(String domain) throws Exception {
        try {
            this.domainList.removeDomain(Domain.of((String)domain));
        }
        catch (DomainListException e) {
            throw new Exception(e.getMessage());
        }
    }

    public String getDefaultDomain() throws Exception {
        try {
            return Optional.ofNullable(this.domainList.getDefaultDomain()).map(Domain::name).orElse(null);
        }
        catch (DomainListException e) {
            throw new Exception(e.getMessage());
        }
    }
}

